/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CloseProject
extends ProjectAction
implements PropertyChangeListener {
    private static final String namePattern = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CloseProject.class, (String)"LBL_CloseProjectAction_Popup_Name");
    private String popupName;
    private PropertyChangeListener wpcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault());

    public CloseProject() {
        this((Lookup)null);
    }

    public CloseProject(Lookup lookup) {
        super((String)null, namePattern, namePatternPopup, null, lookup);
        OpenProjectList.getDefault().addPropertyChangeListener(this.wpcl);
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        OpenProjectList.getDefault().close(projectArray, true);
    }

    public void refresh(Lookup lookup) {
        super.refresh(lookup);
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length == 0 || !OpenProjectList.getDefault().isOpen(projectArray[0])) {
            this.enable(false);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, new Project[0]);
        } else {
            this.enable(true);
            this.popupName = ActionsUtil.formatProjectSensitiveName(namePatternPopup, projectArray);
        }
    }

    private void enable(final boolean bl) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CloseProject.this.setEnabled(bl);
                }
            });
        } else {
            this.setEnabled(bl);
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new CloseProject(lookup);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh(this.getLookup());
    }
}

