/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.methoid;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JOptionPane;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xslt.mapper.methoid.AbstractLiteralUpdater;
import org.netbeans.modules.xslt.mapper.methoid.StringLiteralUpdater;
import org.netbeans.modules.xslt.mapper.model.nodes.LiteralCanvasNode;
import org.netbeans.modules.xslt.mapper.xpatheditor.XPathLiteralEditor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class XPathLiteralUpdater
extends AbstractLiteralUpdater {
    public ILiteralEditor getEditor(IBasicMapper iBasicMapper, IFieldNode iFieldNode) {
        return new XPathLiteralEditor(XPathLiteralUpdater.getWindowOwner(iBasicMapper), iBasicMapper, iFieldNode, this);
    }

    private static Window getWindowOwner(IBasicMapper iBasicMapper) {
        Component component;
        Object var1_1 = null;
        for (component = iBasicMapper.getMapperViewManager().getCanvasView().getCanvas().getUIComponent(); component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component == null) {
            component = WindowManager.getDefault().getMainWindow();
        }
        return (Window)component;
    }

    public String getLiteralDisplayText(String string) {
        return this.getQuotedString((String)string).string;
    }

    public String literalSet(IFieldNode iFieldNode, String string) {
        if (!this.isValidStringLiteral(string)) {
            String string2 = NbBundle.getMessage(StringLiteralUpdater.class, (String)"STR_INVALID_STRING_LITERAL_TITLE");
            String string3 = NbBundle.getMessage(StringLiteralUpdater.class, (String)"STR_INVALID_STRING_LITERAL_MSG", (Object)string);
            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), string3, string2, 0);
            return null;
        }
        LiteralCanvasNode literalCanvasNode = (LiteralCanvasNode)iFieldNode.getGroupNode().getNodeObject();
        if (literalCanvasNode != null) {
            XPathExpression xPathExpression = null;
            XPathModel xPathModel = AbstractXPathModelHelper.getInstance().newXPathModel();
            try {
                xPathExpression = xPathModel.parseExpression(string);
            }
            catch (XPathException xPathException) {
                xPathExpression = AbstractXPathModelHelper.getInstance().newXPathStringLiteral(string);
            }
            if (xPathExpression != null) {
                literalCanvasNode.setDataObject(xPathExpression);
            }
        }
        this.mProcessor.updateNodeExpression(iFieldNode);
        return string;
    }

    private boolean isValidStringLiteral(String string) {
        QuotedString quotedString = this.getQuotedString(string);
        return quotedString.quote.isQuotingValid(quotedString.string);
    }

    private QuotedString getQuotedString(String string) {
        QuoteType quoteType = QuoteType.getQuoteType(string);
        if (quoteType == QuoteType.UNQUOTED) {
            if (string.indexOf(QuoteType.SINGLE.quote) >= 0) {
                string = QuoteType.DOUBLE.quote + string + QuoteType.DOUBLE.quote;
                quoteType = QuoteType.DOUBLE;
            } else {
                string = QuoteType.SINGLE.quote + string + QuoteType.SINGLE.quote;
                quoteType = QuoteType.SINGLE;
            }
        }
        return new QuotedString(string, quoteType);
    }

    private static final class QuoteType {
        private static final QuoteType SINGLE = new QuoteType("'");
        private static final QuoteType DOUBLE = new QuoteType("\"");
        private static final QuoteType UNQUOTED = new QuoteType();
        public final String quote;

        private QuoteType(String string) {
            this.quote = string;
        }

        private QuoteType() {
            this.quote = null;
        }

        public boolean isStringQuoted(String string) {
            if (this.quote == null) {
                return false;
            }
            return string.length() >= 2 && string.startsWith(this.quote) && string.endsWith(this.quote);
        }

        public boolean isQuotingValid(String string) {
            if (this.quote == null) {
                return false;
            }
            String[] stringArray = string.split(this.quote, 4);
            return stringArray.length == 3;
        }

        public static QuoteType getQuoteType(String string) {
            QuoteType quoteType = UNQUOTED;
            if (SINGLE.isStringQuoted(string)) {
                quoteType = SINGLE;
            } else if (DOUBLE.isStringQuoted(string)) {
                quoteType = DOUBLE;
            }
            return quoteType;
        }
    }

    private static final class QuotedString {
        public final String string;
        public final QuoteType quote;

        public QuotedString(String string, QuoteType quoteType) {
            this.string = string;
            this.quote = quoteType;
        }
    }
}

