/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeExpandedState {
    private JTree tree;
    private ArrayList<ArrayList<Step>> expanedNodes = new ArrayList();

    public TreeExpandedState(JTree jTree) {
        this.tree = jTree;
    }

    public void save() {
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        TreePath treePath = TreeNode.getTreePath(treeNode);
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                ArrayList<Step> arrayList = this.getStepsByTreePath(treePath2);
                this.expanedNodes.add(arrayList);
            }
        }
    }

    public void restore() {
        for (ArrayList<Step> arrayList : this.expanedNodes) {
            TreePath treePath = this.getTreePathbySteps(arrayList);
            if (treePath == null) continue;
            this.tree.expandPath(treePath);
        }
    }

    private ArrayList<Step> getStepsByTreePath(TreePath treePath) {
        ArrayList<Step> arrayList = new ArrayList<Step>();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            TreeNode treeNode = (TreeNode)treePath.getPathComponent(i);
            String string = treeNode.toString();
            TreeNode treeNode2 = treeNode.getParent();
            int n = 0;
            if (treeNode2 != null) {
                List<TreeNode> list = treeNode2.getChildren();
                for (TreeNode treeNode3 : list) {
                    String string2 = treeNode3.toString();
                    if (!string2.equals(string)) continue;
                    if (treeNode == treeNode3) break;
                    ++n;
                }
            }
            arrayList.add(new Step(string, n));
        }
        return arrayList;
    }

    private TreePath getTreePathbySteps(ArrayList<Step> arrayList) {
        TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
        if (treeNode == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (!arrayList.get(0).getName().equals(treeNode.toString())) {
            return null;
        }
        Iterator<Step> iterator = arrayList.iterator();
        TreePath treePath = new TreePath(treeNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            Step step = arrayList.get(i);
            List<TreeNode> list = treeNode.getChildren();
            if ((treeNode = this.getTreeNodeByStep(list, step)) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(treeNode);
        }
        return treePath;
    }

    private TreeNode getTreeNodeByStep(List<TreeNode> list, Step step) {
        int n = 0;
        for (TreeNode treeNode : list) {
            if (!step.getName().equals(treeNode.toString())) continue;
            if (n == step.index) {
                return treeNode;
            }
            ++n;
        }
        return null;
    }

    private class Step {
        protected String name;
        protected int index;

        public Step(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }
    }
}

