/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.xpatheditor;

import java.awt.Dialog;
import java.awt.Window;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperLiteralUpdateEventInfo;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.xslt.mapper.xpatheditor.ExpressionEditor;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XPathLiteralEditor
implements ILiteralEditor {
    private Window mOwner;
    private IBasicMapper mBasicMapper;
    private IFieldNode mFieldNode;
    private ILiteralUpdater mUpdateListener;
    private IMethoidNode mMethoidNode;
    private IMethoid mMethoid;

    public XPathLiteralEditor(Window window, IBasicMapper iBasicMapper, IFieldNode iFieldNode, ILiteralUpdater iLiteralUpdater) {
        this.mOwner = window;
        this.mBasicMapper = iBasicMapper;
        this.mFieldNode = iFieldNode;
        this.mUpdateListener = iLiteralUpdater;
        this.mMethoidNode = (IMethoidNode)this.mFieldNode.getGroupNode();
        this.mMethoid = (IMethoid)this.mMethoidNode.getMethoidObject();
    }

    public void show() {
        ExpressionEditor expressionEditor = new ExpressionEditor(this.mBasicMapper);
        expressionEditor.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExpressionEditor.class, (String)"ACSD_LBL_XPath_ExpressionBuilder"));
        String string = this.mFieldNode.getLiteralName();
        if (string != null && string.length() > 0) {
            expressionEditor.setSelectedValue(string);
        }
        String string2 = NbBundle.getMessage(ExpressionEditor.class, (String)"TITLE_ExpressionBuilder");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)expressionEditor, string2);
        defaultDialogDescriptor.setHelpCtx(new HelpCtx("xslt_editor_xpath"));
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        dialog.setVisible(true);
        if (!defaultDialogDescriptor.isOkHasPressed()) {
            return;
        }
        String string3 = expressionEditor.getSelectedValue();
        if (null == string3) {
            string3 = "";
        }
        this.fireLiteralUpdated(string3);
    }

    public ILiteralUpdater getUpdateListener() {
        return this.mUpdateListener;
    }

    private void fireLiteralUpdated(final String string) {
        this.mBasicMapper.updateFieldLiteral(new IBasicMapperLiteralUpdateEventInfo(){

            public ILiteralUpdater getLiteralUpdater() {
                return XPathLiteralEditor.this.mUpdateListener;
            }

            public IMethoidNode getMethoidNode() {
                return XPathLiteralEditor.this.mMethoidNode;
            }

            public IFieldNode getFieldNode() {
                return XPathLiteralEditor.this.mFieldNode;
            }

            public String getNewValue() {
                return string;
            }

            public boolean isLiteralMethoid() {
                return XPathLiteralEditor.this.mMethoid.isLiteral();
            }
        });
    }
}

