/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.lib;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.lib.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public final class GuiUtil {
    private GuiUtil() {
    }

    public static void performDefaultAction(FileObject fileObject) {
        DataObject dataObject;
        if (fileObject == null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("FileObject can not be null.", new IllegalArgumentException());
            }
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("DataObject not found", dataObjectNotFoundException);
            }
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                Node node = dataObject.getNodeDelegate();
                Action action = node.getPreferredAction();
                if (action != null) {
                    action.actionPerformed(new ActionEvent(node, 1001, ""));
                }
            }
        });
    }

    public static boolean confirmAction(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return object == NotifyDescriptor.YES_OPTION;
    }

    public static void setStatusText(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    public static void notifyException(Throwable throwable) {
        GuiUtil.notifyException(null, throwable);
    }

    public static void notifyException(String string, Throwable throwable) {
        ErrorManager errorManager = ErrorManager.getDefault();
        if (string != null) {
            errorManager.annotate(throwable, string);
        }
        errorManager.notify(4096, throwable);
    }

    public static void notifyWarning(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    public static void notifyError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            }
        });
    }
}

