/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.sync;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.Document;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.cookies.CookieManagerCookie;
import org.netbeans.modules.xml.lib.Util;
import org.netbeans.modules.xml.sync.FileRepresentation;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.sync.SyncSupport;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class DataObjectSyncSupport
extends SyncSupport
implements Synchronizator {
    private final Vector reps = new Vector(3);
    private final CookieManagerCookie cookieMgr;

    public DataObjectSyncSupport(XMLDataObjectLook xMLDataObjectLook) {
        super((DataObject)xMLDataObjectLook);
        this.cookieMgr = xMLDataObjectLook.getCookieManager();
        FileRepresentation fileRepresentation = new FileRepresentation(this.getDO(), this);
        this.reps.add(fileRepresentation);
    }

    public void representationChanged(Class clazz) {
        super.representationChanged(clazz);
    }

    protected Representation[] getRepresentations() {
        return this.reps.toArray(new Representation[0]);
    }

    public Representation getPrimaryRepresentation() {
        Class[] classArray = new Class[]{Document.class, FileObject.class};
        Representation[] representationArray = this.getRepresentations();
        for (int i = 0; i < classArray.length; ++i) {
            for (int j = 0; j < representationArray.length; ++j) {
                Representation representation = representationArray[j];
                if (!representation.isValid() || !representation.represents(classArray[i])) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Primary rep = " + representation);
                }
                return representation;
            }
        }
        throw new IllegalStateException("No primary representation found: " + this.reps);
    }

    public void addRepresentation(Representation representation) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync addRepresentation " + representation);
        }
        if (representation.represents(Document.class)) {
            Iterator iterator = this.reps.iterator();
            while (iterator.hasNext()) {
                Representation representation2 = (Representation)iterator.next();
                if (!representation2.represents(FileObject.class)) continue;
                iterator.remove();
            }
        } else if (representation.level() > 1) {
            this.loadTextRepresentation();
        }
        this.reps.add(representation);
    }

    public void removeRepresentation(Representation representation) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync removeRepresentation " + representation);
        }
        boolean bl = false;
        if (representation.represents(Document.class)) {
            for (Representation representation2 : this.reps) {
                if (representation2.level() <= 1) continue;
                bl = true;
            }
            if (!bl) {
                FileRepresentation fileRepresentation = new FileRepresentation(this.getDO(), this);
                this.reps.add(fileRepresentation);
            } else {
                this.loadTextRepresentation();
            }
        }
        this.reps.remove(representation);
        if (bl) {
            this.representationChanged(Document.class);
        }
    }

    private void loadTextRepresentation() {
        if (this.getDO().isValid()) {
            try {
                EditorCookie editorCookie = (EditorCookie)this.getDO().getCookie(EditorCookie.class);
                editorCookie.openDocument();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

