/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette;

import com.sun.rave.designtime.BeanCreateInfo;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.Result;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.visualweb.palette.api.PaletteItemInfoCookie;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteItemDataObject
extends MultiDataObject {
    static final String XML_ROOT = "palette_item";
    static final String ATTR_VERSION = "version";
    static final String TAG_COMPONENT = "component";
    static final String ATTR_CLASSNAME = "classname";
    static final String ATTR_TYPE = "type";
    static final String TAG_CLASSPATH = "classpath";
    static final String TAG_RESOURCE = "resource";
    static final String ATTR_NAME = "name";
    static final String TAG_DESCRIPTION = "description";
    static final String ATTR_BUNDLE = "localizing-bundle";
    static final String ATTR_DISPLAY_NAME_KEY = "display-name-key";
    static final String ATTR_TOOLTIP_KEY = "tooltip-key";
    static final String ATTR_HELP_KEY = "help-key";
    static final String TAG_ICON16 = "icon16";
    static final String ATTR_URL = "urlvalue";
    static final String TAG_ICON32 = "icon32";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.visualweb.palette");
    private boolean fileLoaded;
    private String componentClassName;
    private String displayName_key;
    private String tooltip_key;
    private String help_key;
    private String bundleName;
    private String icon16URL;
    private String icon32URL;
    String displayName;
    String tooltip;
    Image icon16;
    Image icon32;

    PaletteItemDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    boolean isFileRead() {
        return this.fileLoaded;
    }

    boolean isItemValid() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        if (this.help_key == null) {
            System.out.println("Help Context Found: " + this.help_key);
            return super.getHelpCtx();
        }
        return new HelpCtx(this.help_key);
    }

    public Node createNodeDelegate() {
        return new ItemNode();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (PaletteItemInfoCookie.class.isAssignableFrom(clazz)) {
            return (T)((Node.Cookie)clazz.cast(new PaletteItemInfoImpl(this)));
        }
        return (T)((Node.Cookie)clazz.cast(super.getCookie(clazz)));
    }

    private void loadFile() {
        this.fileLoaded = true;
        FileObject fileObject = this.getPrimaryFile();
        if (fileObject.getSize() == 0L) {
            return;
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            PaletteItemHandler paletteItemHandler = new PaletteItemHandler();
            xMLReader.setContentHandler(paletteItemHandler);
            InputSource inputSource = new InputSource(this.getPrimaryFile().getURL().toExternalForm());
            xMLReader.parse(inputSource);
            if (paletteItemHandler.componentClassName != null || this.displayName_key != null) {
                String[] stringArray = null;
                String[] stringArray2 = null;
                if (paletteItemHandler.cpTypeList.size() > 0) {
                    stringArray = new String[paletteItemHandler.cpTypeList.size()];
                    paletteItemHandler.cpTypeList.toArray(stringArray);
                    stringArray2 = new String[paletteItemHandler.cpNameList.size()];
                    paletteItemHandler.cpNameList.toArray(stringArray2);
                }
                this.componentClassName = paletteItemHandler.componentClassName;
            }
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private static void setNodeAllowedActions(Object object, int n) {
        PaletteItemDataObject.invokeOnExplorerDnDManager(object, "setNodeAllowedActions", new Class[]{Integer.TYPE}, new Object[]{n});
    }

    private static void setDraggedTransferable(Object object, Transferable transferable, boolean bl) {
        PaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDraggedTransferable", new Class[]{Transferable.class, Boolean.TYPE}, new Object[]{transferable, bl});
    }

    private static void setDraggedNodes(Object object, Node[] nodeArray) {
        PaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDraggedNodes", new Class[]{Node[].class}, new Object[]{nodeArray});
    }

    private static void setDnDActive(Object object, boolean bl) {
        PaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDnDActive", new Class[]{Boolean.TYPE}, new Object[]{bl});
    }

    private static Object getExplorerDnDManager() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.view.ExplorerDnDManager", true, classLoader);
            Method method = clazz.getDeclaredMethod("getDefault", new Class[0]);
            method.setAccessible(true);
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify(1, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        return null;
    }

    private static void invokeOnExplorerDnDManager(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            Method method = object.getClass().getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify(1, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
    }

    private static class PaletteItemInfoImpl
    implements PaletteItemInfoCookie {
        private final PaletteItemDataObject pido;

        PaletteItemInfoImpl(PaletteItemDataObject paletteItemDataObject) {
            this.pido = paletteItemDataObject;
        }

        public String getClassName() {
            return this.pido.componentClassName;
        }

        public Image getIcon() {
            return this.pido.getNodeDelegate().getIcon(1);
        }

        public String getDisplayName() {
            return this.pido.getNodeDelegate().getDisplayName();
        }
    }

    private static class DisplayItemTransferable
    implements Transferable {
        private String componentClassName;
        private String displayName;
        private static final String HUMAN_NAME = NbBundle.getMessage(PaletteItemDataObject.class, (String)"HUMAN_NAME");
        private static final DataFlavor FLAVOR_DISPLAY_ITEM = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), HUMAN_NAME);

        public DisplayItemTransferable(String string, String string2) {
            this.componentClassName = string;
            this.displayName = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FLAVOR_DISPLAY_ITEM};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return FLAVOR_DISPLAY_ITEM.equals(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!FLAVOR_DISPLAY_ITEM.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return new PlainBeanCreateInfo(this.componentClassName, this.displayName);
        }
    }

    private static class PlainBeanCreateInfo
    implements BeanCreateInfo {
        private final String beanClassName;
        private final String displayName;

        public PlainBeanCreateInfo(String string, String string2) {
            this.beanClassName = string;
            this.displayName = string2;
        }

        public String getBeanClassName() {
            return this.beanClassName;
        }

        public Result beanCreatedSetup(DesignBean designBean) {
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return null;
        }

        public Image getLargeIcon() {
            return null;
        }

        public Image getSmallIcon() {
            return null;
        }

        public String getHelpKey() {
            return null;
        }
    }

    private class PaletteItemHandler
    extends DefaultHandler {
        List<String> cpTypeList;
        List<String> cpNameList;
        String componentClassName;

        private PaletteItemHandler() {
        }

        public void startDocument() throws SAXException {
            this.cpTypeList = new ArrayList<String>();
            this.cpNameList = new ArrayList<String>();
            this.componentClassName = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (PaletteItemDataObject.XML_ROOT.equals(string3)) {
                String string4 = attributes.getValue(PaletteItemDataObject.ATTR_VERSION);
                if (string4 == null) {
                    String string5 = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnknownPaletteItemVersion");
                    throw new SAXException(string5);
                }
                if (!string4.startsWith("1.")) {
                    String string6 = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnsupportedPaletteItemVersion");
                    throw new SAXException(string6);
                }
            } else if (PaletteItemDataObject.TAG_COMPONENT.equals(string3)) {
                String string7;
                this.componentClassName = string7 = attributes.getValue(PaletteItemDataObject.ATTR_CLASSNAME);
            } else if (!PaletteItemDataObject.TAG_CLASSPATH.equals(string3)) {
                String string8;
                if (PaletteItemDataObject.TAG_RESOURCE.equals(string3)) {
                    String string9 = attributes.getValue(PaletteItemDataObject.ATTR_TYPE);
                    String string10 = attributes.getValue(PaletteItemDataObject.ATTR_NAME);
                    if (string9 != null && string10 != null) {
                        this.cpTypeList.add(string9);
                        this.cpNameList.add(string10);
                    }
                } else if (PaletteItemDataObject.TAG_DESCRIPTION.equals(string3)) {
                    String string11;
                    String string12;
                    String string13;
                    String string14 = attributes.getValue(PaletteItemDataObject.ATTR_BUNDLE);
                    if (string14 != null) {
                        PaletteItemDataObject.this.bundleName = string14;
                    }
                    if ((string13 = attributes.getValue(PaletteItemDataObject.ATTR_DISPLAY_NAME_KEY)) != null) {
                        PaletteItemDataObject.this.displayName_key = string13;
                    }
                    if ((string12 = attributes.getValue(PaletteItemDataObject.ATTR_TOOLTIP_KEY)) != null) {
                        PaletteItemDataObject.this.tooltip_key = string12;
                    }
                    if ((string11 = attributes.getValue(PaletteItemDataObject.ATTR_HELP_KEY)) != null) {
                        PaletteItemDataObject.this.help_key = string11;
                    }
                } else if (PaletteItemDataObject.TAG_ICON16.equals(string3)) {
                    String string15 = attributes.getValue(PaletteItemDataObject.ATTR_URL);
                    if (string15 != null) {
                        PaletteItemDataObject.this.icon16URL = string15;
                    }
                } else if (PaletteItemDataObject.TAG_ICON32.equals(string3) && (string8 = attributes.getValue(PaletteItemDataObject.ATTR_URL)) != null) {
                    PaletteItemDataObject.this.icon32URL = string8;
                }
            }
        }
    }

    class ItemNode
    extends DataNode {
        ItemNode() {
            super((DataObject)PaletteItemDataObject.this, Children.LEAF);
        }

        public String getDisplayName() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.displayName == null) {
                PaletteItemDataObject.this.displayName = this.getExplicitDisplayName();
                if (PaletteItemDataObject.this.displayName == null) {
                    PaletteItemDataObject.this.displayName = super.getDisplayName();
                }
            }
            return PaletteItemDataObject.this.displayName;
        }

        public String getShortDescription() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.tooltip == null) {
                PaletteItemDataObject.this.tooltip = this.getExplicitTooltip();
                if (PaletteItemDataObject.this.tooltip == null) {
                    PaletteItemDataObject.this.tooltip = this.getDisplayName();
                }
            }
            return PaletteItemDataObject.this.tooltip;
        }

        public boolean canRename() {
            return true;
        }

        public Image getIcon(int n) {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (n == 2 || n == 4) {
                if (PaletteItemDataObject.this.icon32 == null) {
                    PaletteItemDataObject.this.icon32 = this.getExplicitIcon(n);
                    if (PaletteItemDataObject.this.icon32 == null) {
                        PaletteItemDataObject.this.icon32 = Utilities.loadImage((String)"org/netbeans/modules/visualweb/palette/resources/custom_component_32.png");
                    }
                }
                return PaletteItemDataObject.this.icon32;
            }
            if (PaletteItemDataObject.this.icon16 == null) {
                PaletteItemDataObject.this.icon16 = this.getExplicitIcon(n);
                if (PaletteItemDataObject.this.icon16 == null) {
                    PaletteItemDataObject.this.icon16 = Utilities.loadImage((String)"org/netbeans/modules/visualweb/palette/resources/custom_component.png");
                }
            }
            return PaletteItemDataObject.this.icon16;
        }

        public Node.PropertySet[] getPropertySets() {
            return NO_PROPERTIES;
        }

        private String getExplicitDisplayName() {
            String string = null;
            if (PaletteItemDataObject.this.displayName_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        string = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.displayName_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = PaletteItemDataObject.this.displayName_key;
                }
            }
            return string;
        }

        private String getExplicitTooltip() {
            String string = null;
            if (PaletteItemDataObject.this.tooltip_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        string = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.tooltip_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = PaletteItemDataObject.this.tooltip_key;
                }
            }
            return string;
        }

        private Image getExplicitIcon(int n) {
            if (n == 2 || n == 4) {
                if (PaletteItemDataObject.this.icon32URL != null) {
                    try {
                        return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon32URL));
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon32") != null) {
                    return super.getIcon(n);
                }
            } else if (PaletteItemDataObject.this.icon16URL != null) {
                try {
                    return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon16URL));
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null) {
                return super.getIcon(n);
            }
            return null;
        }

        public Transferable clipboardCopy() throws IOException {
            Transferable transferable = super.clipboardCopy();
            this.addPaletteFlavor(transferable);
            return transferable;
        }

        public Transferable clipboardCut() throws IOException {
            Transferable transferable = super.clipboardCut();
            this.addPaletteFlavor(transferable);
            return transferable;
        }

        public Transferable drag() throws IOException {
            Transferable transferable = super.drag();
            this.addPaletteFlavor(transferable);
            LogRecord logRecord = new LogRecord(Level.CONFIG, "COMPONENT_NAME");
            logRecord.setParameters(new Object[]{this.getDisplayName(), PaletteItemDataObject.this.componentClassName});
            logRecord.setResourceBundle(NbBundle.getBundle(ItemNode.class));
            logRecord.setResourceBundleName(ItemNode.class.getPackage().getName() + ".Bundle");
            logRecord.setLoggerName(UI_LOG.getName());
            UI_LOG.log(logRecord);
            return transferable;
        }

        private Transferable addPaletteFlavor(Transferable transferable) {
            String string = NbBundle.getMessage(PaletteItemDataObject.class, (String)"DISPLAY_ITEM_HUMAN_NAME");
            ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
            DataFlavor dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), string);
            ExTransferable.Single single = new ExTransferable.Single(dataFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    return new PlainBeanCreateInfo(PaletteItemDataObject.this.componentClassName, PaletteItemDataObject.this.displayName);
                }
            };
            exTransferable.put(single);
            return transferable;
        }
    }

    public static final class PaletteItemDataLoaderBeanInfo
    extends SimpleBeanInfo {
        private static String iconURL = "org/netbeans/modules/visualweb/palette/resources/palette_manager.png";

        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(UniFileLoader.class)};
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify((Throwable)introspectionException);
                return null;
            }
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)iconURL);
        }
    }

    public static final class PaletteItemDataLoader
    extends UniFileLoader {
        PaletteItemDataLoader() {
            super("org.netbeans.modules.visualweb.palette.PaletteItemDataObject");
            this.getExtensions().addMimeType("text/x-comp-palette+xml");
        }

        protected String defaultDisplayName() {
            return NbBundle.getBundle(PaletteItemDataObject.class).getString("PROP_PaletteItemLoader_Name");
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new PaletteItemDataObject(fileObject, (MultiFileLoader)this);
        }
    }
}

