/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette.api;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipItemNode;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipUtilities;
import org.netbeans.spi.palette.PaletteActions;
import org.openide.actions.NewAction;
import org.openide.actions.RenameAction;
import org.openide.loaders.DataFolder;
import org.openide.text.CloneableEditor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CodeClipPaletteActions
extends PaletteActions {
    private String paletteFolderName;
    private CloneableEditor cloneableEditor;

    public CodeClipPaletteActions(String string, CloneableEditor cloneableEditor) {
        this.paletteFolderName = string;
        this.cloneableEditor = cloneableEditor;
    }

    public Action[] getImportActions() {
        return new Action[0];
    }

    public Action[] getCustomCategoryActions(Lookup lookup) {
        return new Action[]{new CreateCodeClipAction(lookup)};
    }

    public Action[] getCustomItemActions(Lookup lookup) {
        return new Action[]{((RenameAction)SystemAction.get(RenameAction.class)).createContextAwareInstance(lookup), new EditCodeClipAction(lookup)};
    }

    public Action[] getCustomPaletteActions() {
        return new Action[]{SystemAction.get(NewAction.class)};
    }

    public Action getPreferredAction(Lookup lookup) {
        return new CodeClipPaletteInsertAction(lookup, this.cloneableEditor);
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = CodeClipPaletteActions.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private static class CodeClipPaletteInsertAction
    extends AbstractAction {
        Lookup item;
        CloneableEditor cloneableEditor;

        CodeClipPaletteInsertAction(Lookup lookup, CloneableEditor cloneableEditor) {
            this.item = lookup;
            this.cloneableEditor = cloneableEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CodeClipItemNode codeClipItemNode = (CodeClipItemNode)((Object)this.item.lookup(CodeClipItemNode.class));
            codeClipItemNode.drop(this.cloneableEditor.getEditorPane());
        }
    }

    private static class EditCodeClipAction
    extends AbstractAction {
        Lookup item;

        EditCodeClipAction(Lookup lookup) {
            super(NbBundle.getMessage(CodeClipPaletteActions.class, (String)"EDIT"));
            this.item = lookup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CodeClipItemNode codeClipItemNode = (CodeClipItemNode)((Object)this.item.lookup(CodeClipItemNode.class));
            codeClipItemNode.edit();
        }
    }

    private static class CreateCodeClipAction
    extends AbstractAction {
        Lookup category;

        CreateCodeClipAction(Lookup lookup) {
            super(NbBundle.getMessage(CodeClipPaletteActions.class, (String)"ADD"));
            this.category = lookup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataFolder dataFolder = (DataFolder)this.category.lookup(DataFolder.class);
            CodeClipUtilities.createCodeClip(dataFolder);
        }
    }
}

