/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.swing.Action;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringXMLConfigCompletionDoc
implements CompletionDocumentation {
    public static SpringXMLConfigCompletionDoc getAttribValueDoc(String string) {
        return new AttribValueDoc(string);
    }

    public static SpringXMLConfigCompletionDoc createJavaDoc(CompilationController compilationController, Element element) {
        return new JavaElementDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
    }

    public static SpringXMLConfigCompletionDoc createBeanRefDoc(String string, List<String> list, String string2, String string3, Action action) {
        return new BeanRefDoc(string, list, string2, string3, action);
    }

    public URL getURL() {
        return null;
    }

    public CompletionDocumentation resolveLink(String string) {
        return null;
    }

    public Action getGotoSourceAction() {
        return null;
    }

    private static class AttribValueDoc
    extends SpringXMLConfigCompletionDoc {
        private String text;

        public AttribValueDoc(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanRefDoc
    extends SpringXMLConfigCompletionDoc {
        private String beanId;
        private List<String> beanNames;
        private String beanClassName;
        private String beanLocFile;
        private Action goToBeanAction;
        private String displayText;

        public BeanRefDoc(String string, List<String> list, String string2, String string3, Action action) {
            this.beanId = string;
            this.beanNames = list;
            this.beanClassName = string2;
            this.beanLocFile = string3;
            this.goToBeanAction = action;
        }

        public String getText() {
            if (this.displayText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.beanLocFile != null) {
                    stringBuilder.append("<b>");
                    stringBuilder.append(new File(this.beanLocFile).getName());
                    stringBuilder.append("</b>");
                    stringBuilder.append("<br>");
                    stringBuilder.append("<br>");
                }
                String string = this.getBeanName();
                ArrayList<String> arrayList = new ArrayList<String>(this.beanNames);
                arrayList.remove(string);
                if (arrayList.size() > 0) {
                    stringBuilder.append(NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_BeanLabelWithAliases", (Object)string, (Object)StringUtils.join(arrayList, ", ")));
                } else {
                    stringBuilder.append(NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_BeanLabel", (Object)string));
                }
                if (this.beanClassName != null) {
                    stringBuilder.append("<pre>");
                    stringBuilder.append(this.beanClassName);
                    stringBuilder.append("</pre>");
                }
                this.displayText = stringBuilder.toString();
            }
            return this.displayText;
        }

        private String getBeanName() {
            if (this.beanId != null && this.beanId.trim().length() > 0) {
                return this.beanId;
            }
            for (String string : this.beanNames) {
                if (string == null || string.trim().length() <= 0) continue;
                return string;
            }
            return NbBundle.getMessage(SpringXMLConfigCompletionDoc.class, (String)"LBL_Unnamed");
        }

        @Override
        public Action getGotoSourceAction() {
            return this.goToBeanAction;
        }
    }

    private static class JavaElementDoc
    extends SpringXMLConfigCompletionDoc {
        private ElementJavadoc elementJavadoc;

        public JavaElementDoc(ElementJavadoc elementJavadoc) {
            this.elementJavadoc = elementJavadoc;
        }

        public JavaElementDoc resolveLink(String string) {
            ElementJavadoc elementJavadoc = this.elementJavadoc.resolveLink(string);
            return elementJavadoc != null ? new JavaElementDoc(elementJavadoc) : null;
        }

        public URL getURL() {
            return this.elementJavadoc.getURL();
        }

        public String getText() {
            return this.elementJavadoc.getText();
        }

        public Action getGotoSourceAction() {
            return this.elementJavadoc.getGotoSourceAction();
        }
    }
}

