/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.PropertyType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringRefactorings {
    private static final Logger LOGGER = Logger.getLogger(SpringRefactorings.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static RenamedProperty getRenamedProperty(final TreePathHandle treePathHandle, JavaSource javaSource, final String string) throws IOException {
        final RenamedProperty[] renamedPropertyArray = new RenamedProperty[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.METHOD) {
                    return;
                }
                PropertyType propertyType = null;
                ExecutableElement executableElement = (ExecutableElement)element;
                if (JavaUtils.isGetter(executableElement)) {
                    propertyType = PropertyType.READ_ONLY;
                } else if (JavaUtils.isSetter(executableElement)) {
                    propertyType = PropertyType.WRITE_ONLY;
                } else {
                    return;
                }
                Collection<ElementHandle<ExecutableElement>> collection = JavaUtils.getOverridenMethodsAsHandles(executableElement, (CompilationInfo)compilationController);
                collection = new ArrayList<ElementHandle<ExecutableElement>>(collection);
                collection.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)executableElement));
                String string2 = JavaUtils.getPropertyName(element.getSimpleName().toString());
                element = element.getEnclosingElement();
                renamedPropertyArray[0] = new RenamedProperty(collection, string2, JavaUtils.getPropertyName(string), propertyType);
            }
        }, true);
        return renamedPropertyArray[0];
    }

    public static RenamedClassName getRenamedClassName(final TreePathHandle treePathHandle, JavaSource javaSource, final String string) throws IOException {
        final RenamedClassName[] renamedClassNameArray = new RenamedClassName[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                String string5 = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
                String string2 = element.getSimpleName().toString();
                String string3 = null;
                if ((element = element.getEnclosingElement()).getKind() == ElementKind.CLASS) {
                    string3 = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)) + '$' + string;
                } else if (element.getKind() == ElementKind.PACKAGE) {
                    String string4 = ((PackageElement)element).getQualifiedName().toString();
                    string3 = SpringRefactorings.createQualifiedName(string4, string);
                } else {
                    LOGGER.log(Level.WARNING, "Enclosing element of {0} was neither class nor package", treePathHandle);
                }
                renamedClassNameArray[0] = new RenamedClassName(string2, string5, string3);
            }
        }, true);
        return renamedClassNameArray[0];
    }

    public static List<String> getTopLevelClassNames(FileObject fileObject) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> arrayList = new ArrayList<String>(1);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (TypeElement typeElement : compilationController.getTopLevelElements()) {
                    arrayList.add(ElementUtilities.getBinaryName((TypeElement)typeElement));
                }
            }
        }, true);
        return arrayList;
    }

    public static String getPackageName(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    public static String getRenamedPackageName(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string2 = classPath.getResourceName(fileObject2, '.', false);
        if (string2 == null) {
            return null;
        }
        if (string2.length() > 0) {
            return string2 + '.' + string;
        }
        return string;
    }

    public static String getPackageName(URL uRL) {
        String string;
        File file = null;
        try {
            string = URLDecoder.decode(uRL.getPath(), "UTF-8");
            file = FileUtil.normalizeFile((File)new File(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
        }
        string = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(string)) {
                    return SpringRefactorings.getPackageName(fileObject);
                }
                String string2 = SpringRefactorings.getPackageName(fileObject);
                return string2 + ("".equals(string2) ? "" : ".") + string;
            }
            if (!"".equals(string)) {
                string = "." + string;
            }
            try {
                string = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1), "UTF-8") + string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
            }
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for URL " + uRL);
    }

    public static String getSimpleElementName(String string) {
        int n;
        while (true) {
            if (string.length() == 0) {
                return string;
            }
            n = string.lastIndexOf(46);
            if (n == -1) {
                return string;
            }
            if (n != string.length() - 1) break;
            string = string.substring(0, n);
        }
        return string.substring(n + 1);
    }

    public static String createQualifiedName(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        return string + '.' + string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RenamedProperty {
        private final String oldName;
        private final String newName;
        private final PropertyType type;
        private final Collection<ElementHandle<ExecutableElement>> methodHandles;

        public RenamedProperty(Collection<ElementHandle<ExecutableElement>> collection, String string, String string2, PropertyType propertyType) {
            this.methodHandles = collection;
            this.oldName = string;
            this.newName = string2;
            this.type = propertyType;
        }

        public String getNewName() {
            return this.newName;
        }

        public String getOldName() {
            return this.oldName;
        }

        public PropertyType getType() {
            return this.type;
        }

        public Collection<ElementHandle<ExecutableElement>> getMethodHandles() {
            return this.methodHandles;
        }
    }

    public static final class RenamedClassName {
        private final String oldSimpleName;
        private final String oldBinaryName;
        private final String newBinaryName;

        public RenamedClassName(String string, String string2, String string3) {
            this.oldSimpleName = string;
            this.oldBinaryName = string2;
            this.newBinaryName = string3;
        }

        public String getOldSimpleName() {
            return this.oldSimpleName;
        }

        public String getOldBinaryName() {
            return this.oldBinaryName;
        }

        public String getNewBinaryName() {
            return this.newBinaryName;
        }
    }
}

