/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ui.customizer.ConfigFilesUIs;
import org.netbeans.modules.spring.beans.ui.customizer.SelectConfigFilesPanel;
import org.netbeans.modules.spring.util.ConfigFiles;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private final Project project;
    private final List<File> files;
    private final List<ConfigFileGroup> groups;
    private final File basedir;
    private final ConfigFilesUIs.FileDisplayName fileDisplayName;
    private ConfigFileGroup currentGroup;
    private int currentGroupIndex;
    private List<File> detectedFiles;
    private JButton addFileButton;
    private JButton addGroupButton;
    private JButton addGroupFilesButton;
    private JPanel configFileGroupsPanel;
    private JPanel configFilesPanel;
    private JButton detectFilesButton;
    private JButton editGroupButton;
    private JLabel filesLabel;
    private JList filesList;
    private JScrollPane filesScrollPane;
    private JLabel groupFilesLabel;
    private JList groupFilesList;
    private JScrollPane groupFilesScrollPane;
    private JLabel groupsLabel;
    private JList groupsList;
    private JScrollPane groupsScrollPane;
    private JButton removeFileButton;
    private JButton removeGroupButton;
    private JButton removeGroupFileButton;
    private JTabbedPane springConfigPane;

    public SpringCustomizerPanel(Project project, List<File> list, List<ConfigFileGroup> list2) {
        this.project = project;
        this.files = list;
        this.groups = list2;
        this.basedir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        if (this.basedir == null) {
            throw new IllegalStateException("The directory of project " + project + " is null");
        }
        this.fileDisplayName = new RelativeDisplayName();
        this.initComponents();
        ConfigFilesUIs.setupFilesList(this.filesList, this.fileDisplayName);
        ConfigFilesUIs.setupGroupsList(this.groupsList);
        ConfigFilesUIs.setupFilesList(this.groupFilesList, this.fileDisplayName);
        ConfigFilesUIs.connectFilesList(list, this.filesList);
        ConfigFilesUIs.connectGroupsList(list2, this.groupsList);
        this.filesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpringCustomizerPanel.this.filesListSelectionChanged();
            }
        });
        this.groupsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpringCustomizerPanel.this.groupsListSelectionChanged();
            }
        });
        this.groupFilesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpringCustomizerPanel.this.groupFilesListSelectionChanged();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SpringCustomizerPanel.class);
    }

    public List<File> getConfigFiles() {
        return this.files;
    }

    public List<ConfigFileGroup> getConfigFileGroups() {
        return this.groups;
    }

    private void filesListSelectionChanged() {
        boolean bl = this.filesList.getSelectedIndex() != -1;
        this.removeFileButton.setEnabled(bl);
    }

    private void groupsListSelectionChanged() {
        this.currentGroupIndex = this.groupsList.getSelectedIndex();
        if (this.currentGroupIndex != -1) {
            this.currentGroup = (ConfigFileGroup)this.groupsList.getModel().getElementAt(this.currentGroupIndex);
            ConfigFilesUIs.connectFilesList(this.currentGroup.getFiles(), this.groupFilesList);
            this.editGroupButton.setEnabled(true);
            this.removeGroupButton.setEnabled(true);
            this.addGroupFilesButton.setEnabled(true);
            this.detectFilesButton.setEnabled(true);
            String string = ConfigFilesUIs.getGroupName(this.currentGroup);
            this.groupFilesLabel.setText(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFilesInGroup", (Object)string));
            this.groupFilesList.setSelectedIndices(new int[0]);
        } else {
            this.currentGroup = null;
            ConfigFilesUIs.disconnect(this.groupFilesList);
            this.editGroupButton.setEnabled(true);
            this.removeGroupButton.setEnabled(false);
            this.addGroupFilesButton.setEnabled(false);
            this.detectFilesButton.setEnabled(false);
            this.groupFilesLabel.setText(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        }
    }

    private void groupFilesListSelectionChanged() {
        boolean bl = this.groupFilesList.getSelectedIndex() != -1;
        this.removeGroupFileButton.setEnabled(bl);
    }

    private void replaceCurrentGroup(ConfigFileGroup configFileGroup) {
        this.groups.set(this.currentGroupIndex, configFileGroup);
        int n = this.currentGroupIndex;
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        this.groupsList.setSelectedIndex(n);
    }

    private void addFiles(List<File> list) {
        this.files.addAll(list);
        ConfigFilesUIs.connectFilesList(this.files, this.filesList);
        this.filesList.setSelectedIndex(this.filesList.getModel().getSize() - 1);
    }

    private void removeFiles() {
        int n;
        ArrayList<File> arrayList = new ArrayList<File>();
        int[] nArray = this.filesList.getSelectedIndices();
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(this.files.remove(nArray[n] - n));
        }
        for (n = 0; n < this.groups.size(); ++n) {
            ConfigFileGroup configFileGroup = this.groups.get(n);
            List<File> list = configFileGroup.getFiles();
            if (!list.removeAll(arrayList)) continue;
            ConfigFileGroup configFileGroup2 = ConfigFileGroup.create(configFileGroup.getName(), list);
            if (this.currentGroup == configFileGroup) {
                this.replaceCurrentGroup(configFileGroup2);
                continue;
            }
            this.groups.set(n, configFileGroup2);
        }
        ConfigFilesUIs.connectFilesList(this.files, this.filesList);
        n = Math.min(nArray[0], this.filesList.getModel().getSize() - 1);
        this.filesList.setSelectedIndex(n);
    }

    private void addGroup(ConfigFileGroup configFileGroup) {
        this.groups.add(configFileGroup);
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        this.groupsList.setSelectedIndex(this.groupsList.getModel().getSize() - 1);
    }

    private void removeGroups() {
        int n;
        int[] nArray = this.groupsList.getSelectedIndices();
        for (n = 0; n < nArray.length; ++n) {
            this.groups.remove(nArray[n] - n);
        }
        ConfigFilesUIs.connectGroupsList(this.groups, this.groupsList);
        n = Math.min(nArray[0], this.groupsList.getModel().getSize() - 1);
        this.groupsList.setSelectedIndex(n);
    }

    private void addFilesToCurrentGroup(List<File> list) {
        List<File> list2 = this.currentGroup.getFiles();
        list2.addAll(list);
        ConfigFileGroup configFileGroup = ConfigFileGroup.create(this.currentGroup.getName(), list2);
        this.replaceCurrentGroup(configFileGroup);
        this.groupFilesList.setSelectedIndex(this.groupFilesList.getModel().getSize() - 1);
    }

    private void removeFilesFromCurrentGroup() {
        int n;
        List<File> list = this.currentGroup.getFiles();
        int[] nArray = this.groupFilesList.getSelectedIndices();
        for (n = 0; n < nArray.length; ++n) {
            list.remove(nArray[n] - n);
        }
        this.replaceCurrentGroup(ConfigFileGroup.create(this.currentGroup.getName(), list));
        n = Math.min(nArray[0], this.groupFilesList.getModel().getSize() - 1);
        this.groupFilesList.setSelectedIndex(n);
    }

    private void initComponents() {
        this.springConfigPane = new JTabbedPane();
        this.configFilesPanel = new JPanel();
        this.filesLabel = new JLabel();
        this.filesScrollPane = new JScrollPane();
        this.filesList = new JList();
        this.addFileButton = new JButton();
        this.removeFileButton = new JButton();
        this.detectFilesButton = new JButton();
        this.configFileGroupsPanel = new JPanel();
        this.groupsLabel = new JLabel();
        this.groupsScrollPane = new JScrollPane();
        this.groupsList = new JList();
        this.addGroupButton = new JButton();
        this.editGroupButton = new JButton();
        this.removeGroupButton = new JButton();
        this.groupFilesLabel = new JLabel();
        this.groupFilesScrollPane = new JScrollPane();
        this.groupFilesList = new JList();
        this.addGroupFilesButton = new JButton();
        this.removeGroupFileButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        this.filesScrollPane.setViewportView(this.filesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddFile"));
        this.addFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.addFileButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveFile"));
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.removeFileButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.detectFilesButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_DetectFiles"));
        this.detectFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.detectFilesButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.configFilesPanel);
        this.configFilesPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.filesLabel).add((Component)this.filesScrollPane, -1, 273, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.removeFileButton, -1, 128, Short.MAX_VALUE).add((Component)this.detectFilesButton, -1, 128, Short.MAX_VALUE).add((Component)this.addFileButton, -1, 128, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addFileButton, this.detectFilesButton, this.removeFileButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.filesLabel).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addFileButton).addPreferredGap(0).add((Component)this.detectFilesButton).addPreferredGap(0).add((Component)this.removeFileButton)).add((Component)this.filesScrollPane, -1, 334, Short.MAX_VALUE)).addContainerGap()));
        this.springConfigPane.addTab(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFilesTitle"), this.configFilesPanel);
        Mnemonics.setLocalizedText((JLabel)this.groupsLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFileGroups"));
        this.groupsLabel.setFocusable(false);
        this.groupsScrollPane.setViewportView(this.groupsList);
        Mnemonics.setLocalizedText((AbstractButton)this.addGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddGroup"));
        this.addGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.addGroupButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_EditGroup"));
        this.editGroupButton.setEnabled(false);
        this.editGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.editGroupButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGroupButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveGroup"));
        this.removeGroupButton.setEnabled(false);
        this.removeGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.removeGroupButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.groupFilesLabel, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFiles"));
        this.groupFilesLabel.setFocusable(false);
        this.groupFilesScrollPane.setViewportView(this.groupFilesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addGroupFilesButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_AddFiles"));
        this.addGroupFilesButton.setEnabled(false);
        this.addGroupFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.addGroupFilesButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGroupFileButton, (String)NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_RemoveFile"));
        this.removeGroupFileButton.setEnabled(false);
        this.removeGroupFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpringCustomizerPanel.this.removeGroupFileButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.configFileGroupsPanel);
        this.configFileGroupsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.groupFilesLabel).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.groupFilesScrollPane, -1, 267, Short.MAX_VALUE).add(1, (Component)this.groupsLabel).add(1, (Component)this.groupsScrollPane, -1, 267, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.removeGroupButton, 0, -1, Short.MAX_VALUE).add((Component)this.editGroupButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.addGroupButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.addGroupFilesButton, -1, 134, Short.MAX_VALUE).add((Component)this.removeGroupFileButton, -2, 134, -2)))).addContainerGap()));
        groupLayout2.linkSize(new Component[]{this.addGroupButton, this.addGroupFilesButton, this.editGroupButton, this.removeGroupButton, this.removeGroupFileButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.groupsLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addGroupButton).addPreferredGap(0).add((Component)this.editGroupButton).addPreferredGap(0).add((Component)this.removeGroupButton)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.groupsScrollPane, -2, -1, -2).addPreferredGap(0).add((Component)this.groupFilesLabel))).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.groupFilesScrollPane, -1, 176, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addGroupFilesButton).addPreferredGap(0).add((Component)this.removeGroupFileButton))).addContainerGap()));
        this.springConfigPane.addTab(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ConfigFileGroupsTitle"), this.configFileGroupsPanel);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.springConfigPane, -1, 436, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.springConfigPane, -1, 406, Short.MAX_VALUE));
    }

    private void addFileButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_ChooseFile"));
        jFileChooser.setCurrentDirectory(this.basedir);
        int n = jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.groupFilesList));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (this.files.contains(file)) {
                String string = NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_FileAlreadyAdded");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            } else {
                this.addFiles(Collections.singletonList(file));
            }
        }
    }

    private void removeFileButtonActionPerformed(ActionEvent actionEvent) {
        this.removeFiles();
    }

    private void detectFilesButtonActionPerformed(ActionEvent actionEvent) {
        HashSet<File> hashSet = new HashSet<File>(this.files);
        SelectConfigFilesPanel selectConfigFilesPanel = this.detectedFiles != null ? SelectConfigFilesPanel.create(this.detectedFiles, hashSet, this.fileDisplayName) : SelectConfigFilesPanel.create(this.project, hashSet, this.fileDisplayName);
        if (selectConfigFilesPanel.open()) {
            List<File> list = selectConfigFilesPanel.getAvailableFiles();
            if (list != null) {
                this.detectedFiles = list;
            }
            this.addFiles(selectConfigFilesPanel.getSelectedFiles());
        }
    }

    private void addGroupButtonActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_GroupName"), NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_NewConfigFileGroup"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
            this.addGroup(ConfigFileGroup.create(inputLine.getInputText(), Collections.<File>emptyList()));
        }
    }

    private void editGroupButtonActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_GroupName"), NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_EditConfigFileGroup"));
        String string = this.currentGroup.getName();
        if (string != null) {
            inputLine.setInputText(string);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
            this.replaceCurrentGroup(ConfigFileGroup.create(inputLine.getInputText(), this.currentGroup.getFiles()));
        }
    }

    private void removeGroupButtonActionPerformed(ActionEvent actionEvent) {
        this.removeGroups();
    }

    private void addGroupFilesButtonActionPerformed(ActionEvent actionEvent) {
        if (this.files.size() == 0) {
            String string = NbBundle.getMessage(SpringCustomizerPanel.class, (String)"LBL_NoFilesAdded");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            return;
        }
        HashSet<File> hashSet = new HashSet<File>(this.groups.get(this.currentGroupIndex).getFiles());
        SelectConfigFilesPanel selectConfigFilesPanel = SelectConfigFilesPanel.create(this.files, hashSet, this.fileDisplayName);
        if (selectConfigFilesPanel.open()) {
            this.addFilesToCurrentGroup(selectConfigFilesPanel.getSelectedFiles());
        }
    }

    private void removeGroupFileButtonActionPerformed(ActionEvent actionEvent) {
        this.removeFilesFromCurrentGroup();
    }

    private final class RelativeDisplayName
    implements ConfigFilesUIs.FileDisplayName {
        private Map<File, String> abs2Rel = new HashMap<File, String>();

        private RelativeDisplayName() {
        }

        public String getDisplayName(File file) {
            String string = this.abs2Rel.get(file);
            if (string == null) {
                string = ConfigFiles.getRelativePath(SpringCustomizerPanel.this.basedir, file);
                this.abs2Rel.put(file, string);
            }
            return string;
        }
    }
}

