/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProvider;
import org.netbeans.modules.cnd.remote.support.RemoteScriptSupport;
import org.netbeans.modules.cnd.remote.support.SystemIncludesUtils;
import org.netbeans.modules.cnd.remote.support.managers.CompilerSetScriptManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCompilerSetProvider
implements CompilerSetProvider {
    private CompilerSetScriptManager manager;
    private Logger log = Logger.getLogger("cnd.remote.logger");
    private String hkey;

    public void init(String string) {
        this.hkey = string;
        this.manager = new CompilerSetScriptManager();
        new RemoteScriptSupport(string, this.manager);
    }

    public int getPlatform() {
        String string = this.manager.getPlatform();
        if (string == null || string.length() == 0) {
            this.log.warning("RCSP.getPlatform: Got null response on platform");
            string = "";
        }
        if (string.startsWith("Windows")) {
            return 3;
        }
        if (string.startsWith("Linux")) {
            return 2;
        }
        if (string.startsWith("SunOS")) {
            return string.contains("86") ? 1 : 0;
        }
        if (string.toLowerCase().startsWith("mac")) {
            return 4;
        }
        return 5;
    }

    public boolean hasMoreCompilerSets() {
        return this.manager.hasMoreCompilerSets();
    }

    public String getNextCompilerSetData() {
        return this.manager.getNextCompilerSetData();
    }

    public void loadCompilerSetData(List<CompilerSet> list) {
        SystemIncludesUtils.load(this.hkey, list);
    }
}

