/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.SimpleConfigParser;
import org.netbeans.modules.cnd.remote.support.RunFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostMappingProviderSamba
implements HostMappingProvider {
    private static final String GLOBAL = "global";
    private static final String PATH = "path";

    @Override
    public Map<String, String> findMappings(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RunFacade runFacade = RunFacade.getInstance(string);
        if (runFacade.run("cat /etc/sfw/smb.conf")) {
            hashMap.putAll(HostMappingProviderSamba.parseOutput(new StringReader(runFacade.getOutput())));
        }
        return hashMap;
    }

    @Override
    public boolean isApplicable(PlatformInfo platformInfo, PlatformInfo platformInfo2) {
        return platformInfo2.isWindows() && platformInfo.isUnix();
    }

    static Map<String, String> parseOutput(Reader reader) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SimpleConfigParser simpleConfigParser = new SimpleConfigParser();
        simpleConfigParser.parse(reader);
        for (String string : simpleConfigParser.getSections()) {
            String string2;
            if (GLOBAL.equals(string) || (string2 = simpleConfigParser.getAttributes(string).get(PATH)) == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

