/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePathMap
extends HashMap<String, String>
implements PathMap {
    private static Map<String, RemotePathMap> pmtable = new HashMap<String, RemotePathMap>();
    private String hkey;
    private static final String REMOTE_PATH_MAP = "remote-path-map";
    private static final String DELIMITER = "\n";

    public static RemotePathMap getMapper(String string) {
        RemotePathMap remotePathMap = pmtable.get(string);
        if (remotePathMap == null) {
            remotePathMap = new RemotePathMap(string);
            pmtable.put(string, remotePathMap);
        }
        return remotePathMap;
    }

    private RemotePathMap(String string) {
        this.hkey = string;
        this.init();
    }

    private void init() {
        String string = RemotePathMap.getPreferences(this.hkey);
        if (string == null) {
            String string2 = System.getProperty("cnd.remote.pmap");
            if (string2 != null) {
                File file = new File(string2);
                if (file.exists() && file.canRead()) {
                    try {
                        String string3;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        while ((string3 = bufferedReader.readLine()) != null) {
                            int n = string3.indexOf(32);
                            if (n <= 0) continue;
                            this.put(string3.substring(0, n), string3.substring(n + 1).trim());
                        }
                    }
                    catch (IOException iOException) {}
                }
            } else {
                HostMappingsAnalyzer hostMappingsAnalyzer = new HostMappingsAnalyzer(this.hkey);
                this.putAll(hostMappingsAnalyzer.getMappings());
            }
        } else {
            String[] stringArray = string.split(DELIMITER);
            for (int i = 0; i < stringArray.length; i += 2) {
                if (i + 1 < stringArray.length) {
                    this.put(stringArray[i], stringArray[i + 1]);
                    continue;
                }
                System.err.println("mapping serialization flaw. Was found: " + string);
            }
        }
    }

    public String getRemotePath(String string) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry entry : this.entrySet()) {
            String string3 = RemotePathMap.unifySeparators((String)entry.getKey());
            if (!string2.startsWith(string3)) continue;
            String string4 = (String)entry.getValue();
            return string4 + string.substring(string3.length()).replace('\\', '/');
        }
        return string;
    }

    public String getLocalPath(String string) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry entry : this.entrySet()) {
            String string3 = RemotePathMap.unifySeparators((String)entry.getValue());
            if (!string2.startsWith(string3)) continue;
            String string4 = (String)entry.getKey();
            return string4 + string.substring(string3.length());
        }
        return string;
    }

    public boolean isRemote(String string, boolean bl) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry object : this.entrySet()) {
            String string3 = RemotePathMap.unifySeparators((String)object.getValue());
            if (!string2.startsWith(string3)) continue;
            return true;
        }
        for (String string4 : this.keySet()) {
            if (!string2.startsWith(RemotePathMap.unifySeparators(string4))) continue;
            return true;
        }
        if (bl) {
            return EditPathMapDialog.showMe(this.hkey, string) && this.isRemote(string, false);
        }
        return false;
    }

    public void updatePathMap(Map<String, String> map) {
        this.clear();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            String string2 = RemotePathMap.fixEnding(map.get(string));
            string = RemotePathMap.fixEnding(string);
            this.put(string, string2);
            stringBuilder.append(RemotePathMap.fixEnding(string));
            stringBuilder.append(DELIMITER);
            stringBuilder.append(string2);
            stringBuilder.append(DELIMITER);
        }
        RemotePathMap.setPreferences(this.hkey, stringBuilder.toString());
    }

    private static String fixEnding(String string) {
        if (string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            return string + "/";
        }
        return string;
    }

    private static String unifySeparators(String string) {
        return string.replace('\\', '/').toLowerCase();
    }

    public static boolean isSubPath(String string, String string2) {
        return RemotePathMap.unifySeparators(string2).startsWith(RemotePathMap.unifySeparators(string));
    }

    private static String getPreferences(String string) {
        return NbPreferences.forModule(RemotePathMap.class).get(REMOTE_PATH_MAP + string, null);
    }

    private static void setPreferences(String string, String string2) {
        NbPreferences.forModule(RemotePathMap.class).put(REMOTE_PATH_MAP + string, string2);
    }
}

