/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerList
extends ArrayList<RemoteServerRecord>
implements ServerList {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private static RemoteServerList instance = null;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;

    public static synchronized RemoteServerList getInstance() {
        if (instance == null) {
            instance = new RemoteServerList();
        }
        return instance;
    }

    private RemoteServerList() {
        String string = this.getPreferences().get(REMOTE_SERVERS, null);
        this.defaultIndex = this.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        this.addServer("localhost", false);
        if (string != null) {
            for (String string2 : string.split(",")) {
                this.addServer(string2, false);
            }
        }
        this.refresh();
    }

    public ServerRecord get(String string) {
        for (RemoteServerRecord remoteServerRecord : this) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return remoteServerRecord;
        }
        for (RemoteServerRecord remoteServerRecord : this.unlisted) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return remoteServerRecord;
        }
        RemoteServerRecord remoteServerRecord = new RemoteServerRecord(string);
        this.unlisted.add(remoteServerRecord);
        return remoteServerRecord;
    }

    public ServerRecord getDefaultRecord() {
        return (ServerRecord)this.get(this.defaultIndex);
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(int n) {
        this.defaultIndex = n;
        this.getPreferences().putInt(DEFAULT_INDEX, n);
    }

    public String[] getServerNames() {
        String[] stringArray;
        try {
            Object[] objectArray = this.toArray();
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof RemoteServerRecord)) continue;
                stringArray[i] = ((RemoteServerRecord)objectArray[i]).getName();
            }
        }
        catch (Exception exception) {
            return new String[]{"localhost"};
        }
        return stringArray;
    }

    public void addServer(String string, boolean bl) {
        RemoteServerRecord remoteServerRecord = null;
        for (RemoteServerRecord remoteServerRecord2 : this) {
            if (!remoteServerRecord2.getName().equals(string)) continue;
            return;
        }
        for (RemoteServerRecord remoteServerRecord2 : this.unlisted) {
            if (!remoteServerRecord2.getName().equals(string)) continue;
            remoteServerRecord = remoteServerRecord2;
            break;
        }
        if (remoteServerRecord == null) {
            remoteServerRecord = new RemoteServerRecord(string);
        } else {
            this.unlisted.remove(remoteServerRecord);
        }
        this.add(remoteServerRecord);
        if (bl) {
            this.defaultIndex = this.size() - 1;
        }
        this.refresh();
        String string2 = this.getPreferences().get(REMOTE_SERVERS, null);
        if (string2 == null) {
            this.getPreferences().put(REMOTE_SERVERS, string);
        } else {
            boolean bl2 = true;
            for (String string3 : string2.split(",")) {
                if (!string3.equals(string)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.getPreferences().put(REMOTE_SERVERS, (String)string2 + ',' + string);
            }
        }
        this.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
    }

    public void removeServer(int n) {
        if (n >= 0 && n < this.size()) {
            RemoteServerRecord remoteServerRecord = (RemoteServerRecord)this.remove(n);
            this.removeFromPreferences(remoteServerRecord.getName());
            this.refresh();
        }
    }

    public void removeServer(RemoteServerRecord remoteServerRecord) {
        if (super.remove(remoteServerRecord)) {
            this.removeFromPreferences(remoteServerRecord.getName());
            this.refresh();
        }
    }

    @Override
    public void clear() {
        this.getPreferences().remove(REMOTE_SERVERS);
        super.clear();
    }

    private void removeFromPreferences(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RemoteServerRecord remoteServerRecord : this) {
            stringBuilder.append(remoteServerRecord.getName());
            stringBuilder.append(',');
        }
        this.getPreferences().put(REMOTE_SERVERS, stringBuilder.substring(0, stringBuilder.length() - 1));
    }

    public ServerUpdateCache show(ServerUpdateCache serverUpdateCache) {
        EditServerListDialog editServerListDialog = new EditServerListDialog(serverUpdateCache);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editServerListDialog, NbBundle.getMessage(RemoteServerList.class, (String)"TITLE_EditServerList"), true, 2, DialogDescriptor.OK_OPTION, null);
        editServerListDialog.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.addPropertyChangeListener((PropertyChangeListener)editServerListDialog);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (serverUpdateCache == null) {
                serverUpdateCache = new ServerUpdateCache();
            }
            serverUpdateCache.setDefaultIndex(editServerListDialog.getDefaultIndex());
            serverUpdateCache.setHostKeyList(editServerListDialog.getHostKeyList());
            return serverUpdateCache;
        }
        return null;
    }

    protected void refresh() {
        this.cs.fireChange();
    }

    public boolean contains(String string) {
        for (RemoteServerRecord remoteServerRecord : this) {
            if (!string.equals(remoteServerRecord.getName())) continue;
            return true;
        }
        return false;
    }

    public RemoteServerRecord getLocalhostRecord() {
        return (RemoteServerRecord)this.get(0);
    }

    public boolean isValidExecutable(String string, String string2) {
        String string3;
        int n;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            log.warning("RemoteServerList.isValidExecutable from EDT");
        }
        return (n = RemoteCommandSupport.run(string, string3 = "PATH=/bin:/usr/bin:$PATH test -x " + string2)) == 0;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object) {
        this.pcs.firePropertyChange(string, null, object);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }
}

