/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteCopySupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerSetup {
    private static Logger log = Logger.getLogger("cnd.remote.logger");
    private static final String REMOTE_SCRIPT_DIR = ".netbeans/6.5/cnd2/scripts/";
    private static final String LOCAL_SCRIPT_DIR = "src/scripts/";
    private static final String GET_SCRIPT_INFO = "PATH=/bin:/usr/bin:$PATH  grep VERSION= .netbeans/6.5/cnd2/scripts/* /dev/null 2> /dev/null";
    private static final String DOS2UNIX_CMD = "PATH=/bin:/usr/bin:$PATH  dos2unix .netbeans/6.5/cnd2/scripts/";
    private static final String GET_LIB_INFO = "PATH=/bin:/usr/bin:$PATH  ls -1 2>&1 ";
    private static final String REMOTE_LIB_DIR = ".netbeans/6.5/cnd2/lib/";
    private final Map<String, Double> scriptSetupMap;
    private final Map<String, String> binarySetupMap;
    private final Map<String, List<String>> updateMap;
    private final String hkey;
    private boolean cancelled;
    private boolean failed;
    private String reason;

    protected RemoteServerSetup(String string) {
        this.hkey = string;
        this.scriptSetupMap = new HashMap<String, Double>();
        this.scriptSetupMap.put("getCompilerSets.bash", 0.5);
        this.binarySetupMap = new HashMap<String, String>();
        this.binarySetupMap.put(".netbeans/6.5/cnd2/lib/GdbHelper-Linux-x86.so", "bin/GdbHelper-Linux-x86.so");
        this.binarySetupMap.put(".netbeans/6.5/cnd2/lib/GdbHelper-SunOS-x86.so", "bin/GdbHelper-SunOS-x86.so");
        this.binarySetupMap.put(".netbeans/6.5/cnd2/lib/GdbHelper-SunOS-sparc.so", "bin/GdbHelper-SunOS-sparc.so");
        this.updateMap = new HashMap<String, List<String>>();
    }

    protected boolean needsSetupOrUpdate() {
        List<String> list = new ArrayList<String>();
        this.updateMap.clear();
        list = this.getScriptUpdates(list);
        if (!this.isFailedOrCanceled()) {
            list = this.getBinaryUpdates(list);
        }
        if (!list.isEmpty()) {
            this.updateMap.put(this.hkey, list);
            return true;
        }
        return false;
    }

    protected void setup() {
        List<String> list = this.updateMap.remove(this.hkey);
        boolean bl = false;
        for (String string : list) {
            int n;
            Object object;
            if (string.equals(REMOTE_SCRIPT_DIR)) {
                log.fine("RSS.setup: Creating ~/.netbeans/6.5/cnd2/scripts/");
                int n2 = RemoteCommandSupport.run(this.hkey, "PATH=/bin:/usr/bin:$PATH mkdir -p .netbeans/6.5/cnd2/scripts/");
                if (n2 == 0) {
                    for (String string2 : this.scriptSetupMap.keySet()) {
                        log.fine("RSS.setup: Copying" + string + " to " + this.hkey);
                        object = InstalledFileLocator.getDefault().locate(LOCAL_SCRIPT_DIR + string2, null, false);
                        RemoteCopySupport.copyTo(this.hkey, ((File)object).getAbsolutePath(), REMOTE_SCRIPT_DIR);
                        RemoteCommandSupport.run(this.hkey, DOS2UNIX_CMD + string2 + ' ' + REMOTE_SCRIPT_DIR + string2);
                    }
                    continue;
                }
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_DirectorySetupFailure", (Object)this.hkey, (Object)n2);
                continue;
            }
            if (string.equals(REMOTE_LIB_DIR)) {
                log.fine("RSS.setup: Creating ~/.netbeans/6.5/cnd2/lib/");
                int n3 = RemoteCommandSupport.run(this.hkey, "PATH=/bin:/usr/bin:$PATH mkdir -p .netbeans/6.5/cnd2/lib/");
                if (n3 == 0) {
                    bl = true;
                    for (String string3 : this.binarySetupMap.keySet()) {
                        object = this.binarySetupMap.get(string3);
                        log.fine("RSS.setup: Copying" + (String)object + " to " + this.hkey);
                        File file = InstalledFileLocator.getDefault().locate((String)object, null, false);
                        if (file != null && file.exists()) {
                            RemoteCopySupport.copyTo(this.hkey, file.getAbsolutePath(), REMOTE_LIB_DIR);
                            continue;
                        }
                        this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.hkey, (Object)string3);
                    }
                    continue;
                }
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_DirectorySetupFailure", (Object)this.hkey, (Object)n3);
                continue;
            }
            log.fine("RSS.setup: Updating \"" + string + "\" on " + this.hkey);
            if (this.binarySetupMap.containsKey(string)) {
                bl = true;
                String string4 = this.binarySetupMap.get(string);
                File file = InstalledFileLocator.getDefault().locate(string4, null, false);
                n = RemoteCopySupport.copyTo(this.hkey, file.getAbsolutePath(), REMOTE_LIB_DIR);
                if (n == 0) continue;
                this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.hkey, (Object)string);
                continue;
            }
            File file = InstalledFileLocator.getDefault().locate(LOCAL_SCRIPT_DIR + string, null, false);
            boolean bl2 = RemoteCopySupport.copyTo(this.hkey, file.getAbsolutePath(), REMOTE_SCRIPT_DIR);
            n = RemoteCommandSupport.run(this.hkey, DOS2UNIX_CMD + string + ' ' + REMOTE_SCRIPT_DIR + string);
            if (!bl2 && n == 0) continue;
            this.reason = NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.hkey, (Object)string);
        }
        if (bl) {
            RemoteCommandSupport.run(this.hkey, "PATH=/bin:/usr/bin:$PATH chmod 755 .netbeans/6.5/cnd2/lib//*.so");
        }
    }

    private List<String> getScriptUpdates(List<String> list) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, GET_SCRIPT_INFO);
        if (!remoteCommandSupport.isFailed()) {
            log.fine("RSS.needsSetupOrUpdate: GET_SCRIPT_INFO returned " + remoteCommandSupport.getExitStatus());
            if (remoteCommandSupport.getExitStatus() == 0) {
                String string = remoteCommandSupport.toString();
                for (String string2 : string.split("\n")) {
                    try {
                        int n = string2.indexOf(58);
                        if (n > 0 && string2.length() > 0) {
                            String string3 = string2.substring(REMOTE_SCRIPT_DIR.length(), n);
                            Double d = Double.valueOf(string2.substring(n + 9));
                            Double d2 = this.scriptSetupMap.get(string3);
                            if (d2 == null || !(d2 > d)) continue;
                            log.fine("RSS.getScriptUpdates: Need to update " + string3);
                            list.add(string3);
                            continue;
                        }
                        log.warning("RSS.getScriptUpdates: Grep returned [" + string2 + "]");
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warning("RSS.getScriptUpdates: Bad response from remote grep comand (NFE parsing version)");
                    }
                    catch (Exception exception) {
                        log.warning("RSS.getScriptUpdates: Bad response from remote grep comand: " + exception.getClass().getName());
                    }
                }
            } else if (!remoteCommandSupport.isCancelled()) {
                log.fine("RSS.getScriptUpdates: Need to create ~/.netbeans/6.5/cnd2/scripts/");
                list.add(REMOTE_SCRIPT_DIR);
            } else if (remoteCommandSupport.isCancelled()) {
                this.cancelled = true;
            } else {
                log.warning("RSS.getScriptUpdates: Unexpected  exit code [" + remoteCommandSupport.getExitStatus() + "]");
            }
        } else {
            this.failed = true;
            this.reason = remoteCommandSupport.getFailureReason();
        }
        return list;
    }

    private List<String> getBinaryUpdates(List<String> list) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.hkey, GET_LIB_INFO + this.getBinarySetupFiles());
        if (!remoteCommandSupport.isFailed()) {
            log.fine("RSS.getBinaryUpdates: GET_LIB_INFO returned " + remoteCommandSupport.getExitStatus());
            if (remoteCommandSupport.isCancelled()) {
                this.cancelled = true;
            } else {
                String string = remoteCommandSupport.toString();
                int n = 0;
                for (String string2 : string.split("\n")) {
                    int n2 = string2.indexOf(58);
                    if (n2 <= 0) continue;
                    if (n++ == 0) {
                        list.add(REMOTE_LIB_DIR);
                    }
                    list.add(string2.substring(0, n2));
                }
            }
        } else {
            this.failed = true;
            this.reason = remoteCommandSupport.getFailureReason();
        }
        return list;
    }

    public String getReason() {
        String string;
        if (this.reason.contains("UnknownHostException")) {
            int n = this.reason.lastIndexOf(32);
            String string2 = this.reason.substring(n + 1);
            string = NbBundle.getMessage(RemoteServerSetup.class, (String)"REASON_UnknownHost", (Object)string2);
        } else {
            string = this.reason.equals("Auth failed") ? NbBundle.getMessage(RemoteServerSetup.class, (String)"REASON_AuthFailed") : this.reason;
        }
        return string;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    private boolean isFailedOrCanceled() {
        return this.failed || this.cancelled;
    }

    private String getBinarySetupFiles() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.binarySetupMap.keySet()) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

