/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddServerDialog
extends JPanel
implements DocumentListener {
    public static final String PROP_VALID = "valid";
    private boolean valid;
    private final JButton btnOK;
    private JComboBox cbPasswordSource;
    private JCheckBox cbxSetAsDefault;
    private JLabel jLabel1;
    private JLabel lbLogin;
    private JLabel lbPasswordSource;
    private JLabel lbServer;
    private JTextField tfLogin;
    private JPasswordField tfPassword;
    private JTextField tfServer;

    public AddServerDialog() {
        this.initComponents();
        this.btnOK = new JButton(NbBundle.getMessage(AddServerDialog.class, (String)"BTN_OK"));
        this.btnOK.setEnabled(false);
        this.valid = false;
    }

    public boolean createNewRecord() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(EditServerListDialog.class, (String)"TITLE_AddNewServer"), true, new Object[]{this.btnOK, DialogDescriptor.CANCEL_OPTION}, (Object)this.btnOK, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == this.btnOK;
    }

    public String getServerName() {
        return this.tfServer.getText();
    }

    public String getLoginName() {
        return this.tfLogin.getText();
    }

    public String getPassword() {
        return String.valueOf(this.tfPassword.getPassword());
    }

    public boolean isDefault() {
        return this.cbxSetAsDefault.isSelected();
    }

    public boolean isOkValid() {
        return this.valid;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl = this.valid;
        boolean bl2 = this.valid = this.tfServer.getText().length() > 0 && this.tfLogin.getText().length() > 0;
        if (this.valid != bl) {
            this.firePropertyChange(PROP_VALID, bl, this.valid);
            if (this.btnOK != null) {
                this.btnOK.setEnabled(this.valid);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void initComponents() {
        this.lbServer = new JLabel();
        this.tfServer = new JTextField();
        this.tfServer.getDocument().addDocumentListener(this);
        this.lbLogin = new JLabel();
        this.tfLogin = new JTextField();
        this.tfLogin.getDocument().addDocumentListener(this);
        this.lbPasswordSource = new JLabel();
        this.cbPasswordSource = new JComboBox();
        this.cbxSetAsDefault = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.tfPassword = new JPasswordField();
        this.lbServer.setLabelFor(this.tfServer);
        Mnemonics.setLocalizedText((JLabel)this.lbServer, (String)NbBundle.getMessage(AddServerDialog.class, (String)"LBL_ServerTF"));
        this.lbServer.setToolTipText(NbBundle.getMessage(AddServerDialog.class, (String)"DESC_ServerTF"));
        this.lbLogin.setLabelFor(this.tfLogin);
        Mnemonics.setLocalizedText((JLabel)this.lbLogin, (String)NbBundle.getMessage(AddServerDialog.class, (String)"LBL_LoginTF"));
        this.lbLogin.setToolTipText(NbBundle.getMessage(AddServerDialog.class, (String)"DESC_LoginTF"));
        this.tfLogin.setText(System.getProperty("user.name"));
        this.tfLogin.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AddServerDialog.this.onLoginFocus(focusEvent);
            }
        });
        this.lbPasswordSource.setLabelFor(this.cbPasswordSource);
        Mnemonics.setLocalizedText((JLabel)this.lbPasswordSource, (String)NbBundle.getMessage(AddServerDialog.class, (String)"LBL_PasswordSource"));
        this.cbPasswordSource.setModel(new PasswordSourceModel());
        Mnemonics.setLocalizedText((AbstractButton)this.cbxSetAsDefault, (String)NbBundle.getMessage(AddServerDialog.class, (String)"LBL_SetAsDefault"));
        this.cbxSetAsDefault.setMargin(new Insets(2, 0, 2, 2));
        this.cbxSetAsDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerDialog.this.cbxSetAsDefaultActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setLabelFor(this.tfPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddServerDialog.class, (String)"AddServerDialog.jLabel1.text"));
        this.tfPassword.setText(NbBundle.getMessage(AddServerDialog.class, (String)"AddServerDialog.tfPassword.text"));
        this.tfPassword.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AddServerDialog.this.onPwdFocus(focusEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbxSetAsDefault).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lbServer).add((Component)this.lbPasswordSource).add((Component)this.jLabel1).add((Component)this.lbLogin)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(4, (Component)this.tfPassword, -1, 246, Short.MAX_VALUE).add(4, (Component)this.cbPasswordSource, 0, 246, Short.MAX_VALUE).add(4, (Component)this.tfServer, -1, 246, Short.MAX_VALUE).add((Component)this.tfLogin, -1, 246, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lbServer).add((Component)this.tfServer, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfLogin, -2, -1, -2).add((Component)this.lbLogin)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.tfPassword, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lbPasswordSource).add((Component)this.cbPasswordSource, -2, -1, -2)).addPreferredGap(1).add((Component)this.cbxSetAsDefault).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.cbPasswordSource, this.tfLogin, this.tfPassword, this.tfServer}, 2);
        this.lbPasswordSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerDialog.class, (String)"DESC_PasswordSource"));
    }

    private void cbxSetAsDefaultActionPerformed(ActionEvent actionEvent) {
    }

    private void onLoginFocus(FocusEvent focusEvent) {
        this.tfLogin.selectAll();
    }

    private void onPwdFocus(FocusEvent focusEvent) {
        this.tfPassword.selectAll();
    }

    public class PasswordSourceModel
    extends DefaultComboBoxModel {
        public PasswordSourceModel() {
            this.addElement(NbBundle.getMessage(AddServerDialog.class, (String)"LBL_PSM_TypeitOnce"));
            this.addElement(NbBundle.getMessage(AddServerDialog.class, (String)"LBL_PSM_TypeitAlways"));
            for (RemoteServerRecord remoteServerRecord : RemoteServerList.getInstance()) {
                String string = remoteServerRecord.getUserName();
                if (string == null) continue;
                this.addElement(NbBundle.getMessage(AddServerDialog.class, (String)"FMT_SharedPasswordSource", (Object)remoteServerRecord.getServerName(), (Object)string));
            }
        }
    }
}

