/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerUtil {
    protected static HashMap loggerUtils = new HashMap();
    protected Logger logger;

    public static LoggerUtil getLogger(String string) {
        LoggerUtil loggerUtil = (LoggerUtil)loggerUtils.get(string);
        if (loggerUtil == null) {
            loggerUtil = new LoggerUtil(Logger.getLogger(string));
            loggerUtils.put(string, loggerUtil);
        }
        return loggerUtil;
    }

    protected LoggerUtil(Logger logger) {
        this.logger = logger;
    }

    public boolean config(String string) {
        this.log(Level.CONFIG, string, null);
        return true;
    }

    public boolean config(String string, Throwable throwable) {
        this.log(Level.CONFIG, string, throwable);
        return true;
    }

    protected String[] inferCaller() {
        StackTraceElement stackTraceElement;
        String string;
        int n;
        String string2 = "com.sun.jsfcl.util.LoggerUtil";
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && !(string = (stackTraceElement = stackTraceElementArray[n]).getClassName()).equals(string2); ++n) {
        }
        while (n < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n];
            string = stackTraceElement.getClassName();
            if (!string.equals(string2)) {
                return new String[]{string, stackTraceElement.getMethodName()};
            }
            ++n;
        }
        return new String[2];
    }

    public boolean info(String string) {
        this.log(Level.INFO, string, null);
        return true;
    }

    public boolean info(String string, Throwable throwable) {
        this.log(Level.INFO, string, throwable);
        return true;
    }

    public boolean log(Level level, String string, Throwable throwable) {
        if (!this.logger.isLoggable(level)) {
            return true;
        }
        String[] stringArray = this.inferCaller();
        this.logger.logp(level, stringArray[0], stringArray[1], string, throwable);
        return true;
    }

    public boolean severe(String string) {
        this.log(Level.SEVERE, string, null);
        return true;
    }

    public boolean severe(String string, Throwable throwable) {
        this.log(Level.SEVERE, string, throwable);
        return true;
    }

    public boolean warning(String string) {
        this.log(Level.WARNING, string, null);
        return true;
    }

    public boolean warning(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
        return true;
    }

    static {
        InputStream inputStream = LoggerUtil.class.getResourceAsStream("/local-logging.properties");
        if (inputStream == null) {
            inputStream = LoggerUtil.class.getResourceAsStream("/logging.properties");
        }
        if (inputStream != null) {
            // empty if block
        }
    }
}

