/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.netbeans.modules.visualweb.propertyeditors.PropertyPanelBase;
import org.netbeans.modules.visualweb.propertyeditors.TabularPropertyModel;
import org.openide.util.NbBundle;

public class TabularPropertyPanel
extends PropertyPanelBase
implements TableModelListener {
    static ResourceBundle bundle = ResourceBundle.getBundle(TabularPropertyPanel.class.getPackage().getName() + ".Bundle");
    private TableModelSupport tableModelSupport;
    private JPanel buttonsPanel;
    private JScrollPane dataPane;
    private JTable dataTable;
    private JButton deleteButton;
    private JButton downButton;
    private JLabel helpLabel;
    private JButton newButton;
    private JButton upButton;

    public TabularPropertyPanel(TabularPropertyModel tabularPropertyModel, PropertyEditorBase propertyEditorBase) {
        super(propertyEditorBase);
        tabularPropertyModel.addTableModelListener(this);
        this.tableModelSupport = new TableModelSupport(tabularPropertyModel);
        this.initComponents();
        if (tabularPropertyModel.getRowCount() > 0) {
            this.dataTable.changeSelection(0, 0, false, false);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.tableModelSupport.getValue();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        int n2 = tableModelEvent.getFirstRow();
        if (n2 == (n = tableModelEvent.getLastRow())) {
            this.tableModelSupport.fireTableCellUpdated(n2, tableModelEvent.getColumn());
        } else if (tableModelEvent.getType() == -1) {
            this.tableModelSupport.fireTableRowsDeleted(n2, n);
        } else if (tableModelEvent.getType() == 1) {
            this.tableModelSupport.fireTableRowsInserted(n2, n);
        } else {
            this.tableModelSupport.fireTableRowsUpdated(n2, n);
        }
    }

    private void initComponents() {
        this.helpLabel = new JLabel();
        this.dataPane = new JScrollPane();
        this.dataTable = new JTable(this.tableModelSupport);
        this.dataTable.setSelectionMode(0);
        JTextField jTextField = new JTextField();
        CellEditor cellEditor = new CellEditor(this.dataTable, jTextField);
        this.dataTable.setDefaultEditor(String.class, cellEditor);
        this.dataTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ((DefaultCellEditor)this.dataTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.dataTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        defaultTableCellRenderer.setBackground(new Color(212, 208, 200));
        this.dataTable.getTableHeader().setDefaultRenderer(defaultTableCellRenderer);
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.helpLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("TabularPropertyPanel.helpLabel").charAt(0));
        this.helpLabel.setLabelFor(this.dataTable);
        this.helpLabel.setText(bundle.getString("TablePropertyPanel.help"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 10, 10);
        this.add((Component)this.helpLabel, gridBagConstraints);
        this.helpLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TablePropertyPanel.help.desc"));
        this.dataPane.setEnabled(false);
        this.dataTable.setAutoResizeMode(4);
        this.dataTable.setTableHeader(this.dataTable.getTableHeader());
        this.dataPane.setViewportView(this.dataTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.dataPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.newButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("TabularPropertyPanel").charAt(0));
        this.newButton.setText(bundle.getString("SelectOneDomainPanel.button.new"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabularPropertyPanel.this.newActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.newButton);
        this.newButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TabularPropertyPanel.newButton.desc"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("TabularPropertyPanel.deleteButton").charAt(0));
        this.deleteButton.setText(bundle.getString("SelectOneDomainPanel.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabularPropertyPanel.this.deleteActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TabularPropertyPanel.deleteButton.desc"));
        this.upButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("TabularPropertyPanel.upButton").charAt(0));
        this.upButton.setText(bundle.getString("SelectOneDomainPanel.button.up"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabularPropertyPanel.this.upActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.upButton);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TabularPropertyPanel.upButton.desc"));
        this.downButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("TabularPropertyPanel.downButton").charAt(0));
        this.downButton.setText(bundle.getString("SelectOneDomainPanel.button.down"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabularPropertyPanel.this.downActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.downButton);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TabularPropertyPanel.downButton.desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 0, 10);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void downActionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        TableModelSupport tableModelSupport = (TableModelSupport)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0 && (nArray = this.dataTable.getSelectedRows())[0] < this.dataTable.getRowCount() - 1 && tableModelSupport.canMoveRow(nArray[0], nArray[0] + 1)) {
            tableModelSupport.moveRow(nArray[0], nArray[0] + 1);
            this.dataTable.setModel(tableModelSupport);
            this.dataTable.changeSelection(nArray[0] + 1, 0, false, false);
        }
    }

    private void upActionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        TableModelSupport tableModelSupport = (TableModelSupport)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0 && (nArray = this.dataTable.getSelectedRows())[0] > 0 && tableModelSupport.canMoveRow(nArray[0], nArray[0] - 1)) {
            tableModelSupport.moveRow(nArray[0], nArray[0] - 1);
            this.dataTable.setModel(tableModelSupport);
            this.dataTable.changeSelection(nArray[0] - 1, 0, false, false);
        }
    }

    private void deleteActionPerformed(ActionEvent actionEvent) {
        TableModelSupport tableModelSupport = (TableModelSupport)this.dataTable.getModel();
        int n = tableModelSupport.getRowCount();
        if (this.dataTable.getSelectedRowCount() > 0) {
            boolean bl;
            int[] nArray = this.dataTable.getSelectedRows();
            boolean bl2 = bl = nArray[0] == n - 1;
            if (tableModelSupport.canRemoveRow(nArray[0])) {
                tableModelSupport.removeRow(nArray[0]);
                this.dataTable.setModel(tableModelSupport);
                if (tableModelSupport.getRowCount() == 0) {
                    return;
                }
                if (bl) {
                    this.dataTable.changeSelection(tableModelSupport.getRowCount() - 1, 0, false, false);
                } else {
                    this.dataTable.changeSelection(nArray[0], 0, false, false);
                }
            }
        }
    }

    private void newActionPerformed(ActionEvent actionEvent) {
        TableModelSupport tableModelSupport = (TableModelSupport)this.dataTable.getModel();
        if (tableModelSupport.canAddRow()) {
            tableModelSupport.addRow();
            this.dataTable.setModel(tableModelSupport);
            this.dataTable.changeSelection(tableModelSupport.getRowCount() - 1, 0, false, false);
            this.dataTable.requestFocusInWindow();
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        private JTable table;

        public CellEditor(JTable jTable, JTextField jTextField) {
            super(jTextField);
            this.table = jTable;
            jTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TablePropertyPanel.textField.accessibleName"));
            jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TabularPropertyPanel.class, (String)"TablePropertyPanel.textField.accessibleDesc"));
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JTextField)super.getComponent()).setText((String)object);
            if (bl) {
                ((JTextField)super.getComponent()).selectAll();
                jTable.repaint();
            }
            return super.getComponent();
        }
    }

    class HomogonousCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");

        HomogonousCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                component.setBackground(this.SELECTION_BACKGROUND);
            } else {
                component.setBackground(Color.WHITE);
            }
            return component;
        }
    }

    static class TableModelSupport
    extends AbstractTableModel {
        TabularPropertyModel tableModel;

        TableModelSupport(TabularPropertyModel tabularPropertyModel) {
            this.tableModel = tabularPropertyModel;
        }

        public Object getValue() {
            return this.tableModel.getValue();
        }

        public Class getColumnClass(int n) {
            return this.tableModel.getColumnClass(n);
        }

        public String getColumnName(int n) {
            return this.tableModel.getColumnName(n);
        }

        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        public boolean canRemoveRow(int n) {
            return this.tableModel.canRemoveRow(n);
        }

        public boolean removeRow(int n) {
            if (this.tableModel.removeRow(n)) {
                this.fireTableRowsDeleted(n, n);
                return true;
            }
            return false;
        }

        public boolean removeAllRows() {
            int n = this.tableModel.getRowCount();
            if (this.tableModel.removeAllRows()) {
                this.fireTableRowsDeleted(0, n - 1);
                return true;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableModel.setValueAt(object, n, n2);
        }

        public Object getValueAt(int n, int n2) {
            return this.tableModel.getValueAt(n, n2);
        }

        public boolean canAddRow() {
            return this.tableModel.canAddRow();
        }

        public boolean addRow() {
            if (this.tableModel.addRow()) {
                this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
                return true;
            }
            return false;
        }

        public boolean canMoveRow(int n, int n2) {
            return this.tableModel.canMoveRow(n, n2);
        }

        public boolean moveRow(int n, int n2) {
            if (this.tableModel.moveRow(n, n2)) {
                this.fireTableDataChanged();
                return true;
            }
            return false;
        }

        public boolean isCellEditable(int n, int n2) {
            return this.tableModel.isCellEditable(n, n2);
        }
    }
}

