/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.binding.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DataProviderExplorerPanel
extends JPanel
implements ExplorerManager.Provider {
    private final TreeView view = new BeanTreeView();
    private final ServernavChildren children = new ServernavChildren();
    TopComponent tc = WindowManager.getDefault().findTopComponent("serverNavigator");
    ExplorerManager explorerManager = new ExplorerManager();

    public DataProviderExplorerPanel() {
        this.view.setDropTarget(false);
        this.view.setDragSource(false);
        this.view.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.view, "Center");
        this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)this.children));
        this.initialize();
    }

    public void initialize() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("ServerNavigator");
        if (fileObject != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            final ServerNavigatorFolder serverNavigatorFolder = new ServerNavigatorFolder(dataFolder);
            serverNavigatorFolder.recreate();
            serverNavigatorFolder.instanceFinished();
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDeleted(FileEvent fileEvent) {
                    serverNavigatorFolder.recreate();
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    serverNavigatorFolder.recreate();
                }
            });
        }
        this.tc.requestActive();
    }

    public HelpCtx getHelpCtx() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1) {
            return nodeArray[0].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private class ServernavChildren
    extends Children.Keys {
        private ServernavChildren() {
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Node) {
                final Node node = (Node)object;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DataProviderExplorerPanel.this.view != null) {
                            DataProviderExplorerPanel.this.view.expandNode(node);
                        }
                    }
                });
                return new Node[]{node};
            }
            return new Node[0];
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        public void updateKeys(Collection collection) {
            this.setKeys(collection);
        }
    }

    private final class ServerNavigatorFolder
    extends FolderInstance {
        public ServerNavigatorFolder(DataFolder dataFolder) {
            super(dataFolder);
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            final ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < instanceCookieArray.length; ++i) {
                try {
                    Node node;
                    Object object = instanceCookieArray[i].instanceCreate();
                    if (!(object instanceof Node) || !(node = ((Node)object).cloneNode()).getName().equals(NbBundle.getMessage(DataProviderExplorerPanel.class, (String)"DATA_SOURCES"))) continue;
                    arrayList.add(node);
                    DataProviderExplorerPanel.this.view.expandNode(node);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataProviderExplorerPanel.this.children.updateKeys(arrayList);
                }
            });
            return arrayList;
        }
    }
}

