/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.binding.nodes;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetNode;
import org.netbeans.modules.visualweb.propertyeditors.binding.BindingTargetPanel;
import org.netbeans.modules.visualweb.propertyeditors.binding.PropertyBindingHelper;
import org.netbeans.modules.visualweb.propertyeditors.util.Bundle;

public class PropertyTargetNode
extends BindingTargetNode {
    private static Bundle bundle = Bundle.getBundle(PropertyTargetNode.class);
    protected DesignBean bean;
    protected PropertyDescriptor[] propPath;
    protected Object propInstance;
    protected String displayTextEnabled;
    protected String displayTextDisabled;
    boolean iconChecked = false;
    Icon displayIcon = null;

    public PropertyTargetNode(BindingTargetNode bindingTargetNode, DesignBean designBean, PropertyDescriptor[] propertyDescriptorArray, Object object) {
        super(bindingTargetNode);
        this.bean = designBean;
        this.propPath = propertyDescriptorArray;
        this.propInstance = object;
        this.displayTextEnabled = this.getDisplayText(true);
        this.displayTextDisabled = this.getDisplayText(false);
    }

    public DesignBean getBean() {
        return this.bean;
    }

    public PropertyDescriptor[] getPropPath() {
        return this.propPath;
    }

    public Object getPropInstance() {
        return this.propInstance;
    }

    public boolean lazyLoad() {
        this.lazyLoadCustomTargetNodes();
        if (this.propPath == null) {
            this.lazyLoadBeanTargetNodes();
        }
        if (this.isValidBindingTarget()) {
            this.lazyLoadPropertyTargetNodes();
        }
        return true;
    }

    public void lazyLoadCustomTargetNodes() {
    }

    public void lazyLoadBeanTargetNodes() {
        if (this.bean.isContainer()) {
            DesignBean[] designBeanArray = this.bean.getChildBeans();
            for (int i = 0; designBeanArray != null && i < designBeanArray.length; ++i) {
                super.add(PropertyTargetNode._createTargetNode(this, designBeanArray[i], null, designBeanArray[i].getInstance()));
            }
        }
    }

    public void lazyLoadPropertyTargetNodes() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getTargetTypeClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; propertyDescriptorArray != null && i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getReadMethod().getName().equals("getClass")) continue;
                ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
                for (int j = 0; this.propPath != null && j < this.propPath.length; ++j) {
                    arrayList.add(this.propPath[j]);
                }
                arrayList.add(propertyDescriptorArray[i]);
                PropertyDescriptor[] propertyDescriptorArray2 = arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
                BindingTargetNode bindingTargetNode = PropertyTargetNode._createTargetNode(this, this.bean, propertyDescriptorArray2, null);
                super.add(bindingTargetNode);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDisplayText(boolean bl) {
        if (bl && this.displayTextEnabled != null) {
            return this.displayTextEnabled;
        }
        if (!bl && this.displayTextDisabled != null) {
            return this.displayTextDisabled;
        }
        PropertyDescriptor propertyDescriptor = this.propPath != null && this.propPath.length > 0 ? this.propPath[this.propPath.length - 1] : null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        if (!bl) {
            stringBuffer.append("<font color=\"gray\">");
        }
        if (propertyDescriptor != null) {
            stringBuffer.append(bundle.getMessage("property"));
            stringBuffer.append(" ");
        }
        if (bl) {
            stringBuffer.append("<b>");
        }
        if (propertyDescriptor != null) {
            stringBuffer.append(propertyDescriptor.getName());
        } else {
            stringBuffer.append(this.bean.getInstanceName());
        }
        if (bl) {
            stringBuffer.append("</b>");
        }
        stringBuffer.append(" &nbsp; <font><i>");
        stringBuffer.append(this.getTargetTypeDisplayName());
        stringBuffer.append("</i></font>");
        if (!bl) {
            stringBuffer.append("</font>");
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public boolean isValidBindingTarget() {
        if (this.propPath == null && this.bean.getDesignContext() instanceof FacesDesignContext) {
            return ((FacesDesignContext)this.bean.getDesignContext()).isValidBindingTarget(this.bean);
        }
        return true;
    }

    public String getBindingExpressionPart() {
        if (this.propPath != null && this.propPath.length > 0) {
            return this.propPath[this.propPath.length - 1].getName();
        }
        return this.bean.getInstanceName();
    }

    public Class getTargetTypeClass() {
        if (this.propInstance == null) {
            this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
        }
        if (this.propInstance != null && !this.propInstance.getClass().isPrimitive()) {
            return this.propInstance.getClass();
        }
        return this.propPath != null && this.propPath.length > 0 ? this.propPath[this.propPath.length - 1].getPropertyType() : (this.bean.getInstance() != null ? this.bean.getInstance().getClass() : (this.bean.getBeanInfo() != null ? this.bean.getBeanInfo().getBeanDescriptor().getBeanClass() : null));
    }

    public boolean hasDisplayIcon() {
        if (!this.iconChecked) {
            this.displayIcon = this.getDisplayIcon(true);
            this.iconChecked = true;
        }
        return this.displayIcon != null;
    }

    public Icon getDisplayIcon(boolean bl) {
        if (this.displayIcon == null) {
            if (this.propInstance == null) {
                this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
            }
            if (this.propInstance != null) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.propInstance.getClass());
                    Image image = beanInfo.getIcon(1);
                    if (image != null) {
                        this.displayIcon = new ImageIcon(image);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.displayIcon == null && (this.propPath == null || this.propPath.length == 0) && this.bean instanceof MarkupDesignBean && ((MarkupDesignBean)this.bean).getElement() != null) {
                    this.displayIcon = BindingTargetPanel.TAG_ICON;
                }
            }
        }
        if (this.displayIcon == null) {
            this.displayIcon = BindingTargetPanel.BEAN_ICON;
        }
        return this.displayIcon;
    }
}

