/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css.model;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupDesignContext;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;

public class CssStyleParser {
    CssStyleData cssStyleDate = null;
    DesignProperty designProperty = null;

    public CssStyleParser() {
        this(new CssStyleData());
    }

    public CssStyleParser(CssStyleData cssStyleData) {
        this.cssStyleDate = cssStyleData;
    }

    public CssStyleParser(CssStyleData cssStyleData, DesignProperty designProperty) {
        this.cssStyleDate = cssStyleData;
        this.designProperty = designProperty;
    }

    public CssStyleData parse(String string) {
        if (this.designProperty != null) {
            this.cssStyleDate.setDesignProperty(this.designProperty);
            MarkupDesignBean markupDesignBean = (MarkupDesignBean)this.designProperty.getDesignBean();
            MarkupDesignContext markupDesignContext = (MarkupDesignContext)markupDesignBean.getDesignContext();
            Map map = markupDesignContext.convertCssStyleToMap(string);
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                this.cssStyleDate.addProperty(string2, string3);
            }
        } else {
            string = string.replaceAll("&quot;", "\"");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(0, string4.indexOf(":")).trim();
                String string6 = string4.substring(string4.indexOf(":") + 1).trim();
                this.cssStyleDate.addProperty(string5, string6);
            }
        }
        return this.cssStyleDate;
    }

    public static void main(String[] stringArray) {
        String string = "background-color: red; border-left-color: rgb(255, 204, 204); border-right-color: rgb(255, 204, 204); border-top-color: rgb(255, 255, 102); border-bottom-color: rgb(255, 204, 204); border-left-style: double; border-right-style: double; border-top-style: solid; border-bottom-style: double; border-left-width: 44px; border-right-width: 44px; border-top-width: 44px; border-bottom-width: 44px; margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px; left: 72px; top: 48px; padding-left: 10px; padding-right: 10px; padding-top: 10px; padding-bottom: 10px; position: absolute ";
        System.out.println(string);
        CssStyleParser cssStyleParser = new CssStyleParser();
        CssStyleData cssStyleData = cssStyleParser.parse(string);
        System.out.println(cssStyleData.toString());
    }
}

