/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String[] primitiveTypes = new String[]{"string", "int", "decimal", "short", "unsignedShort", "long", "boolean", "float", "double", "duration", "base64Binary", "hexBinary", "date", "time", "dateTime", "anyURI", "QName"};

    public static String getDisplayName(ReferenceableSchemaComponent referenceableSchemaComponent) {
        if (referenceableSchemaComponent == null) {
            return "null";
        }
        if (referenceableSchemaComponent instanceof GlobalSimpleType) {
            return "xsd:" + referenceableSchemaComponent.getName();
        }
        if (referenceableSchemaComponent instanceof GlobalElement) {
            return "schema element: {" + referenceableSchemaComponent.getModel().getEffectiveNamespace((SchemaComponent)referenceableSchemaComponent) + "}" + referenceableSchemaComponent.getName();
        }
        return "{" + referenceableSchemaComponent.getModel().getEffectiveNamespace((SchemaComponent)referenceableSchemaComponent) + "}" + referenceableSchemaComponent.getName();
    }

    public static List<GlobalSimpleType> getPrimitiveTypes() {
        ArrayList<GlobalSimpleType> arrayList = new ArrayList<GlobalSimpleType>();
        for (String string : primitiveTypes) {
            GlobalSimpleType globalSimpleType = Utils.getPrimitiveType(string);
            if (globalSimpleType == null) continue;
            arrayList.add(globalSimpleType);
        }
        return arrayList;
    }

    public static List<Schema> getImportedSchemas(WSDLModel wSDLModel) {
        ArrayList<Schema> arrayList = new ArrayList<Schema>();
        Definitions definitions = wSDLModel.getDefinitions();
        Types types = definitions.getTypes();
        if (types != null) {
            Collection collection = types.getSchemas();
            for (Schema schema : collection) {
                Collection collection2 = schema.getImports();
                for (Import import_ : collection2) {
                    arrayList.add(import_.getModel().getSchema());
                }
            }
        }
        return arrayList;
    }

    public static List<ReferenceableSchemaComponent> getSchemaTypes(WSDLModel wSDLModel) throws CatalogModelException {
        Definitions definitions = wSDLModel.getDefinitions();
        Types types = definitions.getTypes();
        Collection collection = types.getSchemas();
        ArrayList<ReferenceableSchemaComponent> arrayList = new ArrayList<ReferenceableSchemaComponent>();
        arrayList.addAll(Utils.getPrimitiveTypes());
        for (Schema schema : collection) {
            String string = schema.getTargetNamespace();
            if (string != null) {
                Utils.populateWithElements(wSDLModel, schema.getModel(), arrayList);
            }
            Collection collection2 = schema.getImports();
            for (Import import_ : collection2) {
                SchemaModel schemaModel = import_.resolveReferencedModel();
                Utils.populateWithElements(wSDLModel, schemaModel, arrayList);
            }
        }
        return arrayList;
    }

    private static void populateWithElements(WSDLModel wSDLModel, SchemaModel schemaModel, List<ReferenceableSchemaComponent> list) {
        Object object;
        Object object22;
        Collection collection = schemaModel.getSchema().getElements();
        for (Object object22 : collection) {
            if (Utils.isUsedInOperation(wSDLModel, (GlobalElement)object22)) continue;
            list.add((ReferenceableSchemaComponent)object22);
        }
        Collection collection2 = schemaModel.getSchema().getComplexTypes();
        object22 = collection2.iterator();
        while (object22.hasNext()) {
            object = (GlobalType)object22.next();
            list.add((ReferenceableSchemaComponent)object);
        }
        object22 = schemaModel.getSchema().getSimpleTypes();
        object = object22.iterator();
        while (object.hasNext()) {
            GlobalType globalType = (GlobalType)object.next();
            list.add((ReferenceableSchemaComponent)globalType);
        }
    }

    public static boolean isUsedInOperation(WSDLModel wSDLModel, GlobalElement globalElement) {
        Collection collection = wSDLModel.getDefinitions().getMessages();
        for (Message message : collection) {
            Collection collection2 = message.getParts();
            for (Part part : collection2) {
                NamedComponentReference namedComponentReference = part.getElement();
                if (namedComponentReference == null || !globalElement.equals(namedComponentReference.get())) continue;
                return true;
            }
        }
        return false;
    }

    public static GlobalSimpleType getPrimitiveType(String string) {
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
        Collection collection = schemaModel.getSchema().getSimpleTypes();
        for (GlobalSimpleType globalSimpleType : collection) {
            if (!globalSimpleType.getName().equals(string)) continue;
            return globalSimpleType;
        }
        return null;
    }
}

