/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.bpel.project.ProjectCloseListener;

public class ProjectCloseSupport {
    private Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private List<ProjectCloseListener> myListeners = new ArrayList<ProjectCloseListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectCloseListener(ProjectCloseListener projectCloseListener) {
        assert (projectCloseListener != null) : "Try to add null listener.";
        this.writeLock.lock();
        try {
            this.myListeners.add(projectCloseListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectCloseListener(ProjectCloseListener projectCloseListener) {
        assert (projectCloseListener != null) : "Try to remove null listener.";
        this.writeLock.lock();
        try {
            this.myListeners.remove(projectCloseListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllProjectCloseListeners() {
        this.writeLock.lock();
        try {
            this.myListeners.removeAll(this.myListeners);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectClosed() {
        this.writeLock.lock();
        try {
            for (ProjectCloseListener projectCloseListener : this.myListeners) {
                projectCloseListener.projectClosed();
            }
            this.removeAllProjectCloseListeners();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

