/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.bpel.project.PackageDisplayUtils;
import org.netbeans.modules.bpel.project.ui.PackageRenameHandler;
import org.netbeans.modules.bpel.project.ui.PackageRootNode;
import org.netbeans.modules.bpel.project.ui.PackageView;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

final class PackageViewChildren
extends Children.Keys
implements FileChangeListener,
ChangeListener,
Runnable {
    private static final String NODE_NOT_CREATED = "NNC";
    private static final String NODE_NOT_CREATED_EMPTY = "NNC_E";
    private static final MessageFormat PACKAGE_FLAVOR = new MessageFormat("application/x-java-org-netbeans-modules-java-project-packagenodednd; class=org.netbeans.spi.java.project.support.ui.PackageViewChildren$PackageNode; mask={0}");
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-java-org-netbeans-modules-java-project-packagenodednd";
    static final String MASK = "mask";
    private Map names2nodes;
    private final FileObject root;
    private FileChangeListener wfcl;
    private ChangeListener wvqcl;
    RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);

    public PackageViewChildren(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException();
        }
        this.root = fileObject;
    }

    FileObject getRoot() {
        return this.root;
    }

    protected Node[] createNodes(Object object) {
        FileObject fileObject = this.root.getFileObject((String)object);
        if (fileObject != null && fileObject.isValid()) {
            Object v = this.names2nodes.get(object);
            PackageNode packageNode = v == NODE_NOT_CREATED ? new PackageNode(this.root, DataFolder.findFolder((FileObject)fileObject), false) : (v == NODE_NOT_CREATED_EMPTY ? new PackageNode(this.root, DataFolder.findFolder((FileObject)fileObject), true) : new PackageNode(this.root, DataFolder.findFolder((FileObject)fileObject)));
            this.names2nodes.put(object, packageNode);
            return new Node[]{packageNode};
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.task.schedule(0);
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            Node[] nodeArray = super.getNodes(false);
            this.task.waitFinished();
        }
        return super.getNodes(false);
    }

    public Node findChild(String string) {
        this.getNodes(true);
        return super.findChild(string);
    }

    public void run() {
        this.computeKeys();
        this.refreshKeys();
        try {
            FileSystem fileSystem = this.root.getFileSystem();
            this.wfcl = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)fileSystem);
            fileSystem.addFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        this.wvqcl = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
        VisibilityQuery.getDefault().addChangeListener(this.wvqcl);
    }

    protected void removeNotify() {
        VisibilityQuery.getDefault().removeChangeListener(this.wvqcl);
        try {
            this.root.getFileSystem().removeFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        this.setKeys(Collections.EMPTY_SET);
        this.names2nodes.clear();
        super.removeNotify();
    }

    private void refreshKeys() {
        this.setKeys(this.names2nodes.keySet());
    }

    private void refreshKeysAsync() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PackageViewChildren.this.refreshKeys();
            }
        });
    }

    private void computeKeys() {
        this.names2nodes = new TreeMap();
        this.findNonExcludedPackages(this.root);
    }

    private void findNonExcludedPackages(FileObject fileObject) {
        PackageView.findNonExcludedPackages(this, fileObject);
    }

    private void cleanEmptyKeys(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (this.root.equals(fileObject2)) {
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode != null && PackageDisplayUtils.isEmpty(this.root, false)) {
                this.remove(this.root);
            }
            return;
        }
        while (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject2)) {
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode != null && packageNode.isLeaf()) {
                this.remove(fileObject2);
            }
            fileObject2 = fileObject2.getParent();
        }
    }

    void add(FileObject fileObject, boolean bl) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Adding wrong folder " + fileObject + "(valid=" + fileObject.isValid() + ")" + "under root" + this.root + "(valid=" + this.root.isValid() + ")";
        if (this.get(fileObject) == null) {
            this.names2nodes.put(string, bl ? NODE_NOT_CREATED_EMPTY : NODE_NOT_CREATED);
        }
    }

    private void remove(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Removing wrong folder" + fileObject;
        this.names2nodes.remove(string);
    }

    private void removeSubTree(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Removing wrong folder" + fileObject;
        HashSet hashSet = new HashSet(this.names2nodes.keySet());
        this.names2nodes.remove(string);
        string = string + '/';
        for (String string2 : hashSet) {
            if (!string2.startsWith(string)) continue;
            this.names2nodes.remove(string2);
        }
    }

    private PackageNode get(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Asking for wrong folder" + fileObject;
        Object v = this.names2nodes.get(string);
        return !this.isNodeCreated(v) ? null : (PackageNode)((Object)v);
    }

    private boolean contains(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        assert (string != null) : "Asking for wrong folder" + fileObject;
        Object v = this.names2nodes.get(string);
        return v != null;
    }

    private boolean exists(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        return this.names2nodes.get(string) != null;
    }

    private boolean isNodeCreated(Object object) {
        return object instanceof Node;
    }

    private PackageNode updatePath(String string, String string2) {
        Object v = this.names2nodes.get(string);
        if (v == null) {
            return null;
        }
        this.names2nodes.remove(string);
        this.names2nodes.put(string2, v);
        return !this.isNodeCreated(v) ? null : (PackageNode)((Object)v);
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            this.cleanEmptyKeys(fileObject);
            this.findNonExcludedPackages(fileObject);
            this.refreshKeys();
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            FileObject fileObject2 = fileObject.getParent();
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) {
                return;
            }
            PackageNode packageNode = this.get(fileObject2);
            if (packageNode == null && !this.contains(fileObject2)) {
                this.add(fileObject2, false);
                this.refreshKeys();
            } else if (packageNode != null) {
                packageNode.updateChildren();
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && this.isVisible(this.root, fileObject)) {
            if (fileObject.isFolder() || this.get(fileObject) != null) {
                this.removeSubTree(fileObject);
                FileObject fileObject2 = fileObject.getParent();
                if ((FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject2) || this.root.equals(fileObject2)) && this.get(fileObject2) == null && fileObject2.isValid() && !this.toBeRemoved(fileObject2)) {
                    this.add(fileObject2, true);
                }
                this.refreshKeysAsync();
            } else {
                FileObject fileObject3 = fileObject.getParent();
                final PackageNode packageNode = this.get(fileObject3);
                if (packageNode != null) {
                    boolean bl = packageNode.isLeaf();
                    DataFolder dataFolder = packageNode.getDataFolder();
                    boolean bl2 = PackageNode.isEmpty(dataFolder);
                    if (bl != bl2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                packageNode.updateChildren();
                            }
                        });
                    } else {
                        packageNode.updateChildren();
                    }
                }
                if (this.toBeRemoved(fileObject3)) {
                    this.remove(fileObject3);
                    this.refreshKeysAsync();
                }
            }
        }
    }

    private boolean toBeRemoved(FileObject fileObject) {
        boolean bl = true;
        boolean bl2 = true;
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            bl = false;
            if (fileObjectArray[i].isFolder()) continue;
            bl2 = false;
            break;
        }
        if (bl) {
            return false;
        }
        return bl2;
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fileObject) && fileObject.isFolder()) {
            String string4;
            String string2 = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject.getParent());
            String string3 = string2 + (string2.length() == 0 ? "" : "/") + fileRenameEvent.getName() + fileRenameEvent.getExt();
            boolean bl = VisibilityQuery.getDefault().isVisible(fileObject);
            boolean bl2 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string4 : this.names2nodes.keySet()) {
                if (!string4.startsWith(string3)) continue;
                if (bl) {
                    arrayList.add(string4);
                    continue;
                }
                this.names2nodes.remove(string4);
                bl2 = true;
            }
            if (this.get(fileObject) == null && bl) {
                this.cleanEmptyKeys(fileObject);
                this.findNonExcludedPackages(fileObject);
                bl2 = true;
            }
            int n = string3.length();
            string4 = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            for (String string5 : arrayList) {
                StringBuffer stringBuffer = new StringBuffer(string5);
                stringBuffer.replace(0, n, string4);
                PackageNode packageNode = this.updatePath(string5, stringBuffer.toString());
                if (packageNode == null) continue;
                packageNode.updateDisplayName();
            }
            if (arrayList.size() > 1 || bl2) {
                this.refreshKeys();
            }
        }
    }

    private boolean isVisible(FileObject fileObject, FileObject fileObject2) {
        do {
            if (VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            return false;
        } while ((fileObject2 = fileObject2.getParent()) != null && fileObject2 != fileObject);
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.computeKeys();
        this.refreshKeys();
    }

    private static class NonResursiveFolderSet
    extends HashSet
    implements NonRecursiveFolder {
        private final FileObject folder;

        public NonResursiveFolderSet(FileObject fileObject) {
            this.folder = fileObject;
            this.add(fileObject);
        }

        public FileObject getFolder() {
            return this.folder;
        }
    }

    static class PackagePasteType
    extends PasteType {
        private int op;
        private PackageNode[] nodes;
        private FileObject srcRoot;

        public PackagePasteType(FileObject fileObject, PackageNode[] packageNodeArray, int n) {
            assert (n == 1 || n == 2 || n == 0) : "Invalid DnD operation";
            this.nodes = packageNodeArray;
            this.op = n;
            this.srcRoot = fileObject;
        }

        public void setOperation(int n) {
            this.op = n;
        }

        public Transferable paste() throws IOException {
            assert (this.op != 0);
            for (int i = 0; i < this.nodes.length; ++i) {
                Object object;
                Object object2;
                FileObject fileObject = this.srcRoot;
                if (!this.nodes[i].isDefaultPackage) {
                    object2 = this.nodes[i].getName();
                    object = new StringTokenizer((String)object2, ".");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string = ((StringTokenizer)object).nextToken();
                        FileObject fileObject2 = fileObject.getFileObject(string, null);
                        if (fileObject2 == null) {
                            fileObject2 = fileObject.createFolder(string);
                        }
                        fileObject = fileObject2;
                    }
                }
                object2 = DataFolder.findFolder((FileObject)fileObject);
                object = this.nodes[i].dataFolder.getChildren();
                boolean bl = false;
                for (int j = 0; j < ((Object)object).length; ++j) {
                    if (object[j].getPrimaryFile().isData() && VisibilityQuery.getDefault().isVisible(object[j].getPrimaryFile())) {
                        object[j].copy(object2);
                        if (this.op != 2) continue;
                        try {
                            object[j].delete();
                        }
                        catch (IOException iOException) {
                            bl = true;
                        }
                        continue;
                    }
                    bl = true;
                }
                if (this.op != 2 || bl) continue;
                try {
                    FileObject fileObject3 = this.nodes[i].dataFolder.getPrimaryFile();
                    FileObject fileObject4 = this.nodes[i].root;
                    assert (fileObject3 != null && fileObject4 != null);
                    while (!fileObject3.equals(fileObject4) && fileObject3.getChildren().length == 0) {
                        FileObject fileObject5 = fileObject3.getParent();
                        fileObject3.delete();
                        fileObject3 = fileObject5;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return ExTransferable.EMPTY;
        }

        public String getName() {
            return NbBundle.getMessage(PackageViewChildren.class, (String)"TXT_PastePackage");
        }
    }

    static class PackageTransferable
    extends ExTransferable.Single {
        private PackageNode node;

        public PackageTransferable(PackageNode packageNode, int n) throws ClassNotFoundException {
            super(new DataFlavor(PACKAGE_FLAVOR.format(new Object[]{new Integer(n)}), null, PackageNode.class.getClassLoader()));
            this.node = packageNode;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    static final class NoFoldersDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject) && !(dataObject instanceof DataFolder);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    private static final class NoFoldersContainer
    implements DataObject.Container,
    PropertyChangeListener,
    NonRecursiveFolder {
        private DataFolder folder;
        private PropertyChangeSupport prop = new PropertyChangeSupport(this);

        public NoFoldersContainer(DataFolder dataFolder) {
            this.folder = dataFolder;
        }

        public FileObject getFolder() {
            return this.folder.getPrimaryFile();
        }

        public DataObject[] getChildren() {
            DataObject[] dataObjectArray = this.folder.getChildren();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (dataObjectArray[i] instanceof DataFolder) continue;
                arrayList.add(dataObjectArray[i]);
            }
            return arrayList.size() == dataObjectArray.length ? dataObjectArray : arrayList.toArray(new DataObject[0]);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop.removePropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("children".equals(propertyChangeEvent.getPropertyName())) {
                this.prop.firePropertyChange("children", null, null);
            }
        }
    }

    static final class PackageNode
    extends FilterNode {
        private static final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();
        private final FileObject root;
        private DataFolder dataFolder;
        private boolean isDefaultPackage;
        private static Action[] actions;

        public PackageNode(FileObject fileObject, DataFolder dataFolder) {
            this(fileObject, dataFolder, PackageNode.isEmpty(dataFolder));
        }

        public PackageNode(FileObject fileObject, DataFolder dataFolder, boolean bl) {
            super(dataFolder.getNodeDelegate(), bl ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(NO_FOLDERS_FILTER), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new NoFoldersContainer(dataFolder)), dataFolder.getNodeDelegate().getLookup(), Lookups.singleton((Object)PackageRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)false, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER})))}));
            this.root = fileObject;
            this.dataFolder = dataFolder;
            this.isDefaultPackage = fileObject.equals(dataFolder.getPrimaryFile());
        }

        FileObject getRoot() {
            return this.root;
        }

        public String getName() {
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.dataFolder.getPrimaryFile());
            return string == null ? null : string.replace('/', '.');
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                if (actions == null) {
                    Action[] actionArray = super.getActions(bl);
                    ArrayList<Action> arrayList = new ArrayList<Action>(actionArray.length);
                    for (int i = 0; i < actionArray.length; ++i) {
                        if (actionArray[i] == null && actionArray[i + 1] instanceof PropertiesAction) {
                            ++i;
                            continue;
                        }
                        if (actionArray[i] instanceof PropertiesAction || actionArray[i] != null && actionArray[i].getClass().getName().equals("org.netbeans.modules.refactoring.ui.RSMJavaDOAction")) continue;
                        arrayList.add(actionArray[i]);
                    }
                    actions = new Action[arrayList.size()];
                    arrayList.toArray(actions);
                }
                return actions;
            }
            return super.getActions(bl);
        }

        public boolean canRename() {
            return !this.isDefaultPackage;
        }

        public boolean canCut() {
            return !this.isDefaultPackage;
        }

        public Transferable clipboardCopy() throws IOException {
            try {
                return new PackageTransferable(this, 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public Transferable clipboardCut() throws IOException {
            try {
                return new PackageTransferable(this, 2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public Transferable drag() throws IOException {
            try {
                return new PackageTransferable(this, 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }

        public PasteType[] getPasteTypes(Transferable transferable) {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    boolean bl = false;
                    for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                        DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(dataFlavorArray)) continue;
                        bl = true;
                    }
                    return bl ? new PasteType[]{} : super.getPasteTypes(transferable);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                    return new PasteType[0];
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return new PasteType[0];
                }
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (this.isPackageFlavor(dataFlavorArray)) {
                return new PasteType[0];
            }
            return super.getPasteTypes(transferable);
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    boolean bl = false;
                    for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                        DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(dataFlavorArray)) continue;
                        bl = true;
                    }
                    return bl ? null : super.getDropType(transferable, n, n2);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                    return null;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return null;
                }
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (this.isPackageFlavor(dataFlavorArray)) {
                return null;
            }
            return super.getDropType(transferable, n, n2);
        }

        private boolean isPackageFlavor(DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!PackageViewChildren.SUBTYPE.equals(dataFlavorArray[i].getSubType()) || !PackageViewChildren.PRIMARY_TYPE.equals(dataFlavorArray[i].getPrimaryType())) continue;
                return true;
            }
            return false;
        }

        private static synchronized PackageRenameHandler getRenameHandler() {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(PackageRenameHandler.class));
            List list = (List)result.allInstances();
            if (list.size() == 0) {
                return null;
            }
            if (list.size() > 1) {
                ErrorManager.getDefault().log(16, "Multiple instances of PackageRenameHandler found in Lookup; only using first one: " + list);
            }
            return (PackageRenameHandler)list.get(0);
        }

        public void setName(String string) {
            int n;
            int n2;
            PackageRenameHandler packageRenameHandler = PackageNode.getRenameHandler();
            if (packageRenameHandler != null) {
                packageRenameHandler.handleRename((Node)this, string);
                return;
            }
            if (this.isDefaultPackage) {
                return;
            }
            String string2 = this.getName();
            if (string2.equals(string)) {
                return;
            }
            if (!PackageNode.isValidPackageName(string)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PackageViewChildren.class, (String)"MSG_InvalidPackageName"), 1));
                return;
            }
            string = string.replace('.', '/') + '/';
            string2 = string2.replace('.', '/') + '/';
            for (n2 = 0; n2 < string2.length() && n2 < string.length() && string2.charAt(n2) == string.charAt(n2); ++n2) {
            }
            String string3 = (n = string2.lastIndexOf(47, --n2)) == -1 ? null : string2.substring(0, n);
            String string4 = n + 1 == string.length() ? "" : string.substring(n + 1);
            try {
                FileObject fileObject;
                String string5;
                FileObject fileObject2;
                FileObject fileObject3 = fileObject2 = string3 == null ? this.root : this.root.getFileObject(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    fileObject = fileObject3.getFileObject(string5);
                    if (fileObject == null) {
                        fileObject = fileObject3.createFolder(string5);
                    }
                    fileObject3 = fileObject;
                }
                string5 = this.dataFolder.getPrimaryFile();
                fileObject = DataFolder.findFolder((FileObject)string5);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject3);
                DataObject[] dataObjectArray = fileObject.getChildren();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    if (!dataObjectArray[i].getPrimaryFile().isData()) continue;
                    dataObjectArray[i].move(dataFolder);
                }
                while (!fileObject2.equals(string5) && string5.getChildren().length == 0) {
                    String string6 = string5;
                    string5 = string5.getParent();
                    string6.delete();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public boolean canDestroy() {
            return !this.isDefaultPackage;
        }

        public void destroy() throws IOException {
            FileObject fileObject = this.dataFolder.getPrimaryFile().getParent();
            DataObject[] dataObjectArray = this.dataFolder.getChildren();
            boolean bl = true;
            for (int i = 0; dataObjectArray != null && i < dataObjectArray.length; ++i) {
                if (!dataObjectArray[i].getPrimaryFile().isFolder()) {
                    dataObjectArray[i].delete();
                    continue;
                }
                bl = false;
            }
            if (bl) {
                super.destroy();
            }
            while (!fileObject.equals(this.root) && fileObject.getChildren().length == 0) {
                FileObject fileObject2 = fileObject.getParent();
                fileObject.delete();
                fileObject = fileObject2;
            }
        }

        public String getHtmlDisplayName() {
            String string = this.getDisplayName();
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet nonResursiveFolderSet = new NonResursiveFolderSet(fileObject);
                FileSystem.Status status = fileObject.getFileSystem().getStatus();
                string = status instanceof FileSystem.HtmlStatus ? ((FileSystem.HtmlStatus)status).annotateNameHtml(string, (Set)nonResursiveFolderSet) : status.annotateName(string, (Set)nonResursiveFolderSet);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return string;
        }

        public String getDisplayName() {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return "";
            }
            return PackageDisplayUtils.getDisplayLabel(string.replace('/', '.'));
        }

        public String getShortDescription() {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return "";
            }
            return PackageDisplayUtils.getToolTip(fileObject, string.replace('/', '.'));
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet nonResursiveFolderSet = new NonResursiveFolderSet(fileObject);
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, (Set)nonResursiveFolderSet);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            try {
                FileObject fileObject = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet nonResursiveFolderSet = new NonResursiveFolderSet(fileObject);
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, (Set)nonResursiveFolderSet);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return image;
        }

        private Image getMyIcon(int n) {
            FileObject fileObject = this.dataFolder.getPrimaryFile();
            String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
            if (string == null) {
                return null;
            }
            return PackageDisplayUtils.getIcon(fileObject, string.replace('/', '.'), this.isLeaf());
        }

        private Image getMyOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void update() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public void updateDisplayName() {
        }

        public void updateChildren() {
            DataFolder dataFolder;
            boolean bl;
            boolean bl2 = this.isLeaf();
            if (bl2 != (bl = PackageNode.isEmpty(dataFolder = this.getDataFolder()))) {
                this.setChildren(bl ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(NO_FOLDERS_FILTER));
                this.update();
            }
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] propertySetArray = super.getPropertySets();
            for (int i = 0; i < propertySetArray.length; ++i) {
                if (!"properties".equals(propertySetArray[i].getName())) continue;
                propertySetArray[i] = Sheet.createPropertiesSet();
                ((Sheet.Set)propertySetArray[i]).put((Node.Property)new PropertySupport.ReadWrite("name", String.class, NbBundle.getMessage(PackageViewChildren.class, (String)"PROP_name"), NbBundle.getMessage(PackageViewChildren.class, (String)"HINT_name")){

                    public Object getValue() {
                        return PackageNode.this.getName();
                    }

                    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        if (!PackageNode.this.canRename()) {
                            throw new IllegalAccessException();
                        }
                        if (!(object instanceof String)) {
                            throw new IllegalArgumentException();
                        }
                        PackageNode.this.setName((String)object);
                    }

                    public boolean canWrite() {
                        return PackageNode.this.canRename();
                    }
                });
            }
            return propertySetArray;
        }

        private DataFolder getDataFolder() {
            return (DataFolder)this.getCookie(DataFolder.class);
        }

        private static boolean isEmpty(DataFolder dataFolder) {
            if (dataFolder == null) {
                return true;
            }
            return PackageDisplayUtils.isEmpty(dataFolder.getPrimaryFile());
        }

        private static boolean isValidPackageName(String string) {
            if (string.length() == 0) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!bl) {
                    if (string2.equals(".")) {
                        return false;
                    }
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
                        return false;
                    }
                } else if (!string2.equals(".")) {
                    return false;
                }
                bl = !bl;
            }
            return bl;
        }
    }
}

