/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable {
    IntList lineStartList;
    IntMap linesToListeners;
    private int longestLineLen = 0;
    private int knownCharsPerLine = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private IntList errLines = null;
    private int lastErrLineMarked = -1;
    private ChangeListener listener = null;
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private boolean lastLineFinished = true;
    private int lastLineLength = -1;
    private String lastSearchString = null;
    private Matcher matcher = null;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract boolean isTrouble();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getText(int n, int n2, char[] cArray) {
        if (this.isDisposed() || this.isTrouble()) {
            if (Controller.LOG) {
                Controller.log(this + "  !!!!!REQUEST FOR SUBRANGE " + n + "-" + n2 + " AFTER OUTWRITER HAS BEEN DISPOSED!!");
            }
            char[] cArray2 = "THIS OUTPUT HAS BEEN DISPOSED! ".toCharArray();
            if (cArray == null) {
                cArray = new char[n2 - n];
            }
            int n3 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (n3 == cArray2.length - 1) {
                    n3 = 0;
                }
                cArray[i] = cArray2[n3];
                ++n3;
            }
            return cArray;
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        Object object = this.readLock();
        synchronized (object) {
            int n4 = AbstractLines.toByteIndex(n);
            int n5 = AbstractLines.toByteIndex(n2 - n);
            try {
                CharBuffer charBuffer = this.getStorage().getReadBuffer(n4, n5).asCharBuffer();
                int n6 = Math.min(n2 - n, charBuffer.remaining());
                if (cArray.length < n6) {
                    cArray = new char[n6];
                }
                charBuffer.get(cArray, 0, n6);
                return cArray;
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) {
        if (this.isDisposed() || this.isTrouble()) {
            return new String(new char[n2 - n]);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Illogical text range from " + n + " to " + n2);
        }
        Object object = this.readLock();
        synchronized (object) {
            int n3 = AbstractLines.toByteIndex(n);
            int n4 = AbstractLines.toByteIndex(n2 - n);
            int n5 = this.getStorage().size();
            if (n5 < n3 + n4) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + n3 + " to " + (n3 + n4) + " requested, " + "but storage is only " + n5 + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(n3, n4).asCharBuffer().toString();
            }
            catch (Exception exception) {
                this.handleException(exception);
                return new String(new char[n2 - n]);
            }
        }
    }

    void markErr() {
        int n;
        if (this.isTrouble() || this.getStorage().isClosed()) {
            return;
        }
        if (this.errLines == null) {
            this.errLines = new IntList(20);
        }
        if ((n = this.getLineCount()) != this.lastErrLineMarked) {
            this.errLines.add(n == 0 ? 0 : n - (this.isLastLineFinished() ? 2 : 1));
            this.lastErrLineMarked = n;
        }
    }

    public boolean isErr(int n) {
        return this.errLines != null ? this.errLines.contains(n) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        this.listener = changeListener;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == changeListener) {
            this.listener = null;
        }
    }

    public void fire() {
        if (this.isTrouble()) {
            return;
        }
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean hasHyperlinks() {
        return this.firstListenerLine() != -1;
    }

    public boolean isHyperlink(int n) {
        return this.getListenerForLine(n) != null;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.lineStartList.add(0);
        this.linesToListeners = new IntMap();
        this.longestLineLen = 0;
        this.errLines = null;
        this.matcher = null;
        this.listener = null;
        this.dirty = false;
    }

    public boolean checkDirty(boolean bl) {
        if (this.isTrouble()) {
            return false;
        }
        boolean bl2 = this.dirty;
        if (bl) {
            this.dirty = false;
        }
        return bl2;
    }

    public int[] allListenerLines() {
        return this.linesToListeners.getKeys();
    }

    void clear() {
        this.init();
    }

    public int getCharCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        Storage storage = this.getStorage();
        return storage == null ? 0 : AbstractLines.toCharIndex(this.getStorage().size());
    }

    public String getLine(int n) throws IOException {
        if (this.isDisposed() || this.isTrouble()) {
            return "";
        }
        int n2 = this.getByteLineStart(n);
        int n3 = n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) : this.getStorage().size();
        CharBuffer charBuffer = this.getStorage().getReadBuffer(n2, n3 - n2).asCharBuffer();
        char[] cArray = new char[charBuffer.limit()];
        charBuffer.get(cArray);
        return new String(cArray);
    }

    private int getLineLength(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        if (n == this.lineStartList.size() - 1) {
            return Math.max(0, AbstractLines.toByteIndex(this.lastLineLength));
        }
        int n2 = this.getByteLineStart(n);
        int n3 = n < this.lineStartList.size() - 1 ? this.lineStartList.get(n + 1) - 2 : this.getStorage().size();
        return n3 - n2;
    }

    public boolean isLineStart(int n) {
        int n2 = AbstractLines.toByteIndex(n);
        return this.lineStartList.contains(n2) || n2 == 0 || n2 == this.getStorage().size() && this.lastLineFinished;
    }

    public int length(int n) {
        return AbstractLines.toCharIndex(this.getLineLength(n));
    }

    public int getLineStart(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        return this.getCharLineStart(n);
    }

    private int getByteLineStart(int n) {
        if (n == this.lineStartList.size() && this.lastLineFinished) {
            return this.getStorage().size();
        }
        return this.lineStartList.get(n);
    }

    private int getCharLineStart(int n) {
        return AbstractLines.toCharIndex(this.getByteLineStart(n));
    }

    public int getLineAt(int n) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        int n2 = AbstractLines.toByteIndex(n);
        if (n2 >= this.getStorage().size()) {
            return this.getLineCount() - 1;
        }
        return this.lineStartList.findNearest(n2);
    }

    public int getLineCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        return this.lineStartList.size();
    }

    public OutputListener getListenerForLine(int n) {
        return (OutputListener)this.linesToListeners.get(n);
    }

    public int firstListenerLine() {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.isEmpty() ? -1 : this.linesToListeners.first();
    }

    public int nearestListenerLine(int n, boolean bl) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.nearest(n, bl);
    }

    public int getLongestLineLength() {
        return this.longestLineLen;
    }

    public void toPhysicalLineIndex(int[] nArray, int n) {
        int n2 = nArray[0];
        if (n2 <= 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = AbstractLines.lengthToLineCount(this.length(0), n);
            return;
        }
        if (n >= this.longestLineLen || this.getLineCount() < 1) {
            nArray[1] = 0;
            nArray[2] = 1;
            return;
        }
        int n3 = Math.min(this.findPhysicalLine(n2, n), this.getLineCount() - 1);
        int n4 = this.getLogicalLineCountAbove(n3, n);
        int n5 = this.length(n3);
        int n6 = AbstractLines.lengthToLineCount(n5, n);
        nArray[0] = n3;
        nArray[1] = n2 - n4;
        nArray[2] = n6;
    }

    private int findPhysicalLine(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.getNextKey(n);
    }

    public int getLogicalLineCountAbove(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 >= this.longestLineLen) {
            return n;
        }
        if (n2 != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
            this.calcLogicalLineCount(n2);
        }
        return this.knownLogicalLineCounts.get(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogicalLineCountIfWrappedAt(int n) {
        if (n >= this.longestLineLen) {
            return this.getLineCount();
        }
        int n2 = this.getLineCount();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (n != this.knownCharsPerLine || this.knownLogicalLineCounts == null) {
                this.calcLogicalLineCount(n);
            }
            return this.knownLogicalLineCounts.get(n2 - 1);
        }
    }

    public void addListener(int n, OutputListener outputListener, boolean bl) {
        if (outputListener == null) {
            Logger.getLogger(AbstractLines.class.getName()).log(Level.WARNING, "Issue #56826 - Adding a null OutputListener for line: " + n, new NullPointerException());
        } else {
            this.linesToListeners.put(n, outputListener);
            if (bl) {
                this.importantLines.add(n);
            }
        }
    }

    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    public boolean isImportantHyperlink(int n) {
        return this.importantLines.contains(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcLogicalLineCount(int n) {
        Object object = this.readLock();
        synchronized (object) {
            int n2 = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = this.length(i);
                if (n4 > n) {
                    this.knownLogicalLineCounts.add(i, n3 += AbstractLines.lengthToLineCount(n4, n));
                    continue;
                }
                ++n3;
            }
            this.knownCharsPerLine = n;
        }
    }

    static int lengthToLineCount(int n, int n2) {
        return n > n2 ? (n2 == 0 ? n : (n + n2 - 1) / n2) : 1;
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isLastLineFinished() {
        return this.lastLineFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLine(int n, int n2) {
        Object object = this.readLock();
        synchronized (object) {
            boolean bl;
            this.longestLineLen = Math.max(this.longestLineLen, n2);
            if (this.knownLogicalLineCounts == null) {
                return;
            }
            boolean bl2 = bl = this.knownLogicalLineCounts.lastIndex() == n;
            if (bl) {
                assert (!this.lastLineFinished);
                if (n2 <= this.knownCharsPerLine) {
                    this.knownLogicalLineCounts.removeLast();
                } else {
                    int n3 = this.knownLogicalLineCounts.lastAdded() - AbstractLines.lengthToLineCount(this.lastLineLength, this.knownCharsPerLine) + AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine);
                    this.knownLogicalLineCounts.updateLast(n, n3);
                }
            } else {
                if (n2 <= this.knownCharsPerLine) {
                    return;
                }
                int n4 = this.knownLogicalLineCounts.lastIndex() != -1 ? n - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, n - 1);
                this.knownLogicalLineCounts.add(n, n4 += AbstractLines.lengthToLineCount(n2, this.knownCharsPerLine));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineUpdated(int n, int n2, boolean bl) {
        Object object = this.readLock();
        synchronized (object) {
            int n3 = AbstractLines.toCharIndex(n2);
            this.updateLastLine(this.lineStartList.size() - 1, n3);
            if (bl) {
                this.lineStartList.add(n + n2);
            }
            this.matcher = null;
            this.lastLineFinished = bl;
            this.lastLineLength = bl ? -1 : n3;
        }
        this.fire();
    }

    static int toByteIndex(int n) {
        return n << 1;
    }

    static int toCharIndex(int n) {
        assert (n % 2 == 0) : "bad index: " + n;
        return n >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String string) throws IOException {
        if (this.getStorage() == null) {
            throw new IOException("Data has already been disposed");
        }
        File file = new File(string);
        CharBuffer charBuffer = this.getStorage().getReadBuffer(0, this.getStorage().size()).asCharBuffer();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            String string2 = System.getProperty("file.encoding");
            if (string2 == null) {
                string2 = "UTF-8";
            }
            Charset charset = Charset.forName(string2);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(byteBuffer);
            fileChannel.close();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public Matcher getForwardMatcher() {
        return this.matcher;
    }

    public Matcher getReverseMatcher() {
        try {
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (this.matcher != null && this.lastSearchString != null && this.lastSearchString.length() > 0 && storage.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.lastSearchString);
                stringBuffer.reverse();
                CharBuffer charBuffer = storage.getReadBuffer(0, storage.size()).asCharBuffer();
                StringBuffer stringBuffer2 = new StringBuffer(charBuffer.toString());
                stringBuffer2.reverse();
                Pattern pattern = AbstractLines.escapePattern(stringBuffer.toString());
                return pattern.matcher(stringBuffer2);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public Matcher find(String string) {
        Storage storage;
        if (Controller.LOG) {
            Controller.log(this + ": Executing find for string " + string + " on ");
        }
        if ((storage = this.getStorage()) == null) {
            return null;
        }
        if (this.matcher != null && string.equals(this.lastSearchString)) {
            return this.matcher;
        }
        try {
            int n = storage.size();
            if (n > 0) {
                CharBuffer charBuffer;
                Pattern pattern = AbstractLines.escapePattern(string);
                Matcher matcher = pattern.matcher(charBuffer = storage.getReadBuffer(0, n).asCharBuffer());
                if (!matcher.find(0)) {
                    return null;
                }
                this.matcher = matcher;
                this.matcher.reset();
                this.lastSearchString = string;
                return this.matcher;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    static Pattern escapePattern(String string) {
        String string2 = string.replaceAll("([\\(\\)\\[\\]\\^\\*\\.\\$\\{\\}\\?\\+\\\\])", "\\\\$1");
        return Pattern.compile(string2, 2);
    }

    public String toString() {
        return this.lineStartList.toString();
    }
}

