/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.DialogBinding;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.points.CallPointCD;
import org.netbeans.modules.vmd.midp.components.points.IfPointCD;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.components.points.SwitchPointCD;
import org.netbeans.modules.vmd.midp.components.sources.SwitchCaseEventSourceCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.CodeUtils;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PropertyEditorJavaString
extends DesignPropertyEditor {
    private static final String JAVA_CODE = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_JAVA_CODE_STR");
    private static final String METHOD_NAME = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_METHOD_NAME_STR");
    private static final String CONDITION_EXPRESSION = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_CONDITION_EXPRESSION_STR");
    private static final String SWITCH_OPERAND = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_SWITCH_OPERAND_STR");
    private static final String CASE_OPERAND = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_CASE_OPERAND_STR");
    private static final String JAVA_EXPRESSION = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_JAVA_EXPRESSION_STR");
    private static final String AMP = "&";
    private static final String COLON = ":";
    protected WeakReference<DesignComponent> component;
    private TypeID typeID;
    private final CustomEditor customEditor;
    private PropertyValue resetToDefaultValue;

    private PropertyEditorJavaString(TypeID typeID) {
        this.typeID = typeID;
        this.customEditor = new CustomEditor();
    }

    private PropertyEditorJavaString(TypeID typeID, PropertyValue propertyValue) {
        this(typeID);
        this.resetToDefaultValue = propertyValue;
    }

    public static final PropertyEditorJavaString createInstance(TypeID typeID) {
        return new PropertyEditorJavaString(typeID);
    }

    public static final PropertyEditorJavaString createInstance(TypeID typeID, PropertyValue propertyValue) {
        return new PropertyEditorJavaString(typeID, propertyValue);
    }

    public Component getCustomEditor() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue != null) {
            this.customEditor.setText(MidpTypes.getJavaCode(propertyValue));
        }
        this.customEditor.init();
        return this.customEditor;
    }

    public String getAsText() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue == null) {
            return PropertyEditorUserCode.NULL_TEXT;
        }
        return MidpTypes.getJavaCode(propertyValue);
    }

    public void setAsText(String string) {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue == null) {
            return;
        }
        Object object = propertyValue.getPrimitiveValue();
        if (object != null && object.equals(string)) {
            return;
        }
        this.saveValue(string);
    }

    public Object getDefaultValue() {
        return this.resetToDefaultValue;
    }

    private void saveValue(String string) {
        if (string != null) {
            super.setValue((Object)MidpTypes.createJavaCodeValue(string));
        }
    }

    public void customEditorOKButtonPressed() {
        String string = this.customEditor.getText();
        this.saveValue(string);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public String getCustomEditorTitle() {
        String string = this.getLabelName();
        string = string.replace(AMP, "");
        string = string.replace(COLON, "");
        return string;
    }

    public void init(DesignComponent designComponent) {
        if (designComponent != null) {
            this.component = new WeakReference<DesignComponent>(designComponent);
        }
    }

    private String getLabelName() {
        if (this.typeID.equals((Object)CallPointCD.TYPEID)) {
            return JAVA_CODE;
        }
        if (this.typeID.equals((Object)MethodPointCD.TYPEID)) {
            return METHOD_NAME;
        }
        if (this.typeID.equals((Object)IfPointCD.TYPEID)) {
            return CONDITION_EXPRESSION;
        }
        if (this.typeID.equals((Object)SwitchPointCD.TYPEID)) {
            return SWITCH_OPERAND;
        }
        if (this.typeID.equals((Object)SwitchCaseEventSourceCD.TYPEID)) {
            return CASE_OPERAND;
        }
        return JAVA_EXPRESSION;
    }

    private final class CustomEditor
    extends JPanel {
        private JEditorPane textPane;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PropertyEditorJavaString.this.getLabelName());
            gridBagConstraints.insets = new Insets(12, 12, 3, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            this.add((Component)jLabel, gridBagConstraints);
            this.textPane = new JEditorPane();
            jLabel.setLabelFor(this.textPane);
            this.textPane.getAccessibleContext().setAccessibleName(jLabel.getText());
            this.textPane.getAccessibleContext().setAccessibleDescription(jLabel.getText());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CustomEditor.this.textPane.setContentType("text/x-java");
                }
            });
            this.textPane.setPreferredSize(new Dimension(400, 100));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.textPane);
            gridBagConstraints.insets = new Insets(0, 12, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)jScrollPane, gridBagConstraints);
        }

        public void setText(String string) {
            this.textPane.setText(string);
        }

        public String getText() {
            return this.textPane.getText();
        }

        public void init() {
            if (PropertyEditorJavaString.this.component == null || PropertyEditorJavaString.this.component.get() == null) {
                return;
            }
            DesignComponent designComponent = (DesignComponent)PropertyEditorJavaString.this.component.get();
            Document document = this.textPane.getDocument();
            if (document.getProperty(JavaSource.class) == null) {
                DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designComponent.getDocument());
                document.putProperty("stream", dataObjectContext.getDataObject());
                int n = CodeUtils.getMethodOffset(dataObjectContext);
                DialogBinding.bindComponentToFile((FileObject)dataObjectContext.getDataObject().getPrimaryFile(), (int)n, (int)0, (JTextComponent)this.textPane);
            }
        }
    }
}

