/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.GaugeDisplayPresenterElement;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertDisplayPresenter
extends DisplayableDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    private static final Icon ICON_BROKEN = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png"));
    private JLabel imageLabel = new JLabel();
    private JLabel stringLabel;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;
    private GaugeDisplayPresenterElement gauge;
    private JPanel panel;
    private GridBagConstraints constraints;

    public AlertDisplayPresenter() {
        this.imageLabel.setHorizontalAlignment(0);
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
        JPanel jPanel = this.getPanel().getContentPanel();
        jPanel.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = -1;
        this.constraints.anchor = 10;
        jPanel.add((Component)this.imageLabel, this.constraints);
        this.constraints.anchor = 18;
        jPanel.add((Component)this.stringLabel, this.constraints);
    }

    @Override
    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        String string;
        super.reload(screenDeviceInfo);
        PropertyValue propertyValue = this.getComponent().readProperty("string");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            string = MidpTypes.getString(propertyValue);
            if (string == null) {
                this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_not_specified"));
            } else if (string.length() == 0) {
                this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_is_empty"));
            } else {
                this.stringLabel.setText(string);
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_text_is_usercode"));
        }
        propertyValue = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) {
            string = propertyValue.getComponent();
            String string2 = null;
            if (string != null) {
                string2 = (String)string.readProperty("resourcePath").getPrimitiveValue();
            }
            Icon icon = ScreenSupport.getIconFromImageComponent((DesignComponent)string);
            this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent((DesignComponent)string);
            if (this.imageFileObject != null) {
                this.imageLabel.setText(null);
                this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), (DesignComponent)string, "resourcePath");
                this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
            }
            if (icon != null) {
                this.imageLabel.setIcon(icon);
            } else if (string2 != null) {
                this.imageLabel.setIcon(ICON_BROKEN);
            } else {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_image_not_specified"));
            }
        } else {
            this.imageLabel.setText(NbBundle.getMessage(AlertDisplayPresenter.class, (String)"DISP_image_is_usercode"));
        }
        string = this.getComponent().readProperty("indicator").getComponent();
        if (string != null) {
            this.gauge = new GaugeDisplayPresenterElement();
            if (this.panel == null) {
                this.panel = new JPanel(){

                    public void paint(Graphics graphics) {
                        super.paint(graphics);
                        AlertDisplayPresenter.this.gauge.setPanel(this);
                        AlertDisplayPresenter.this.gauge.paintGauge(graphics);
                    }
                };
                this.panel.setOpaque(false);
                this.panel.setPreferredSize(new Dimension(200, 40));
                this.panel.repaint();
                this.panel.revalidate();
                this.constraints.anchor = 10;
                this.getPanel().getContentPanel().add((Component)this.panel, this.constraints);
            }
            this.gauge.setSize(this.panel.getSize());
            this.gauge.setInteractive(MidpTypes.getBoolean(string.readProperty("interactive")));
            int n = MidpTypes.getInteger(string.readProperty("maxValue"));
            if (n < 0) {
                n = 1;
            }
            this.gauge.setMaxValue(n);
            int n2 = MidpTypes.getInteger(string.readProperty("value"));
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n) {
                n2 = n;
            }
            this.gauge.setValue(n2);
            this.panel.repaint();
        } else if (this.panel != null) {
            this.getPanel().getContentPanel().remove(this.panel);
            this.panel = null;
            this.gauge = null;
        }
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor resourcePropertyEditor = new ResourcePropertyEditor("image", this.getComponent());
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageLabel, (ScreenPropertyEditor)resourcePropertyEditor));
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("string")));
        DesignComponent designComponent = this.getComponent().readProperty("indicator").getComponent();
        ResourcePropertyEditor resourcePropertyEditor2 = new ResourcePropertyEditor("value", designComponent);
        if (designComponent != null) {
            arrayList.add(new ScreenPropertyDescriptor(designComponent, (JComponent)this.panel, (ScreenPropertyEditor)resourcePropertyEditor2));
        }
        return arrayList;
    }

    protected void notifyDetached(DesignComponent designComponent) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }
}

