/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class DDUtils {
    public static String[] getUrlPatterns(WebApp webApp, Servlet servlet) {
        if (servlet.getServletName() == null) {
            return new String[0];
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            String string;
            if (!servlet.getServletName().equals(servletMappingArray[i].getServletName()) || (string = servletMappingArray[i].getUrlPattern()) == null) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getUrlPatterns(WebApp webApp, Filter filter) {
        if (filter.getFilterName() == null) {
            return new String[0];
        }
        FilterMapping[] filterMappingArray = webApp.getFilterMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            if (!filter.getFilterName().equals(filterMappingArray[i].getFilterName())) continue;
            String string = filterMappingArray[i].getUrlPattern();
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            String string2 = filterMappingArray[i].getServletName();
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getStringArray(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashSet<String[]> hashSet = new HashSet<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken().trim();
            if (stringArray.length() <= 0) continue;
            hashSet.add(stringArray);
        }
        stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    public static boolean isServletMapping(WebApp webApp, String string) {
        return webApp.findBeanByName("ServletMapping", "UrlPattern", string) != null;
    }

    public static boolean isServletMapping(WebApp webApp, Servlet servlet, String string) {
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        String string2 = servlet.getServletName();
        if (string2 != null) {
            for (int i = 0; i < servletMappingArray.length; ++i) {
                if (!string.equals(servletMappingArray[i].getUrlPattern()) || string2.equals(servletMappingArray[i].getServletName())) continue;
                return true;
            }
        }
        return false;
    }

    public static String urlPatternList(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void addServletMappings(WebApp webApp, Servlet servlet, String[] stringArray) {
        String string = servlet.getServletName();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(string);
                servletMapping.setUrlPattern(stringArray[i]);
                webApp.addServletMapping(servletMapping);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void setServletMappings(WebApp webApp, Servlet servlet, String[] stringArray) {
        int n;
        int n2;
        String string = servlet.getServletName();
        List list = DDUtils.getServletMappingList(webApp, servlet);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = 0;
            for (int i = 0; i < list.size(); ++i) {
                ServletMapping servletMapping = (ServletMapping)list.get(i);
                if (!stringArray[n2].equals(servletMapping.getUrlPattern())) continue;
                list.remove(servletMapping);
                n = 1;
                break;
            }
            if (n != 0) continue;
            arrayList.add(stringArray[n2]);
        }
        n2 = Math.min(list.size(), arrayList.size());
        for (n = 0; n < n2; ++n) {
            ServletMapping servletMapping = (ServletMapping)list.get(n);
            servletMapping.setUrlPattern((String)arrayList.get(n));
        }
        try {
            for (n = n2; n < arrayList.size(); ++n) {
                ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(string);
                servletMapping.setUrlPattern((String)arrayList.get(n));
                webApp.addServletMapping(servletMapping);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (int i = n2; i < list.size(); ++i) {
            webApp.removeServletMapping((ServletMapping)list.get(i));
        }
    }

    public static ServletMapping[] getServletMappings(WebApp webApp, Servlet servlet) {
        List list = DDUtils.getServletMappingList(webApp, servlet);
        ServletMapping[] servletMappingArray = new ServletMapping[list.size()];
        list.toArray(servletMappingArray);
        return servletMappingArray;
    }

    public static FilterMapping[] getFilterMappings(WebApp webApp, Filter filter) {
        List list = DDUtils.getFilterMappingList(webApp, filter);
        FilterMapping[] filterMappingArray = new FilterMapping[list.size()];
        list.toArray(filterMappingArray);
        return filterMappingArray;
    }

    public static FilterMapping[] getFilterMappings(WebApp webApp, Servlet servlet) {
        ArrayList<FilterMapping> arrayList = new ArrayList<FilterMapping>();
        if (servlet == null) {
            return new FilterMapping[0];
        }
        FilterMapping[] filterMappingArray = webApp.getFilterMapping();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            FilterMapping filterMapping = filterMappingArray[i];
            if (filterMapping.getServletName() == null || !filterMapping.getServletName().equals(servlet.getServletName())) continue;
            arrayList.add(filterMapping);
        }
        return arrayList.toArray(new FilterMapping[arrayList.size()]);
    }

    private static List getServletMappingList(WebApp webApp, Servlet servlet) {
        String string = servlet.getServletName();
        ArrayList<ServletMapping> arrayList = new ArrayList<ServletMapping>();
        if (string == null) {
            return arrayList;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            if (!servlet.getServletName().equals(servletMappingArray[i].getServletName())) continue;
            arrayList.add(servletMappingArray[i]);
        }
        return arrayList;
    }

    private static List getFilterMappingList(WebApp webApp, Filter filter) {
        String string = filter.getFilterName();
        ArrayList<FilterMapping> arrayList = new ArrayList<FilterMapping>();
        if (string == null) {
            return arrayList;
        }
        FilterMapping[] filterMappingArray = webApp.getFilterMapping();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            if (!filter.getFilterName().equals(filterMappingArray[i].getFilterName())) continue;
            arrayList.add(filterMappingArray[i]);
        }
        return arrayList;
    }

    public static void openEditorFor(DDDataObject dDDataObject, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            SourceGroup[] sourceGroupArray = DDUtils.getJavaSourceGroups(dDDataObject);
            String string2 = string.trim().replace('.', '/');
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                DataObject dataObject;
                OpenCookie openCookie;
                FileObject fileObject = sourceGroupArray[i].getRootFolder();
                FileObject fileObject2 = fileObject.getFileObject(string2 + ".java");
                if (fileObject2 == null || (openCookie = (OpenCookie)(dataObject = DataObject.find((FileObject)fileObject2)).getCookie(OpenCookie.class)) == null) continue;
                openCookie.open();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DDUtils.class, (String)"MSG_sourceNotFound")));
    }

    public static void openEditorForSingleFile(DDDataObject dDDataObject, String string) {
        FileObject fileObject;
        if (string == null || string.length() == 0) {
            return;
        }
        FileObject fileObject2 = null;
        try {
            fileObject2 = DDUtils.getDocumentBase(dDDataObject);
        }
        catch (IOException iOException) {
            return;
        }
        if (fileObject2 != null && (fileObject = fileObject2.getFileObject(string.trim())) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DDUtils.class, (String)"MSG_sourceNotFound")));
    }

    public static void openEditorForFiles(DDDataObject dDDataObject, StringTokenizer stringTokenizer) {
        FileObject fileObject = null;
        try {
            fileObject = DDUtils.getDocumentBase(dDDataObject);
        }
        catch (IOException iOException) {
            return;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        boolean bl = false;
        if (fileObject != null) {
            while (stringTokenizer.hasMoreTokens()) {
                FileObject fileObject2;
                String string = stringTokenizer.nextToken().trim();
                if (string.length() <= 0 || (fileObject2 = fileObject.getFileObject(string)) == null) continue;
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject2);
                    OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                    if (openCookie == null) continue;
                    openCookie.open();
                    bl = true;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        }
        if (!bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DDUtils.class, (String)"MSG_sourcesNotFound")));
        }
    }

    public static SourceGroup[] getJavaSourceGroups(DDDataObject dDDataObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)dDDataObject.getPrimaryFile());
        if (project == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("java");
    }

    public static SourceGroup[] getDocBaseGroups(DDDataObject dDDataObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)dDDataObject.getPrimaryFile());
        if (project == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("doc_root");
    }

    public static FileObject getDocumentBase(DDDataObject dDDataObject) throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)dDDataObject.getPrimaryFile());
        if (webModule == null) {
            return null;
        }
        return webModule.getDocumentBase();
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        return DDUtils.getResourcePath(sourceGroupArray, fileObject, '.', false);
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject, char c) {
        return DDUtils.getResourcePath(sourceGroupArray, fileObject, c, false);
    }

    public static String getResourcePath(SourceGroup[] sourceGroupArray, FileObject fileObject, char c, boolean bl) {
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject2 = sourceGroupArray[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (string != null) {
                int n;
                if (c != '/') {
                    string = string.replace('/', c);
                }
                if (!bl && (n = string.lastIndexOf(46)) > 0) {
                    string = string.substring(0, n);
                }
                return string;
            }
            return "";
        }
        return "";
    }

    public static void removeServletMappings(WebApp webApp, String string) {
        if (string == null) {
            return;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            if (!string.equals(servletMappingArray[i].getServletName())) continue;
            webApp.removeServletMapping(servletMappingArray[i]);
        }
    }

    public static Stack removeFilterMappings(WebApp webApp, String string) {
        Stack<Integer> stack = new Stack<Integer>();
        if (string == null) {
            return stack;
        }
        FilterMapping[] filterMappingArray = webApp.getFilterMapping();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            if (!string.equals(filterMappingArray[i].getFilterName())) continue;
            webApp.removeFilterMapping(filterMappingArray[i]);
            stack.push(new Integer(i));
        }
        return stack;
    }

    public static void removeFilterMappingsForServlet(WebApp webApp, String string) {
        Stack stack = new Stack();
        if (string == null) {
            return;
        }
        FilterMapping[] filterMappingArray = webApp.getFilterMapping();
        for (int i = 0; i < filterMappingArray.length; ++i) {
            if (!string.equals(filterMappingArray[i].getServletName())) continue;
            webApp.removeFilterMapping(filterMappingArray[i]);
        }
    }

    public static String addItem(String string, String string2, boolean bl) {
        String[] stringArray = DDUtils.getStringArray(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (string2.equals(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string2.equals(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            arrayList.add(string2);
        }
        return DDUtils.getAsString(arrayList);
    }

    private static String getAsString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)list.get(i));
        }
        return stringBuffer.toString();
    }

    public static String[] getServletNames(WebApp webApp) {
        Servlet[] servletArray = webApp.getServlet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < servletArray.length; ++i) {
            String string = servletArray[i].getServletName();
            if (string == null || arrayList.contains(servletArray[i])) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getFilterNames(WebApp webApp) {
        Filter[] filterArray = webApp.getFilter();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < filterArray.length; ++i) {
            String string = filterArray[i].getFilterName();
            if (string == null || arrayList.contains(filterArray[i])) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String checkServletMappig(String string) {
        if (!string.matches("[\\*/].*")) {
            return NbBundle.getMessage(DDUtils.class, (String)"MSG_WrongUriStart");
        }
        if (string.length() > 1 && string.endsWith("/")) {
            return NbBundle.getMessage(DDUtils.class, (String)"MSG_WrongUriEnd");
        }
        if (string.matches(".*\\*.*\\*.*")) {
            return NbBundle.getMessage(DDUtils.class, (String)"MSG_TwoAsterisks");
        }
        if (string.matches("..*\\*..*")) {
            return NbBundle.getMessage(DDUtils.class, (String)"MSG_AsteriskInTheMiddle");
        }
        return null;
    }
}

