/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.LoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SecurityMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SecurityView view;
    private DDDataObject dObj;
    private ToolBarDesignEditor editor;
    private SecurityFactory factory;
    private RequestProcessor.Task repaintingTask;
    private WebApp webApp;
    private AddConstraintAction addConstraintAction;
    private RemoveConstraintAction removeConstraintAction;
    private int index;
    private boolean needInit = true;
    private static final String SECURITY_MV_ID = "dd_multiviewSecurity";
    private static final String HELP_ID_PREFIX = "dd_multiview_security_";

    public SecurityMultiViewElement(DDDataObject dDDataObject, int n) {
        super((XmlMultiViewDataObject)dDDataObject);
        this.dObj = dDDataObject;
        this.index = n;
        this.editor = new ToolBarDesignEditor();
        this.factory = new SecurityFactory(this.editor, dDDataObject);
        this.addConstraintAction = new AddConstraintAction(dDDataObject);
        this.removeConstraintAction = new RemoveConstraintAction();
        this.setVisualEditor(this.editor);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SecurityMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!(this.dObj.isChangedFromUI() || (string = propertyChangeEvent.getPropertyName()).indexOf("LoginConfig") <= 0 && string.indexOf("Security") <= 0)) {
            MultiViewPerspective multiViewPerspective = this.dObj.getSelectedPerspective();
            if (multiViewPerspective != null && SECURITY_MV_ID.equals(multiViewPerspective.preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new SecurityView(this.webApp);
        this.editor.setContentView((PanelView)this.view);
        Object object = this.editor.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            SecurityView securityView = this.view;
            SecurityRolesNode securityRolesNode = this.view.getRolesNode();
            Children children = securityRolesNode.getChildren();
            if (children.getNodesCount() > 0) {
                securityRolesNode = children.getNodes()[0];
            }
            this.view.selectNode((Node)securityRolesNode);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    private class RemoveConstraintAction
    extends AbstractAction {
        RemoveConstraintAction() {
            super(NbBundle.getMessage(SecurityMultiViewElement.class, (String)"LBL_remove"));
            char c = NbBundle.getMessage(SecurityMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ConfirmDialog confirmDialog = new ConfirmDialog(NbBundle.getMessage(SecurityMultiViewElement.class, (String)"TXT_RemoveSecurityConstraintConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)confirmDialog);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(confirmDialog.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
                SecurityConstraint securityConstraint = (SecurityConstraint)sectionPanel.getKey();
                SecurityMultiViewElement.this.dObj.modelUpdatedFromUI();
                SecurityMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    SecurityMultiViewElement.this.webApp.removeSecurityConstraint(securityConstraint);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                finally {
                    SecurityMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddConstraintAction
    extends AbstractAction {
        AddConstraintAction(DDDataObject dDDataObject) {
            super(NbBundle.getMessage(SecurityMultiViewElement.class, (String)"LBL_AddSecurityConstraint"));
            char c = NbBundle.getMessage(SecurityMultiViewElement.class, (String)"LBL_AddSecurityConstraint_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SecurityMultiViewElement.this.dObj.modelUpdatedFromUI();
            SecurityMultiViewElement.this.dObj.setChangedFromUI(true);
            try {
                SecurityConstraint securityConstraint = (SecurityConstraint)SecurityMultiViewElement.this.webApp.createBean("SecurityConstraint");
                securityConstraint.setDisplayName(this.getUniqueDefaultName());
                SecurityMultiViewElement.this.webApp.addSecurityConstraint(securityConstraint);
                SecurityView securityView = (SecurityView)SecurityMultiViewElement.this.editor.getContentView();
                SecurityConstraintNode securityConstraintNode = new SecurityConstraintNode(securityConstraint);
                securityView.getConstraintsNode().getChildren().add(new Node[]{securityConstraintNode});
                SectionPanel sectionPanel = new SectionPanel((SectionView)securityView, (Node)securityConstraintNode, (Object)securityConstraint);
                sectionPanel.setHeaderActions(new Action[]{SecurityMultiViewElement.this.removeConstraintAction});
                securityView.getConstraintsContainer().addSection((NodeSectionPanel)sectionPanel, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private String getUniqueDefaultName() {
            String string;
            boolean bl;
            int n = 0;
            String string2 = NbBundle.getMessage(SecurityMultiViewElement.class, (String)"TXT_DefaultConstraintName");
            SecurityConstraint[] securityConstraintArray = SecurityMultiViewElement.this.webApp.getSecurityConstraint();
            do {
                string = string2 + ++n;
                bl = false;
                for (int i = 0; i < securityConstraintArray.length; ++i) {
                    if (!string.equals(securityConstraintArray[i].getDefaultDisplayName())) continue;
                    bl = true;
                }
            } while (bl);
            return string;
        }
    }

    private class LoginConfigNode
    extends AbstractNode {
        public LoginConfigNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(SecurityMultiViewElement.class, (String)"TTL_LoginConfig"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_loginconfigNode");
        }
    }

    private class SecurityConstraintNode
    extends AbstractNode {
        public SecurityConstraintNode(SecurityConstraint securityConstraint) {
            super(Children.LEAF);
            this.setDisplayName(securityConstraint.getDefaultDisplayName());
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_securityconstraintsNode");
        }
    }

    private class SecurityRolesNode
    extends AbstractNode {
        public SecurityRolesNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(SecurityMultiViewElement.class, (String)"TTL_SecurityRoles"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_security_securityrolesNode");
        }
    }

    private class SecurityView
    extends SectionView {
        private WebApp webApp;
        private SecurityRolesNode rolesNode;
        private SectionContainerNode constraintsNode;
        private SectionContainer constraintsContainer;
        private LoginConfigNode configNode;

        public SecurityView(WebApp webApp) {
            super((InnerPanelFactory)SecurityMultiViewElement.this.factory);
            this.webApp = webApp;
            LoginConfig loginConfig = webApp.getSingleLoginConfig();
            this.configNode = new LoginConfigNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)this.configNode, (Object)"login_config"));
            SecurityRole[] securityRoleArray = webApp.getSecurityRole();
            this.rolesNode = new SecurityRolesNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)this.rolesNode, (Object)"security_roles"));
            SecurityConstraint[] securityConstraintArray = webApp.getSecurityConstraint();
            Node[] nodeArray = new Node[securityConstraintArray.length];
            Children.Array array = new Children.Array();
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = new SecurityConstraintNode(securityConstraintArray[i]);
            }
            array.add(nodeArray);
            this.constraintsNode = new SectionContainerNode((Children)array);
            this.constraintsContainer = new SectionContainer((SectionView)this, (Node)this.constraintsNode, NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_SecurityConstraints"), false);
            this.constraintsContainer.setHeaderActions(new Action[]{SecurityMultiViewElement.this.addConstraintAction});
            SectionPanel[] sectionPanelArray = new SectionPanel[securityConstraintArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)securityConstraintArray[i]);
                sectionPanelArray[i].setHeaderActions(new Action[]{SecurityMultiViewElement.this.removeConstraintAction});
                this.constraintsContainer.addSection((NodeSectionPanel)sectionPanelArray[i]);
            }
            this.addSection((NodeSectionPanel)this.constraintsContainer);
            this.constraintsNode.setDisplayName(NbBundle.getMessage(ServletsMultiViewElement.class, (String)"TTL_SecurityConstraints"));
            array = new Children.Array();
            array.add(new Node[]{this.configNode, this.rolesNode, this.constraintsNode});
            AbstractNode abstractNode = new AbstractNode((Children)array);
            this.setRoot((Node)abstractNode);
        }

        public SecurityRolesNode getRolesNode() {
            return this.rolesNode;
        }

        public SectionContainerNode getConstraintsNode() {
            return this.constraintsNode;
        }

        public SectionContainer getConstraintsContainer() {
            return this.constraintsContainer;
        }
    }
}

