/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.UEIEmulatorConfiguratorImpl;
import org.netbeans.modules.mobility.cldcplatform.wizard.DetectWizardPanel;
import org.netbeans.modules.mobility.cldcplatform.wizard.SearchRunnable;
import org.netbeans.spi.mobility.cldcplatform.CLDCPlatformDescriptor;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DetectPanel
extends JPanel {
    static final String PROP_PLATFORMS = "Platforms";
    protected final DefaultListModel platformsListModel = new DefaultListModel();
    private final DefaultListModel javadocListModel = new DefaultListModel();
    private final DefaultListModel sourceListModel = new DefaultListModel();
    private final PlatformsRenderer platformsRenderer = new PlatformsRenderer();
    private final CheckListener checkListener = new CheckListener();
    private final DocumentListener nameFieldListener = new NameFieldListener();
    private final FoldersRenderer foldersRenderer = new FoldersRenderer();
    protected static final String DETECTION_IN_PROGRESS = NbBundle.getMessage(DetectPanel.class, (String)"msg_detection_in_progress");
    protected static final String INVALID_NAME = NbBundle.getMessage(DetectPanel.class, (String)"msg_invalid_name");
    protected static final String NAME_COLLISION = NbBundle.getMessage(DetectPanel.class, (String)"msg_name_collision");
    protected static final String ALREADY_INSTALLED = NbBundle.getMessage(DetectPanel.class, (String)"msg_already_installed");
    protected static final String DETECTION_FAILED = NbBundle.getMessage(DetectPanel.class, (String)"msg_detection_failed");
    protected static final Color COLOR_GRAY = UIManager.getColor("Label.disabledForeground");
    protected static final Color COLOR_RED = new Color(192, 0, 0);
    private String fileChooserValue;
    protected DetectWizardPanel wizardPanel;
    private WizardDescriptor wizardDescriptor;
    protected boolean stop;
    private final Map<File, PlatformDescriptor> descriptors = new HashMap<File, PlatformDescriptor>();
    private JButton addJavadocButton;
    private JButton addSourceButton;
    private JLabel errorPlatformLabel;
    private JPanel errorPlatformPanel;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JList javadocList;
    private JTextField nameField;
    private JLabel notDetectedLabel;
    private JPanel notDetectedPanel;
    private JPanel notSelectedPanel;
    private JList platformsList;
    private JButton removeJavadocButton;
    private JButton removeSourceButton;
    private JList sourceList;
    private JPanel switchPanel;

    public DetectPanel(DetectWizardPanel detectWizardPanel) {
        this.wizardPanel = detectWizardPanel;
        this.initComponents();
        this.platformsList.addMouseListener(this.checkListener);
        this.platformsList.addKeyListener(this.checkListener);
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DetectPanel.this.updateDetails();
            }
        });
        this.nameField.getDocument().addDocumentListener(this.nameFieldListener);
        this.infoPanel.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.infoPanel.setContentType("text/html;charset=UTF-8");
        this.javadocList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DetectPanel.this.removeJavadocButton.setEnabled(DetectPanel.this.javadocList.getSelectedValue() != null);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DetectPanel.this.removeSourceButton.setEnabled(DetectPanel.this.sourceList.getSelectedValue() != null);
            }
        });
    }

    public void showError(String string) {
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.platformsList = new JList();
        this.switchPanel = new JPanel();
        this.notSelectedPanel = new JPanel();
        this.notDetectedPanel = new JPanel();
        this.notDetectedLabel = new JLabel();
        this.errorPlatformPanel = new JPanel();
        this.errorPlatformLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.javadocList = new JList();
        this.addJavadocButton = new JButton();
        this.removeJavadocButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.sourceList = new JList();
        this.addSourceButton = new JButton();
        this.removeSourceButton = new JButton();
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platforms"));
        this.setPreferredSize(new Dimension(540, 450));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel5.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Select_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Select_Platform"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 150));
        this.platformsList.setModel(this.platformsListModel);
        this.platformsList.setSelectionMode(0);
        this.platformsList.setCellRenderer(this.platformsRenderer);
        this.jScrollPane1.setViewportView(this.platformsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.jPanel4);
        this.switchPanel.setLayout(new CardLayout());
        this.notSelectedPanel.setLayout(new BorderLayout());
        this.switchPanel.add((Component)this.notSelectedPanel, "NotSelected");
        this.notDetectedPanel.setLayout(new BorderLayout());
        this.notDetectedLabel.setForeground(this.notDetectedPanel.getBackground().darker());
        this.notDetectedLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.notDetectedLabel, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Detecting_details"));
        this.notDetectedLabel.setOpaque(true);
        this.notDetectedPanel.add((Component)this.notDetectedLabel, "Center");
        this.switchPanel.add((Component)this.notDetectedPanel, "NotDetected");
        this.errorPlatformPanel.setLayout(new BorderLayout());
        this.errorPlatformLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.errorPlatformLabel, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_detection_error"));
        this.errorPlatformLabel.setOpaque(true);
        this.errorPlatformPanel.add((Component)this.errorPlatformLabel, "Center");
        this.switchPanel.add((Component)this.errorPlatformPanel, "ErrorPlatform");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.jPanel3.add((Component)this.nameField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.infoPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Platform_Details"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 6);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_DetectPanel_Platform_Details"));
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane2.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Description"), this.jPanel3);
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel3"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel3"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.javadocList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Pl_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Pl_Javadoc"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Pl_Javadoc"));
        this.javadocList.setModel(this.javadocListModel);
        this.javadocList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane3.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addJavadocButton.setActionCommand(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.addJavadocButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.addJavadocButton, gridBagConstraints);
        this.addJavadocButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        this.addJavadocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeJavadocButton.setActionCommand(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeJavadocButton.setEnabled(false);
        this.removeJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.removeJavadocButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel1.add((Component)this.removeJavadocButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Javadoc"), this.jPanel1);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel1"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_PL_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_PL_Sources"));
        this.sourceList.setModel(this.sourceListModel);
        this.sourceList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane4.setViewportView(this.sourceList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.jPanel2.add((Component)this.jScrollPane4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Add"));
        this.addSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.addSourceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel2.add((Component)this.addSourceButton, gridBagConstraints);
        this.addSourceButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        this.addSourceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Remove"));
        this.removeSourceButton.setEnabled(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.removeSourceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this.removeSourceButton, gridBagConstraints);
        this.removeSourceButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Remove"));
        this.removeSourceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ASCD_DetectPanel_Remove"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"LBL_DetectPanel_Sources"), this.jPanel2);
        this.jPanel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel2"));
        this.jPanel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel2"));
        this.switchPanel.add((Component)this.jTabbedPane1, "Details");
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jTabbedPanel1"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jTabbedPanel1"));
        this.jSplitPane1.setBottomComponent(this.switchPanel);
        this.add((Component)this.jSplitPane1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DetectPanel.class, (String)"ACSN_jPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DetectPanel.class, (String)"ACSD_jPanel"));
    }

    private void addJavadocButtonActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform j2MEPlatform = this.findSelectedPlatform();
        if (j2MEPlatform == null) {
            return;
        }
        String string = this.browse(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_DetectPanel_SelectJavaDoc"));
        if (string == null) {
            return;
        }
        URL uRL = J2MEPlatform.localfilepath2url(string);
        if (uRL == null) {
            return;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(j2MEPlatform.getJavadocFolders());
        arrayList.add(uRL);
        j2MEPlatform.setJavadocFolders(arrayList);
        this.descriptorUpdated();
    }

    private void removeJavadocButtonActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform j2MEPlatform = this.findSelectedPlatform();
        if (j2MEPlatform == null) {
            return;
        }
        Object e = this.javadocList.getSelectedValue();
        if (e == null) {
            return;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(j2MEPlatform.getJavadocFolders());
        arrayList.remove(e);
        j2MEPlatform.setJavadocFolders(arrayList);
        this.descriptorUpdated();
    }

    private void addSourceButtonActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform j2MEPlatform = this.findSelectedPlatform();
        if (j2MEPlatform == null) {
            return;
        }
        String string = this.browse(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_DetectPanel_SelectSource"));
        if (string == null) {
            return;
        }
        FileObject fileObject = j2MEPlatform.resolveRelativePathToFileObject(string);
        if (fileObject == null) {
            return;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(j2MEPlatform.getSourceFolders().getRoots()));
        arrayList.add(fileObject);
        j2MEPlatform.setSourceFolders(arrayList);
        this.descriptorUpdated();
    }

    private void removeSourceButtonActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform j2MEPlatform = this.findSelectedPlatform();
        if (j2MEPlatform == null) {
            return;
        }
        Object e = this.sourceList.getSelectedValue();
        if (e == null) {
            return;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(j2MEPlatform.getSourceFolders().getRoots()));
        arrayList.remove(e);
        j2MEPlatform.setSourceFolders(arrayList);
        this.descriptorUpdated();
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File[] fileArray = ((Set)wizardDescriptor.getProperty("PlatformFolders")).toArray(new File[0]);
        this.platformsListModel.clear();
        for (int i = 0; i < fileArray.length; ++i) {
            PlatformDescriptor platformDescriptor = this.descriptors.get(fileArray[i]);
            if (platformDescriptor == null) {
                platformDescriptor = new PlatformDescriptor(fileArray[i]);
                this.descriptors.put(fileArray[i], platformDescriptor);
            }
            this.platformsListModel.addElement(platformDescriptor);
        }
        if (fileArray.length > 0) {
            this.platformsList.setSelectedIndex(0);
        }
        this.showError(NbBundle.getMessage(DetectPanel.class, (String)"WARN_SearchInProgress"));
        this.stop = false;
        RequestProcessor.getDefault().post((Runnable)new DetectRunnable());
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        this.stop = true;
        wizardDescriptor.putProperty(PROP_PLATFORMS, (Object)this.getPlatforms());
    }

    public J2MEPlatform[] getPlatforms() {
        Object[] objectArray = this.platformsListModel.toArray();
        ArrayList<J2MEPlatform> arrayList = new ArrayList<J2MEPlatform>();
        for (int i = 0; i < objectArray.length; ++i) {
            J2MEPlatform j2MEPlatform;
            PlatformDescriptor platformDescriptor = (PlatformDescriptor)objectArray[i];
            if (!platformDescriptor.isProbed() || !platformDescriptor.isSelected() || (j2MEPlatform = platformDescriptor.getPlatform()) == null) continue;
            arrayList.add(j2MEPlatform);
        }
        return arrayList.toArray(new J2MEPlatform[arrayList.size()]);
    }

    public boolean isValid() {
        Object[] objectArray = this.platformsListModel.toArray();
        if (this.checkForError(this.findSelectedPlatformDescriptor())) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.checkForError((PlatformDescriptor)objectArray[i])) {
                return false;
            }
            bl |= ((PlatformDescriptor)objectArray[i]).isSelected();
        }
        if (!bl) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_NothingSelected"));
            return false;
        }
        this.showError(null);
        return true;
    }

    private boolean checkForError(PlatformDescriptor platformDescriptor) {
        if (platformDescriptor == null) {
            return false;
        }
        if (!platformDescriptor.isNameValid()) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_InvalidName"));
        } else if (platformDescriptor.isNameCollision()) {
            this.showError(NbBundle.getMessage(DetectPanel.class, (String)"ERR_NameCollision"));
        } else {
            return false;
        }
        return true;
    }

    protected void descriptorUpdated() {
        this.platformsList.repaint();
        this.updateDetails();
        this.wizardPanel.fireChanged();
    }

    protected void updateDetails() {
        PlatformDescriptor platformDescriptor = this.findSelectedPlatformDescriptor();
        if (platformDescriptor == null) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "NotSelected");
            return;
        }
        if (!platformDescriptor.isProbed()) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "NotDetected");
            return;
        }
        J2MEPlatform j2MEPlatform = platformDescriptor.getPlatform();
        if (j2MEPlatform == null) {
            ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "ErrorPlatform");
            return;
        }
        this.nameField.getDocument().removeDocumentListener(this.nameFieldListener);
        this.nameField.setText(j2MEPlatform.getDisplayName());
        this.nameField.getDocument().addDocumentListener(this.nameFieldListener);
        this.infoPanel.setText(this.generateDescriptionForPlatform(j2MEPlatform));
        ((CardLayout)this.switchPanel.getLayout()).show(this.switchPanel, "Details");
        this.infoPanel.setCaretPosition(0);
        FileObject[] fileObjectArray = j2MEPlatform.getSourceFolders().getRoots();
        this.sourceListModel.clear();
        if (fileObjectArray != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                this.sourceListModel.addElement(fileObjectArray[i]);
            }
        }
        List<URL> list = j2MEPlatform.getJavadocFolders();
        this.javadocListModel.clear();
        if (list != null) {
            for (URL uRL : list) {
                this.javadocListModel.addElement(uRL);
            }
        }
        this.wizardPanel.fireChanged();
    }

    protected PlatformDescriptor findSelectedPlatformDescriptor() {
        return (PlatformDescriptor)this.platformsList.getSelectedValue();
    }

    private J2MEPlatform findSelectedPlatform() {
        PlatformDescriptor platformDescriptor = this.findSelectedPlatformDescriptor();
        return platformDescriptor != null ? platformDescriptor.getPlatform() : null;
    }

    private String generateDescriptionForPlatform(J2MEPlatform j2MEPlatform) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<html><font face=\"dialog\" size=\"-1\">");
        stringBuffer.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Devices"));
        J2MEPlatform.Device[] deviceArray = j2MEPlatform.getDevices();
        if (deviceArray != null) {
            for (int i = 0; i < deviceArray.length; ++i) {
                object = deviceArray[i];
                stringBuffer.append(i > 0 ? ", " : " ");
                stringBuffer.append(((J2MEPlatform.Device)object).getName());
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        object = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (deviceArray != null) {
            for (int i = 0; i < deviceArray.length; ++i) {
                J2MEPlatform.J2MEProfile[] j2MEProfileArray = deviceArray[i].getProfiles();
                if (j2MEProfileArray == null) continue;
                for (int j = 0; j < j2MEProfileArray.length; ++j) {
                    String string = j2MEProfileArray[j].toString();
                    String string2 = j2MEProfileArray[j].getType();
                    if ("profile".equals(string2)) {
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                        continue;
                    }
                    if ("configuration".equals(string2)) {
                        if (((ArrayList)object).contains(string)) continue;
                        ((ArrayList)object).add(string);
                        continue;
                    }
                    if (!"optional".equals(string2) || arrayList2.contains(string)) continue;
                    arrayList2.add(string);
                }
            }
        }
        stringBuffer.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Profiles"));
        this.printToStringBuffer(arrayList.toArray(), stringBuffer);
        stringBuffer.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Configurations"));
        this.printToStringBuffer(((ArrayList)object).toArray(), stringBuffer);
        stringBuffer.append(NbBundle.getMessage(DetectPanel.class, (String)"MSG_DetectPanel_Optional"));
        this.printToStringBuffer(arrayList2.toArray(), stringBuffer);
        return stringBuffer.toString();
    }

    private void printToStringBuffer(Object[] objectArray, StringBuffer stringBuffer) {
        Arrays.sort(objectArray);
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(i > 0 ? ", " : " ").append(objectArray[i]);
            }
        } else {
            stringBuffer.append(NbBundle.getMessage(DetectPanel.class, (String)"Msg_DetectPanel_None"));
        }
    }

    private String browse(String string) {
        String string2 = this.fileChooserValue;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists() && file.canRead() && (file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar"));
            }

            public String getDescription() {
                return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
            }
        });
        if (string2 != null) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        jFileChooser.setDialogTitle(string);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.fileChooserValue = jFileChooser.getSelectedFile().getAbsolutePath();
            return this.fileChooserValue;
        }
        return null;
    }

    class DetectRunnable
    extends JPanel
    implements Runnable {
        private final JLabel searchLabel;
        protected final ProgressHandle progress;

        public DetectRunnable() {
            this.setLayout(new GridBagLayout());
            this.searchLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 6, 12), 0, 0);
            this.add((Component)this.searchLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 6, 12), 0, 0);
            this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SearchRunnable.class, (String)"Title_DetectRunnable_Searching"));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_detectingPlatform"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_detectingPlatform"));
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress);
            jComponent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchRunnable.class, (String)"ACSN_detectingPlatform"));
            jComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchRunnable.class, (String)"ACSD_detectingPlatform"));
            this.add((Component)jComponent, gridBagConstraints);
            this.setPreferredSize(new Dimension(400, 70));
        }

        public void run() {
            this.progress.start(DetectPanel.this.platformsListModel.size());
            final Dialog[] dialogArray = new Dialog[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        dialogArray[0] = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)DetectRunnable.this, NbBundle.getMessage(SearchRunnable.class, (String)"Title_DetectRunnable_Searching"), true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(DetectPanel.class), new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                DetectPanel.this.stop = true;
                            }
                        }));
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!DetectPanel.this.stop) {
                            dialogArray[0].setVisible(true);
                        }
                    }
                });
                for (int i = 0; !DetectPanel.this.stop && i < DetectPanel.this.platformsListModel.size(); ++i) {
                    this.progress.progress(i);
                    PlatformDescriptor platformDescriptor = (PlatformDescriptor)DetectPanel.this.platformsListModel.getElementAt(i);
                    if (platformDescriptor.isProbed()) continue;
                    this.setCurrentPath(platformDescriptor.getRoot());
                    platformDescriptor.detect();
                    DetectPanel.this.wizardPanel.fireChanged();
                }
                this.progress.progress(DetectPanel.this.platformsListModel.size());
                if (DetectPanel.this.stop) {
                    DetectPanel.this.showError(null);
                }
                DetectPanel.this.stop = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DetectRunnable.this.progress.finish();
                        dialogArray[0].setVisible(false);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }

        public void setCurrentPath(String string) {
            this.searchLabel.setText(NbBundle.getMessage(SearchRunnable.class, (String)"LBL_DetectingPath", (Object)string));
        }
    }

    private class FoldersRenderer
    extends JLabel
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public FoldersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? DetectPanel.this.platformsList.getSelectionBackground() : DetectPanel.this.platformsList.getBackground());
            this.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
            Border border = null;
            if (bl2) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            String string = object instanceof FileObject ? J2MEPlatform.getFilePath((FileObject)object) : (object instanceof URL ? J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)object))) : null);
            if (string == null) {
                string = object != null ? object.toString() : "";
            }
            this.setText(string);
            return this;
        }
    }

    private class NameFieldListener
    implements DocumentListener {
        NameFieldListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            PlatformDescriptor platformDescriptor = DetectPanel.this.findSelectedPlatformDescriptor();
            J2MEPlatform j2MEPlatform = platformDescriptor.getPlatform();
            if (j2MEPlatform == null) {
                return;
            }
            String string = DetectPanel.this.nameField.getText();
            j2MEPlatform.setDisplayName(string);
            j2MEPlatform.setName(J2MEPlatform.computeUniqueName(string));
            DetectPanel.this.platformsList.repaint();
            DetectPanel.this.wizardPanel.fireChanged();
        }
    }

    private class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 20) {
                this.check();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                this.check();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void check() {
            PlatformDescriptor platformDescriptor = DetectPanel.this.findSelectedPlatformDescriptor();
            if (platformDescriptor != null) {
                platformDescriptor.invertSelection();
            }
        }
    }

    private class PlatformsRenderer
    extends JCheckBox
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? DetectPanel.this.platformsList.getSelectionBackground() : DetectPanel.this.platformsList.getBackground());
            Border border = null;
            if (bl2) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            PlatformDescriptor platformDescriptor = (PlatformDescriptor)object;
            platformDescriptor.updateRenderer(this, bl);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlatformDescriptor {
        private final String root;
        private boolean probed;
        private J2MEPlatform platform;
        private boolean selected;

        public PlatformDescriptor(File file) {
            this.root = file.getAbsolutePath();
        }

        public String getRoot() {
            return this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detect() {
            PlatformDescriptor platformDescriptor = this;
            synchronized (platformDescriptor) {
                this.platform = null;
                Iterator iterator = Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances().iterator();
                File file = new File(this.root);
                while (iterator.hasNext() && this.platform == null) {
                    this.platform = this.createPlatformFromDescriptor(((CustomCLDCPlatformConfigurator)iterator.next()).getPlatform(file));
                }
                if (this.platform == null) {
                    this.platform = new UEIEmulatorConfiguratorImpl(this.root).getPlatform();
                }
                this.selected = this.platform != null && !this.isAlreadyInstalled();
                this.probed = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DetectPanel.this.descriptorUpdated();
                }
            });
        }

        private J2MEPlatform createPlatformFromDescriptor(CLDCPlatformDescriptor cLDCPlatformDescriptor) {
            if (cLDCPlatformDescriptor == null) {
                return null;
            }
            return new J2MEPlatform(J2MEPlatform.computeUniqueName(cLDCPlatformDescriptor.displayName), cLDCPlatformDescriptor.home, cLDCPlatformDescriptor.type, cLDCPlatformDescriptor.displayName, cLDCPlatformDescriptor.srcPath, cLDCPlatformDescriptor.docPath, cLDCPlatformDescriptor.preverifyCmd, cLDCPlatformDescriptor.runCmd, cLDCPlatformDescriptor.debugCmd, this.createDevices(cLDCPlatformDescriptor.devices));
        }

        private J2MEPlatform.Device[] createDevices(List<CLDCPlatformDescriptor.Device> list) {
            J2MEPlatform.Device[] deviceArray = new J2MEPlatform.Device[list.size()];
            for (int i = 0; i < deviceArray.length; ++i) {
                CLDCPlatformDescriptor.Device device = list.get(i);
                deviceArray[i] = new J2MEPlatform.Device(device.name, device.description, device.securityDomains == null ? null : device.securityDomains.toArray(new String[device.securityDomains.size()]), this.createProfiles(device.profiles), this.createScreen(device.screen));
            }
            return deviceArray;
        }

        private J2MEPlatform.J2MEProfile[] createProfiles(List<CLDCPlatformDescriptor.Profile> list) {
            J2MEPlatform.J2MEProfile[] j2MEProfileArray = new J2MEPlatform.J2MEProfile[list.size()];
            for (int i = 0; i < j2MEProfileArray.length; ++i) {
                CLDCPlatformDescriptor.Profile profile = list.get(i);
                j2MEProfileArray[i] = new J2MEPlatform.J2MEProfile(profile.name, profile.version, profile.displayName, this.getProfileType(profile.type), profile.dependencies, profile.classPath, profile.def);
            }
            return j2MEProfileArray;
        }

        private String getProfileType(CLDCPlatformDescriptor.ProfileType profileType) {
            if (profileType == CLDCPlatformDescriptor.ProfileType.Configuration) {
                return "configuration";
            }
            if (profileType == CLDCPlatformDescriptor.ProfileType.Profile) {
                return "profile";
            }
            return "optional";
        }

        private J2MEPlatform.Screen createScreen(CLDCPlatformDescriptor.Screen screen) {
            return new J2MEPlatform.Screen(String.valueOf(screen.width), String.valueOf(screen.height), String.valueOf(screen.bitDepth), String.valueOf(screen.color), String.valueOf(screen.touch));
        }

        public boolean isAlreadyInstalled() {
            return this.platform == null ? false : JavaPlatformManager.getDefault().getPlatforms(this.platform.getDisplayName(), null).length > 0;
        }

        public boolean isNameCollision() {
            if (this.platform == null || !this.selected) {
                return false;
            }
            if (this.isAlreadyInstalled()) {
                return true;
            }
            Object[] objectArray = DetectPanel.this.platformsListModel.toArray();
            String string = this.getPlatform().getDisplayName();
            for (int i = 0; i < objectArray.length; ++i) {
                PlatformDescriptor platformDescriptor = (PlatformDescriptor)objectArray[i];
                if (platformDescriptor == this || !platformDescriptor.isSelected() || platformDescriptor.getPlatform() == null || !platformDescriptor.getPlatform().getDisplayName().equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isProbed() {
            return this.probed;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public J2MEPlatform getPlatform() {
            return this.platform;
        }

        public boolean isNameValid() {
            return this.platform == null ? true : !this.selected || this.platform.getDisplayName().trim().length() > 0;
        }

        public void updateRenderer(JCheckBox jCheckBox, boolean bl) {
            jCheckBox.setSelected(this.selected);
            if (!this.probed) {
                jCheckBox.setText(this.root + DETECTION_IN_PROGRESS);
                jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_GRAY);
            } else if (this.platform != null) {
                if (!this.isNameValid()) {
                    jCheckBox.setText(this.root + INVALID_NAME);
                    jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
                } else if (this.isNameCollision()) {
                    jCheckBox.setText(this.root + NAME_COLLISION);
                    jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
                } else if (this.isAlreadyInstalled()) {
                    jCheckBox.setText(this.root + ALREADY_INSTALLED);
                    jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
                } else {
                    jCheckBox.setText(this.root);
                    jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : DetectPanel.this.platformsList.getForeground());
                }
            } else {
                jCheckBox.setText(this.root + DETECTION_FAILED);
                jCheckBox.setForeground(bl ? DetectPanel.this.platformsList.getSelectionForeground() : COLOR_RED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invertSelection() {
            PlatformDescriptor platformDescriptor = this;
            synchronized (platformDescriptor) {
                if (this.selected) {
                    this.selected = false;
                    DetectPanel.this.descriptorUpdated();
                } else if (this.probed && this.platform != null) {
                    this.selected = true;
                    DetectPanel.this.descriptorUpdated();
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof PlatformDescriptor && ((PlatformDescriptor)object).root.equals(this.root);
        }
    }
}

