/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntNodeProp
extends PropertySupport.ReadWrite<Integer> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private int state;

    public IntNodeProp(CodeStyle.Language language, PreviewPreferences previewPreferences, String string) {
        super(string, Integer.class, IntNodeProp.getString("LBL_" + string), IntNodeProp.getString("HINT_" + string));
        this.language = language;
        this.optionID = string;
        this.preferences = previewPreferences;
        this.init();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(IntNodeProp.class, (String)string);
    }

    private void init() {
        this.state = this.getPreferences().getInt(this.optionID, this.getDefault());
    }

    private int getDefault() {
        return (Integer)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID);
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public Integer getValue() {
        return new Integer(this.state);
    }

    public void setValue(Integer n) {
        this.state = n;
        this.getPreferences().putInt(this.optionID, this.state);
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault() == this.getValue().intValue();
    }
}

