/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.Stack;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.StackEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BracesStack {
    private static final boolean TRACE_STACK = false;
    private static final boolean TRACE_STATEMENT = false;
    private Stack<StackEntry> stack = new Stack();
    private CodeStyle codeStyle;
    private StatementContinuation statementContinuation = StatementContinuation.STOP;
    int lastStatementStart = -1;
    int parenDepth = 0;
    int lastKRstart = -1;
    boolean isDoWhile = false;
    boolean isLabel = false;
    int lastStatementParen = -1;

    BracesStack(CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public BracesStack clone() {
        BracesStack bracesStack = new BracesStack(this.codeStyle);
        bracesStack.statementContinuation = this.statementContinuation;
        bracesStack.lastStatementStart = this.lastStatementStart;
        bracesStack.lastKRstart = this.lastKRstart;
        bracesStack.parenDepth = this.parenDepth;
        bracesStack.isDoWhile = this.isDoWhile;
        bracesStack.lastStatementParen = this.lastStatementParen;
        bracesStack.isLabel = this.isLabel;
        for (int i = 0; i < this.stack.size(); ++i) {
            bracesStack.stack.add((StackEntry)this.stack.get(i));
        }
        return bracesStack;
    }

    public void reset(BracesStack bracesStack) {
        this.statementContinuation = bracesStack.statementContinuation;
        this.lastStatementStart = bracesStack.lastStatementStart;
        this.lastKRstart = bracesStack.lastKRstart;
        this.parenDepth = bracesStack.parenDepth;
        this.isDoWhile = bracesStack.isDoWhile;
        this.lastStatementParen = bracesStack.lastStatementParen;
        this.isLabel = bracesStack.isLabel;
        this.stack.clear();
        for (int i = 0; i < bracesStack.stack.size(); ++i) {
            this.stack.add((StackEntry)bracesStack.stack.get(i));
        }
    }

    public void push(ExtendedTokenSequence extendedTokenSequence) {
        StackEntry stackEntry = this.peek();
        int n = 0;
        int n2 = 0;
        int n3 = this.codeStyle.indentSize();
        if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            n3 = this.codeStyle.indentSize() / 2;
        }
        int n4 = this.codeStyle.indentSize();
        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            n4 = this.codeStyle.indentSize() / 2;
        }
        if (stackEntry != null) {
            n = stackEntry.getIndent();
            n2 = stackEntry.getSelfIndent();
        }
        StackEntry stackEntry2 = new StackEntry(extendedTokenSequence);
        switch (stackEntry2.getKind()) {
            case ELSE: {
                if (stackEntry != null && (stackEntry.getKind() == CppTokenId.IF || stackEntry.getKind() == CppTokenId.ELSE)) {
                    stackEntry2.setIndent(n);
                    stackEntry2.setSelfIndent(n2);
                    break;
                }
                stackEntry2.setIndent(n + n3);
                stackEntry2.setSelfIndent(n);
                break;
            }
            case IF: {
                if (stackEntry != null && stackEntry.getKind() == CppTokenId.ELSE) {
                    stackEntry2.setIndent(n);
                    stackEntry2.setSelfIndent(n2);
                    break;
                }
                stackEntry2.setIndent(n + n3);
                stackEntry2.setSelfIndent(n);
                break;
            }
            case WHILE: {
                if (this.isDoWhile) {
                    stackEntry2.setIndent(n);
                    stackEntry2.setSelfIndent(n2);
                    break;
                }
                stackEntry2.setIndent(n + n3);
                stackEntry2.setSelfIndent(n);
                break;
            }
            case TRY: 
            case CATCH: 
            case FOR: 
            case DO: 
            case ASM: {
                stackEntry2.setIndent(n + n3);
                stackEntry2.setSelfIndent(n);
                break;
            }
            case SWITCH: {
                stackEntry2.setIndent(n + n4);
                stackEntry2.setSelfIndent(n);
                break;
            }
            case LBRACE: {
                CppTokenId cppTokenId = stackEntry2.getImportantKind();
                if (cppTokenId != null) {
                    switch (cppTokenId) {
                        case SWITCH: {
                            if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                if (this.codeStyle.indentCasesFromSwitch()) {
                                    stackEntry2.setIndent(n + this.codeStyle.indentSize());
                                    stackEntry2.setSelfIndent(n);
                                    break;
                                }
                                stackEntry2.setIndent(n + n4);
                                stackEntry2.setSelfIndent(n);
                                break;
                            }
                            if (this.codeStyle.indentCasesFromSwitch()) {
                                stackEntry2.setIndent(n + n4);
                                stackEntry2.setSelfIndent(n2);
                                break;
                            }
                            stackEntry2.setIndent(n);
                            stackEntry2.setSelfIndent(n2);
                            break;
                        }
                        case ELSE: 
                        case IF: 
                        case TRY: 
                        case CATCH: 
                        case WHILE: 
                        case FOR: 
                        case DO: 
                        case ASM: {
                            if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                stackEntry2.setIndent(n + n3);
                                stackEntry2.setSelfIndent(n);
                                break;
                            }
                            stackEntry2.setIndent(n);
                            stackEntry2.setSelfIndent(n2);
                            break;
                        }
                        case NAMESPACE: {
                            if (this.codeStyle.indentNamespace()) {
                                n3 = this.codeStyle.indentSize();
                                if (this.codeStyle.getFormatNewlineBeforeBraceNamespace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                    n3 /= 2;
                                }
                                stackEntry2.setIndent(n + n3);
                                stackEntry2.setSelfIndent(n);
                                break;
                            }
                            stackEntry2.setIndent(n);
                            stackEntry2.setSelfIndent(n);
                            break;
                        }
                        case CLASS: 
                        case STRUCT: 
                        case ENUM: 
                        case UNION: {
                            n3 = this.codeStyle.indentSize();
                            if (this.codeStyle.getFormatNewlineBeforeBraceClass() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                                n3 /= 2;
                            }
                            stackEntry2.setIndent(n + n3);
                            stackEntry2.setSelfIndent(n);
                        }
                    }
                    break;
                }
                if (stackEntry2.isLikeToFunction()) {
                    n3 = this.codeStyle.indentSize();
                    if (this.codeStyle.getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                        n3 /= 2;
                    }
                    stackEntry2.setIndent(n + n3);
                    stackEntry2.setSelfIndent(n);
                    break;
                }
                if (stackEntry2.isLikeToArrayInitialization()) {
                    stackEntry2.setIndent(n + n3);
                    stackEntry2.setSelfIndent(n);
                    break;
                }
                if (stackEntry != null && stackEntry.getImportantKind() == CppTokenId.SWITCH) {
                    if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                        stackEntry2.setIndent(n + n4);
                        stackEntry2.setSelfIndent(n);
                        break;
                    }
                    if (this.codeStyle.indentCasesFromSwitch()) {
                        stackEntry2.setIndent(n2 + this.codeStyle.indentSize() + n4);
                        stackEntry2.setSelfIndent(n2 + n4);
                        break;
                    }
                    stackEntry2.setIndent(n2 + n4);
                    stackEntry2.setSelfIndent(n2);
                    break;
                }
                stackEntry2.setIndent(n + n3);
                stackEntry2.setSelfIndent(n);
            }
        }
        this.push(stackEntry2);
    }

    public int getIndent() {
        StackEntry stackEntry = this.peek();
        if (stackEntry != null) {
            return stackEntry.getIndent();
        }
        return 0;
    }

    public int getSelfIndent() {
        StackEntry stackEntry = this.peek();
        if (stackEntry != null) {
            return stackEntry.getSelfIndent();
        }
        return 0;
    }

    private void push(StackEntry stackEntry) {
        this.statementContinuation = StatementContinuation.STOP;
        if (stackEntry.getKind() == CppTokenId.ELSE && this.stack.size() > 0 && (this.stack.peek().getKind() == CppTokenId.IF || this.stack.peek().getKind() == CppTokenId.ELSE)) {
            this.stack.pop();
        }
        if (stackEntry.getImportantKind() == null && !stackEntry.isLikeToArrayInitialization() && this.peek() != null && this.peek().isLikeToArrayInitialization()) {
            stackEntry.setLikeToArrayInitialization(true);
            if (this.parenDepth > 0) {
                stackEntry.setLikeToArrayInitialization(true);
            }
        }
        if (stackEntry.getKind() == CppTokenId.LBRACE) {
            if (stackEntry.isLikeToArrayInitialization()) {
                if (this.parenDepth > 0) {
                    stackEntry.setLikeToArrayInitialization(true);
                }
            } else {
                this.clearLastStatementStart();
            }
        } else if (this.lastStatementStart != stackEntry.getIndex()) {
            this.lastStatementStart = stackEntry.getIndex();
        }
        this.stack.push(stackEntry);
    }

    public void pop(ExtendedTokenSequence extendedTokenSequence) {
        if (this.parenDepth <= 0) {
            this.clearLastStatementStart();
        }
        this.statementContinuation = StatementContinuation.STOP;
        this.popImpl(extendedTokenSequence);
    }

    public void popImpl(ExtendedTokenSequence extendedTokenSequence) {
        if (this.stack.empty()) {
            return;
        }
        CppTokenId cppTokenId = (CppTokenId)extendedTokenSequence.token().id();
        if (cppTokenId == CppTokenId.RBRACE) {
            this.popBrace(extendedTokenSequence);
        } else {
            this.popStatement(extendedTokenSequence);
        }
    }

    public void popBrace(ExtendedTokenSequence extendedTokenSequence) {
        int n = 0;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            StackEntry stackEntry = (StackEntry)this.stack.get(i);
            if (stackEntry.getKind() != CppTokenId.LBRACE) continue;
            n = i - 1;
            this.stack.setSize(i);
            break;
        }
        if (n < 0) {
            this.stack.setSize(0);
            return;
        }
        this.popStatement(extendedTokenSequence);
    }

    public void popStatement(ExtendedTokenSequence extendedTokenSequence) {
        Token<CppTokenId> token = this.getNextImportant(extendedTokenSequence);
        block6: for (int i = this.stack.size() - 1; i >= 0; --i) {
            StackEntry stackEntry = (StackEntry)this.stack.get(i);
            switch (stackEntry.getKind()) {
                case LBRACE: {
                    this.stack.setSize(i + 1);
                    return;
                }
                case IF: {
                    if (token == null || token.id() != CppTokenId.ELSE) continue block6;
                    if (i > 0 && ((StackEntry)this.stack.get(i - 1)).getKind() == CppTokenId.ELSE) {
                        this.stack.setSize(i);
                        return;
                    }
                    this.stack.setSize(i + 1);
                    return;
                }
                case DO: {
                    if (token == null || token.id() != CppTokenId.WHILE) continue block6;
                    if (i > 0 && ((StackEntry)this.stack.get(i - 1)).getKind() == CppTokenId.WHILE) {
                        this.stack.setSize(i);
                        return;
                    }
                    this.stack.setSize(i + 1);
                    return;
                }
                case TRY: 
                case CATCH: {
                    if (token == null || token.id() != CppTokenId.CATCH || i <= 0) continue block6;
                    this.stack.setSize(i);
                    return;
                }
            }
        }
        this.stack.setSize(0);
    }

    private boolean isStatement(StackEntry stackEntry) {
        if (stackEntry != null) {
            switch (stackEntry.getKind()) {
                case SWITCH: 
                case ELSE: 
                case IF: 
                case TRY: 
                case CATCH: 
                case WHILE: 
                case FOR: 
                case DO: 
                case ASM: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDeclarationLevel() {
        StackEntry stackEntry = this.peek();
        if (stackEntry == null) {
            return true;
        }
        if (stackEntry.getKind() == CppTokenId.CATCH) {
            return true;
        }
        if (this.isStatement(stackEntry)) {
            return false;
        }
        CppTokenId cppTokenId = stackEntry.getImportantKind();
        if (cppTokenId == null) {
            return false;
        }
        return cppTokenId == CppTokenId.NAMESPACE || cppTokenId == CppTokenId.CLASS;
    }

    public StackEntry peek() {
        if (this.stack.empty()) {
            return null;
        }
        return this.stack.peek();
    }

    public int getLength() {
        return this.stack.size();
    }

    public int switchDepth() {
        int n = 0;
        StackEntry stackEntry = null;
        for (int i = 0; i < this.stack.size(); ++i) {
            StackEntry stackEntry2 = (StackEntry)this.stack.get(i);
            if (stackEntry2.getKind() == CppTokenId.LBRACE && stackEntry != null && stackEntry.getKind() == CppTokenId.SWITCH) {
                ++n;
            }
            stackEntry = stackEntry2;
        }
        return n;
    }

    public StackEntry lookPerevious() {
        if (this.stack.size() < 2) {
            return null;
        }
        return (StackEntry)this.stack.get(this.stack.size() - 2);
    }

    private Token<CppTokenId> getNextImportant(ExtendedTokenSequence extendedTokenSequence) {
        int n = extendedTokenSequence.index();
        try {
            while (true) {
                Token<CppTokenId> token;
                if (!extendedTokenSequence.moveNext()) {
                    token = null;
                    return token;
                }
                token = extendedTokenSequence.token();
                switch ((CppTokenId)token.id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case LINE_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: {
                        break;
                    }
                    case SWITCH: 
                    case ELSE: 
                    case IF: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case ASM: {
                        Token<CppTokenId> token2 = token;
                        return token2;
                    }
                    default: {
                        Token<CppTokenId> token3 = null;
                        return token3;
                    }
                }
            }
        }
        finally {
            extendedTokenSequence.moveIndex(n);
            extendedTokenSequence.moveNext();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.stack.size(); ++i) {
            StackEntry stackEntry = (StackEntry)this.stack.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stackEntry.toString());
        }
        stringBuilder.append("+" + this.getIndent() + "-" + this.getSelfIndent());
        return stringBuilder.toString();
    }

    public StatementContinuation getStatementContinuation() {
        return this.statementContinuation;
    }

    public void setStatementContinuation(StatementContinuation statementContinuation) {
        this.statementContinuation = statementContinuation;
    }

    public StatementKind getLastStatementKind(ExtendedTokenSequence extendedTokenSequence) {
        if (this.lastStatementStart < 0) {
            return null;
        }
        int n = extendedTokenSequence.index();
        try {
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            extendedTokenSequence.moveIndex(this.lastStatementStart);
            StatementKind statementKind = null;
            block29: while (true) {
                Token<CppTokenId> token;
                if (!extendedTokenSequence.moveNext()) {
                    token = null;
                    return token;
                }
                token = extendedTokenSequence.token();
                switch ((CppTokenId)token.id()) {
                    case RPAREN: {
                        --n2;
                        break;
                    }
                    case LPAREN: {
                        if (n2 == 0 && !bl && n3 == 0) {
                            if (this.isDeclarationLevel()) {
                                StatementKind statementKind2 = StatementKind.FUNCTION;
                                return statementKind2;
                            }
                            StatementKind statementKind3 = StatementKind.EXPRESSION_STATEMENT;
                            return statementKind3;
                        }
                        ++n2;
                        break;
                    }
                    case LBRACE: 
                    case RBRACE: 
                    case SEMICOLON: {
                        if (this.isDeclarationLevel()) {
                            if (statementKind != null) {
                                StatementKind statementKind4 = statementKind;
                                return statementKind4;
                            }
                            StatementKind statementKind5 = StatementKind.FUNCTION;
                            return statementKind5;
                        }
                        StatementKind statementKind6 = StatementKind.DECLARATION_STATEMENT;
                        return statementKind6;
                    }
                    case EQ: {
                        if (this.isDeclarationLevel()) {
                            StatementKind statementKind7 = StatementKind.DECLARATION_STATEMENT;
                            return statementKind7;
                        }
                        StatementKind statementKind8 = StatementKind.EXPRESSION_STATEMENT;
                        return statementKind8;
                    }
                    case PLUSEQ: 
                    case MINUSEQ: 
                    case STAREQ: 
                    case SLASHEQ: 
                    case AMPEQ: 
                    case BAREQ: 
                    case CARETEQ: 
                    case PERCENTEQ: 
                    case LTLTEQ: 
                    case GTGTEQ: {
                        if (n2 != 0) break;
                        StatementKind statementKind9 = StatementKind.EXPRESSION_STATEMENT;
                        return statementKind9;
                    }
                    case GT: {
                        if (n2 != 0 || bl) continue block29;
                        --n3;
                        break;
                    }
                    case LT: {
                        if (n2 != 0 || bl) continue block29;
                        ++n3;
                        break;
                    }
                    case NAMESPACE: {
                        StatementKind statementKind10 = StatementKind.NAMESPACE;
                        return statementKind10;
                    }
                    case CLASS: {
                        StatementKind statementKind11 = StatementKind.CLASS;
                        return statementKind11;
                    }
                    case STRUCT: 
                    case ENUM: 
                    case UNION: {
                        if (n2 != 0 || bl || n3 != 0) continue block29;
                        statementKind = StatementKind.CLASS;
                        break;
                    }
                    case EXTERN: {
                        if (n2 != 0 || bl || n3 != 0) continue block29;
                        statementKind = StatementKind.NAMESPACE;
                        break;
                    }
                    case SWITCH: 
                    case ELSE: 
                    case IF: 
                    case TRY: 
                    case CATCH: 
                    case WHILE: 
                    case FOR: 
                    case DO: 
                    case ASM: {
                        StatementKind statementKind12 = StatementKind.COMPAUND_STATEMENT;
                        return statementKind12;
                    }
                }
            }
        }
        finally {
            extendedTokenSequence.moveIndex(n);
            extendedTokenSequence.moveNext();
        }
    }

    public void clearLastStatementStart() {
        this.lastStatementStart = -1;
    }

    public void setLastStatementStart(ExtendedTokenSequence extendedTokenSequence) {
        if (this.lastStatementStart == -1) {
            this.lastStatementStart = extendedTokenSequence.index();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementKind {
        NAMESPACE,
        CLASS,
        FUNCTION,
        DECLARATION_STATEMENT,
        COMPAUND_STATEMENT,
        EXPRESSION_STATEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementContinuation {
        START,
        CONTINUE,
        STOP;

    }
}

