/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.ReformatterImpl;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reformatter
implements ReformatTask {
    private Context context;
    private Document doc;
    private CodeStyle codeStyle;
    private static boolean expandTabToSpaces = true;
    private static int tabSize = 8;

    public Reformatter(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public Reformatter(Document document, CodeStyle codeStyle) {
        this.doc = document;
        this.codeStyle = codeStyle;
    }

    public void reformat() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        expandTabToSpaces = this.codeStyle.expandTabToSpaces();
        tabSize = this.codeStyle.getGlobalTabSize();
        if (this.context != null) {
            for (Context.Region region : this.context.indentRegions()) {
                this.reformatImpl(region);
            }
        } else {
            int n = this.doc.getLength();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            if (tokenHierarchy == null) {
                return;
            }
            this.reformatImpl(tokenHierarchy, 0, n);
        }
    }

    private void reformatImpl(Context.Region region) throws BadLocationException {
        int n = region.getStartOffset();
        int n2 = region.getEndOffset();
        if ("text/x-c++".equals(this.context.mimePath())) {
            this.reformatLanguage((Language<CppTokenId>)CppTokenId.languageCpp(), n, n2);
        } else if ("text/x-c".equals(this.context.mimePath())) {
            this.reformatLanguage((Language<CppTokenId>)CppTokenId.languageC(), n, n2);
        }
    }

    private void reformatLanguage(Language<CppTokenId> language, int n, int n2) throws BadLocationException {
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)this.doc.getText(0, this.doc.getLength()), language);
        if (tokenHierarchy == null) {
            return;
        }
        this.reformatImpl(tokenHierarchy, n, n2);
    }

    private void reformatImpl(TokenHierarchy tokenHierarchy, int n, int n2) throws BadLocationException {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && tokenSequence.token().id() != CppTokenId.NEW_LINE) {
            while (tokenSequence.movePrevious()) {
                n = tokenSequence.offset();
                if (tokenSequence.token().id() == CppTokenId.NEW_LINE) continue;
            }
        }
        while (tokenSequence != null && (n == 0 || tokenSequence.moveNext())) {
            tokenSequence.move(n);
            if (tokenSequence.language() == CppTokenId.languageC() || tokenSequence.language() == CppTokenId.languageCpp() || tokenSequence.language() == CppTokenId.languagePreproc()) {
                this.reformatImpl((TokenSequence<CppTokenId>)tokenSequence, n, n2);
                return;
            }
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            tokenSequence = tokenSequence.embedded();
        }
    }

    private void reformatImpl(TokenSequence<CppTokenId> tokenSequence, int n, int n2) throws BadLocationException {
        int n3 = -1;
        int n4 = -1;
        String string = null;
        for (Diff diff : new ReformatterImpl(tokenSequence, n, n2, this.codeStyle).reformat()) {
            int n5 = diff.getStartOffset();
            int n6 = diff.getEndOffset();
            if (n > n6 || n2 < n5) continue;
            String string2 = diff.getText();
            if (n2 < n6) {
                if (string2 != null && string2.length() > 0) {
                    string2 = n6 - n2 >= string2.length() ? null : string2.substring(0, string2.length() - n6 + n2);
                }
                n6 = n2;
            }
            if (n3 == n6) {
                n3 = n5;
                string = string2 + string;
                continue;
            }
            if (!this.applyDiff(n3, n4, string)) {
                return;
            }
            n3 = n5;
            n4 = n6;
            string = string2;
        }
        if (n3 > -1) {
            this.applyDiff(n3, n4, string);
        }
    }

    private boolean applyDiff(int n, int n2, String string) throws BadLocationException {
        if (n2 - n > 0) {
            String string2 = this.doc.getText(n, n2 - n);
            if (string != null && string.equals(string2)) {
                return true;
            }
            if (!this.checkRemoved(string2)) {
                Logger logger = Logger.getLogger("org.netbeans.modules.cnd.editor");
                String string3 = NbBundle.getMessage(Reformatter.class, (String)"REFORMATTING_FAILED", (Object)this.doc.getText(n, n2 - n), (Object)string);
                logger.severe(string3);
                return false;
            }
            this.doc.remove(n, n2 - n);
        }
        if (string != null && string.length() > 0) {
            this.doc.insertString(n, string, null);
        }
        return true;
    }

    private boolean checkRemoved(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public ExtraLock reformatLock() {
        return new Lock();
    }

    static class Diff {
        private int start;
        private int end;
        private int newLines;
        private int spaces;
        private boolean isIndent;

        Diff(int n, int n2, int n3, int n4, boolean bl) {
            this.start = n;
            this.end = n2;
            this.spaces = n4;
            this.newLines = n3;
            this.isIndent = bl;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getText() {
            return Diff.repeatChar(this.newLines, '\n', false) + Diff.repeatChar(this.spaces, ' ', this.isIndent);
        }

        public void setText(int n, int n2, boolean bl) {
            this.newLines = n;
            this.spaces = n2;
            this.isIndent = bl;
        }

        public void replaceSpaces(int n, boolean bl) {
            this.spaces = n;
            this.isIndent = bl;
        }

        public boolean hasNewLine() {
            return this.newLines > 0;
        }

        public int spaceLength() {
            return this.spaces;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">: newLines=" + this.newLines + " spaces=" + this.spaces;
        }

        public static String repeatChar(int n, char c, boolean bl) {
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                if (c == ' ') {
                    return " ";
                }
                return "\n";
            }
            StringBuilder stringBuilder = new StringBuilder(n);
            if (c == ' ' && bl && !expandTabToSpaces && tabSize > 1) {
                while (n >= tabSize) {
                    stringBuilder.append('\t');
                    n -= tabSize;
                }
            }
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        public static boolean equals(String string, int n, int n2, boolean bl) {
            String string2 = Diff.repeatChar(n, '\n', false) + Diff.repeatChar(n2, ' ', bl);
            return string.equals(string2);
        }
    }

    private class Lock
    implements ExtraLock {
        private Lock() {
        }

        public void lock() {
        }

        public void unlock() {
        }
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(Context context) {
            return new Reformatter(context);
        }
    }
}

