/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());
    private static final String PROFILE_PROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectClassesString");
    private static final String PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectSubprojectClassesString");
    public static final SimpleFilter FILTER_PROJECT_ONLY = new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, "{$project.classes.only}");
    public static final SimpleFilter FILTER_PROJECT_SUBPROJECTS_ONLY = new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, "{$project.subprojects.classes.only}");

    public static ClasspathInfo getClasspathInfo(Project project) {
        return ProjectUtilities.getClasspathInfo(project, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean bl) {
        return ProjectUtilities.getClasspathInfo(project, bl, true, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean bl, boolean bl2, boolean bl3) {
        FileObject[] fileObjectArray = ProjectUtilities.getSourceRoots(project, bl);
        HashSet<FileObject> hashSet = new HashSet<FileObject>(fileObjectArray.length);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        hashSet.addAll(Arrays.asList(fileObjectArray));
        if (!(fileObjectArray != null && fileObjectArray.length != 0 || bl)) {
            fileObjectArray = ProjectUtilities.getSourceRoots(project, true);
        }
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        if (fileObjectArray.length == 0) {
            return null;
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/compile");
        for (ClassPath.Entry entry : classPath3.entries()) {
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
            FileObject[] fileObjectArray2 = result.getRoots();
            if (fileObjectArray2 != null && fileObjectArray2.length != 0) continue;
            arrayList.add(entry.getURL());
        }
        classPath3 = ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
        return ClasspathInfo.create((ClassPath)(bl3 ? ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/boot") : classPath), (ClassPath)(bl3 ? classPath3 : classPath), (ClassPath)(bl2 ? classPath2 : classPath));
    }

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        return OpenProjects.getDefault().getOpenProjects();
    }

    public static Project[] getSortedProjects(Project[] projectArray) {
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            arrayList.add(projectArray[i]);
        }
        try {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Project project = (Project)object;
                    Project project2 = (Project)object2;
                    return ProjectUtils.getInformation((Project)project).getDisplayName().toLowerCase().compareTo(ProjectUtils.getInformation((Project)project2).getDisplayName().toLowerCase());
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        arrayList.toArray(projectArray);
        return projectArray;
    }

    public static boolean hasAction(Project project, String string) {
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static FileObject getOrCreateBuildFolder(Project project, String string) {
        FileObject fileObject = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string));
        if (fileObject == null) {
            try {
                fileObject = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)string);
            }
            catch (IOException iOException) {
                MessageFormat.format(NbBundle.getMessage(ProjectUtilities.class, (String)"FailedCreateOutputFolderMsg"), iOException.getMessage());
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                return null;
            }
        }
        return fileObject;
    }

    public static Properties getProjectProperties(Project project) {
        final Properties properties = new Properties();
        final FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (fileObject != null) {
            ProjectManager.mutex().readAccess(new Runnable(){

                public void run() {
                    try {
                        properties.load(fileObject.getInputStream());
                    }
                    catch (IOException iOException) {
                        LOGGER.finest("Could not load properties file: " + fileObject.getPath());
                    }
                }
            });
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project) {
        FileObject fileObject = project.getProjectDirectory().getFileObject("build.xml");
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(FileUtil.toFile((FileObject)fileObject), "r");
            byArray = new byte[(int)fileObject.getSize()];
            randomAccessFile.readFully(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProfilerLogger.log((Exception)fileNotFoundException);
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            String string = null;
            return string;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    ProfilerLogger.log((Exception)iOException);
                }
            }
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManager.getDefault().notify(65536, (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    public static List<SimpleFilter> getProjectDefaultInstrFilters(Project project) {
        ArrayList<SimpleFilter> arrayList = new ArrayList<SimpleFilter>();
        if (ProjectUtils.getSources((Project)project).getSourceGroups("java").length > 0) {
            arrayList.add(FILTER_PROJECT_ONLY);
        }
        if (ProjectUtilities.hasSubprojects(project)) {
            arrayList.add(FILTER_PROJECT_SUBPROJECTS_ONLY);
        }
        return arrayList;
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] stringArray) {
        ProjectUtilities.computeProjectPackages(project, true, stringArray);
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[stringArray[1].length];
        for (int i = 0; i < stringArray[1].length; ++i) {
            sourceCodeSelectionArray[i] = "".equals(stringArray[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(stringArray[1][i] + ".", "", "");
        }
        return sourceCodeSelectionArray;
    }

    public static Project getProjectForBuildScript(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        while (fileObject != null) {
            try {
                if (fileObject.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Trying: " + fileObject);
                    }
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Got: " + (project != null ? ProjectUtilities.getProjectName(project) : null));
                    }
                    if (project != null) {
                        return project;
                    }
                }
                fileObject = fileObject.getParent();
            }
            catch (IOException iOException) {
                ProfilerLogger.severe((String)("Got: IOException : " + iOException.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation == null) {
            return new ImageIcon();
        }
        return projectInformation.getIcon();
    }

    public static String getProjectName(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        return projectInformation != null ? projectInformation.getDisplayName() : "UNKNOWN";
    }

    public static FileObject[] getSourceRoots(Project project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Project project, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<Project> hashSet2 = new HashSet<Project>();
        hashSet2.add(project);
        ProjectUtilities.getSourceRoots(project, bl, hashSet2, hashSet);
        return hashSet.toArray(new FileObject[hashSet.size()]);
    }

    public static void fetchSubprojects(Project project, Set<Project> set) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            for (Project project2 : subprojectProvider.getSubprojects()) {
                if (!set.add(project2)) continue;
                ProjectUtilities.fetchSubprojects(project2, set);
            }
        }
    }

    public static SimpleFilter computeProjectOnlyInstrumentationFilter(Project project, SimpleFilter simpleFilter, String[][] stringArray) {
        if (FILTER_PROJECT_ONLY.equals((Object)simpleFilter)) {
            ProjectUtilities.computeProjectPackages(project, false, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray[0].length; ++i) {
                stringBuffer.append("".equals(stringArray[0][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : stringArray[0][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, stringBuffer.toString().trim());
        }
        if (FILTER_PROJECT_SUBPROJECTS_ONLY.equals((Object)simpleFilter)) {
            ProjectUtilities.computeProjectPackages(project, true, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray[1].length; ++i) {
                stringBuffer.append("".equals(stringArray[1][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : stringArray[1][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, stringBuffer.toString().trim());
        }
        return null;
    }

    public static String getDefaultPackageClassNames(Project project) {
        Collection<String> collection = SourceUtils.getDefaultPackageClassNames(project);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(string).append(" ");
        }
        return stringBuffer.toString();
    }

    public static void computeProjectPackages(Project project, boolean bl, String[][] stringArray) {
        FileObject[] fileObjectArray;
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (stringArray[0] == null) {
            fileObjectArray = new ArrayList();
            for (FileObject fileObject : ProjectUtilities.getSourceRoots(project, false)) {
                ProjectUtilities.addSubpackages((Collection<String>)fileObjectArray, "", fileObject);
            }
            stringArray[0] = fileObjectArray.toArray(new String[0]);
        }
        if (bl && stringArray[1] == null) {
            fileObjectArray = ProjectUtilities.getSourceRoots(project, true);
            ArrayList arrayList = new ArrayList();
            for (FileObject fileObject : fileObjectArray) {
                ProjectUtilities.addSubpackages(arrayList, "", fileObject);
            }
            stringArray[1] = arrayList.toArray(new String[0]);
        }
    }

    public static FileObject findTestForFile(FileObject fileObject) {
        if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2);
        FileObject fileObject3 = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            fileObject3 = ProjectUtilities.findUnitTestInTestRoot(classPath, fileObject, uRLArray[i]);
            if (fileObject3 == null) continue;
            return fileObject3;
        }
        return null;
    }

    public static void invokeAction(Project project, String string) {
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return;
        }
        actionProvider.invokeAction(string, Lookup.getDefault());
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        return sourceGroupArray.length > 0;
    }

    private static void getSourceRoots(Project project, boolean bl, Set<Project> set, Set<FileObject> set2) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SubprojectProvider subprojectProvider = sources.getSourceGroups("java");
        int n = ((SourceGroup[])subprojectProvider).length;
        for (int i = 0; i < n; ++i) {
            SourceGroup sourceGroup = subprojectProvider[i];
            set2.add(sourceGroup.getRootFolder());
        }
        if (bl && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project project2 : subprojectProvider.getSubprojects()) {
                if (!set.add(project2)) continue;
                ProjectUtilities.getSourceRoots(project2, bl, set, set2);
            }
        }
    }

    private static void addSubpackages(Collection<String> collection, String string, FileObject fileObject) {
        FileObject fileObject2;
        int n;
        if (!fileObject.isFolder()) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!collection.contains(string)) {
            for (n = 0; n < fileObjectArray.length; ++n) {
                fileObject2 = fileObjectArray[n];
                if (!fileObject2.getExt().equals("java")) continue;
                collection.add(string);
                break;
            }
        }
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.isFolder()) continue;
            if ("".equals(string)) {
                ProjectUtilities.addSubpackages(collection, fileObject2.getName(), fileObject2);
                continue;
            }
            ProjectUtilities.addSubpackages(collection, string + "." + fileObject2.getName(), fileObject2);
        }
    }

    private static boolean hasSubprojects(Project project) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider == null) {
            return false;
        }
        return subprojectProvider.getSubprojects().size() > 0;
    }

    private static FileObject findUnitTestInTestRoot(ClassPath classPath, FileObject fileObject, URL uRL) {
        Object object;
        ClassPath classPath2 = null;
        if (uRL == null) {
            classPath2 = classPath;
        } else {
            try {
                object = new ArrayList<PathResourceImplementation>();
                object.add(ClassPathSupport.createResource((URL)uRL));
                classPath2 = ClassPathSupport.createClassPath((List)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                classPath2 = classPath;
            }
        }
        object = ProjectUtilities.getTestName(classPath, fileObject);
        return classPath2.findResource((String)object + ".java");
    }

    private static String getTestName(ClassPath classPath, FileObject fileObject) {
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = null;
        string2 = fileObject.isFolder() ? ProjectUtilities.convertPackage2SuiteName(string) : ProjectUtilities.convertClass2TestName(string);
        return string2;
    }

    private static String convertClass2TestName(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(0, n) : "";
        String string3 = n > -1 ? string.substring(n + 1) : string;
        string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        if (string2.length() > 0) {
            string2 = string2 + "/";
        }
        return string2 + string3 + "Test";
    }

    private static String convertPackage2SuiteName(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        return string + "/" + string2 + "Test";
    }
}

