/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.CppTokenProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CndTokenUtilities {
    private CndTokenUtilities() {
    }

    public static boolean isInPreprocessorDirective(Document document, int n) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (tokenSequence.moveNext()) {
                return tokenSequence.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE;
            }
        }
        return false;
    }

    public static void processTokens(CppTokenProcessor cppTokenProcessor, Document document, int n, int n2) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, 0);
        if (tokenSequence == null) {
            return;
        }
        int n3 = tokenSequence.move(n);
        if (n > n2) {
            return;
        }
        cppTokenProcessor.start(n, n - n3);
        if (CndTokenUtilities.processTokensImpl(cppTokenProcessor, tokenSequence, n, n2)) {
            cppTokenProcessor.end(n2, tokenSequence.offset());
        } else {
            cppTokenProcessor.end(n2, n2);
        }
    }

    public static Token<CppTokenId> shiftToNonWhiteBwd(Document document, int n) {
        Token<CppTokenId> token = CndTokenUtilities.getOffsetTokenImpl(document, n, true, false);
        boolean bl = true;
        while (token != null && (token.id() == CppTokenId.WHITESPACE || bl && "whitespace".equals(((CppTokenId)token.id()).primaryCategory()))) {
            bl = false;
            int n2 = token.offset(null);
            if (n2 == 0) break;
            token = CndTokenUtilities.getOffsetTokenImpl(document, n2 - 1, true, false);
        }
        return token;
    }

    public static Token<CppTokenId> getOffsetTokenCheckPrev(Document document, int n) {
        return CndTokenUtilities.getOffsetTokenImpl(document, n, true, true);
    }

    public static Token<CppTokenId> getOffsetToken(Document document, int n) {
        return CndTokenUtilities.getOffsetToken(document, n, false);
    }

    public static Token<CppTokenId> getOffsetToken(Document document, int n, boolean bl) {
        return CndTokenUtilities.getOffsetTokenImpl(document, n, bl, false);
    }

    private static Token<CppTokenId> getOffsetTokenImpl(Document document, int n, boolean bl, boolean bl2) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n);
        if (tokenSequence == null) {
            return null;
        }
        Token<CppTokenId> token = CndTokenUtilities.getOffsetTokenImpl(tokenSequence, n, bl2);
        if (bl && token != null && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            assert (tokenSequence2 != null) : "no embedding for preprocessor directive " + token;
            token = CndTokenUtilities.getOffsetTokenImpl((TokenSequence<CppTokenId>)tokenSequence2, n, bl2);
        }
        return token;
    }

    private static Token<CppTokenId> getOffsetTokenImpl(TokenSequence<CppTokenId> tokenSequence, int n, boolean bl) {
        if (tokenSequence == null) {
            return null;
        }
        int n2 = tokenSequence.move(n);
        Token token = null;
        boolean bl2 = false;
        if (tokenSequence.moveNext()) {
            String string;
            token = tokenSequence.offsetToken();
            if (bl && n2 == 0 && ("whitespace".equals(string = ((CppTokenId)token.id()).primaryCategory()) || "comment".equals(string) || "separator".equals(string) || "operator".equals(string))) {
                bl2 = true;
            }
        }
        if (bl2 && tokenSequence.movePrevious()) {
            token = tokenSequence.offsetToken();
        }
        return token;
    }

    private static boolean processTokensImpl(CppTokenProcessor cppTokenProcessor, TokenSequence<CppTokenId> tokenSequence, int n, int n2) {
        boolean bl = false;
        while (tokenSequence.moveNext() && tokenSequence.offset() < n2) {
            Token token = tokenSequence.token();
            if (cppTokenProcessor.token((Token<CppTokenId>)token, tokenSequence.offset())) {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 == null) continue;
                if (tokenSequence.offset() < n) {
                    tokenSequence2.move(n);
                }
                bl |= CndTokenUtilities.processTokensImpl(cppTokenProcessor, (TokenSequence<CppTokenId>)tokenSequence2, n, n2);
                continue;
            }
            bl = true;
        }
        return bl;
    }
}

