/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.cookies;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;

final class ShareableInputSource
extends InputSource {
    private ByteStream stream;
    private CharacterStream reader;
    private boolean[] initialized = new boolean[2];
    private final InputSource peer;
    private final int bufferSize;
    private static final int BUFFER_SIZE = 262151;
    private IOException resetException;

    public static ShareableInputSource create(InputSource inputSource) {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        if (inputSource instanceof ShareableInputSource) {
            return (ShareableInputSource)inputSource;
        }
        return new ShareableInputSource(inputSource, 262151);
    }

    private ShareableInputSource(InputSource inputSource, int n) {
        this.peer = inputSource;
        this.bufferSize = n;
    }

    public InputStream getByteStream() {
        InputStream inputStream = this.peer.getByteStream();
        if (!this.initialized[1] && inputStream != null) {
            this.stream = new ByteStream(inputStream, this.bufferSize);
            this.stream.mark(this.bufferSize);
            this.initialized[1] = true;
        }
        return this.stream;
    }

    public Reader getCharacterStream() {
        Reader reader = this.peer.getCharacterStream();
        if (!this.initialized[0] && reader != null) {
            this.reader = new CharacterStream(reader, this.bufferSize / 2);
            this.initialized[0] = true;
            try {
                this.reader.mark(this.bufferSize / 2);
            }
            catch (IOException iOException) {
                this.resetException = iOException;
            }
        }
        return this.reader;
    }

    public void reset() throws IOException {
        if (this.resetException != null) {
            throw this.resetException;
        }
        if (this.initialized[1]) {
            this.stream.reset();
        }
        if (this.initialized[0]) {
            this.reader.reset();
        }
    }

    public void closeAll() throws IOException {
        if (this.initialized[1]) {
            this.stream.internalClose();
        }
        if (this.initialized[0]) {
            this.reader.internalClose();
        }
    }

    public String getEncoding() {
        return this.peer.getEncoding();
    }

    public String getSystemId() {
        return this.peer.getSystemId();
    }

    public String getPublicId() {
        return this.peer.getPublicId();
    }

    private static class CharacterStream
    extends BufferedReader {
        public CharacterStream(Reader reader, int n) {
            super(reader, n);
        }

        public void close() throws IOException {
        }

        private void internalClose() throws IOException {
            super.close();
        }
    }

    private static class ByteStream
    extends BufferedInputStream {
        public ByteStream(InputStream inputStream, int n) {
            super(inputStream, n);
        }

        public void close() throws IOException {
        }

        private void internalClose() throws IOException {
            super.close();
        }
    }
}

