/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.lib.Util;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.wizard.SchemaWizardIterator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.text.api.XMLFormatUtil;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DocumentModel;
import org.netbeans.modules.xml.wizard.XMLContentPanel;
import org.netbeans.modules.xml.wizard.XMLGeneratorVisitor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SampleXMLGeneratorWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private Project srcProject;
    private FileObject schemaFileObject;
    private DocumentModel model;
    private XMLContentPanel xmlPanel;
    private static String PREFIX = "ns0";
    private static final String XML_EXT = "xml";

    public SampleXMLGeneratorWizardIterator(SchemaDataObject schemaDataObject) {
        this.schemaFileObject = schemaDataObject.getPrimaryFile();
        this.srcProject = FileOwnerQuery.getOwner((FileObject)this.schemaFileObject);
    }

    public void show() {
        boolean bl;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        this.initialize(wizardDescriptor);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            try {
                this.instantiate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        this.xmlPanel = new XMLContentPanel(true);
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new AbstractPanel.WizardStep((AbstractPanel)this.xmlPanel)};
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate() throws IOException {
        OutputStreamWriter outputStreamWriter;
        Object object;
        String string = this.schemaFileObject.getName();
        if (string == null || "null".equals(string)) {
            string = "XMLDocument";
        }
        final FileObject fileObject = this.schemaFileObject.getParent();
        String string2 = string;
        int n = 1;
        while (fileObject.getFileObject(string2, XML_EXT) != null) {
            string2 = string + n;
            ++n;
        }
        final String string3 = string2;
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        String string4 = EncodingUtil.getProjectEncoding((FileObject)fileObject);
        if (!EncodingUtil.isValidEncoding((String)string4)) {
            string4 = "UTF-8";
        }
        String string5 = string3 + "." + XML_EXT;
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2;
                fileObjectArray[0] = fileObject2 = fileObject.createData(string3, SampleXMLGeneratorWizardIterator.XML_EXT);
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        StringBuffer stringBuffer = new StringBuffer();
        this.writeXMLComment(stringBuffer, string5, string4);
        this.writeXMLFile(stringBuffer);
        FileLock fileLock = null;
        try {
            fileLock = fileObjectArray[0].lock();
            object = fileObjectArray[0].getOutputStream(fileLock);
            object = new BufferedOutputStream((OutputStream)object, 999);
            outputStreamWriter = new OutputStreamWriter((OutputStream)object, string4);
            outputStreamWriter.write(stringBuffer.toString());
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            fileLock.releaseLock();
            fileLock = null;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        object = new HashSet(1);
        outputStreamWriter = DataObject.find((FileObject)fileObjectArray[0]);
        Util.performDefaultAction((DataObject)outputStreamWriter);
        object.add(outputStreamWriter);
        this.formatXML(fileObjectArray[0]);
        return object;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        this.index = 0;
        URL uRL = null;
        try {
            object = this.schemaFileObject.getParent();
            uRL = object.getURL();
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model = new DocumentModel(uRL);
        object = FileUtil.toFile((FileObject)this.schemaFileObject);
        String string = ((File)object).getPath();
        if (string != null) {
            try {
                string = new URI(string).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.model.setPrimarySchema(string);
        this.xmlPanel.setObject((Object)this.model);
        this.model.setPrefix(PREFIX);
        String string2 = Util.getNamespace((FileObject)this.schemaFileObject);
        this.model.setNamespace(string2);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(SchemaWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private void generateXMLBody(DocumentModel documentModel, String string, StringBuffer stringBuffer) {
        XMLGeneratorVisitor xMLGeneratorVisitor = new XMLGeneratorVisitor(documentModel.getPrimarySchema(), documentModel.getXMLContentAttributes(), stringBuffer);
        xMLGeneratorVisitor.generateXML(string);
    }

    private void modifyRootElementAttrs(FileObject fileObject) {
        try {
            Object object;
            Object object22;
            File file = new File(fileObject.getPath());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
            Map map = this.model.getXMLContentAttributes().getNamespaceToPrefixMap();
            if (map == null || map.size() == 0) {
                return;
            }
            for (Object object22 : map.keySet()) {
                object = document.createAttribute("xmlns:" + (String)map.get(object22));
                object.setValue((String)object22);
                namedNodeMap.setNamedItem((Node)object);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            object22 = new DOMSource(document);
            object = new StreamResult(file);
            transformer.transform((Source)object22, (Result)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeXMLComment(StringBuffer stringBuffer, String string, String string2) throws IOException {
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>\n");
        stringBuffer.append("\n");
        Date date = new Date();
        String string3 = DateFormat.getDateInstance(1).format(date);
        String string4 = DateFormat.getTimeInstance(3).format(date);
        String string5 = System.getProperty("user.name");
        stringBuffer.append("<!--\n");
        stringBuffer.append("    Document   : " + string + "\n");
        stringBuffer.append("    Created on : " + string3 + ", " + string4 + "\n");
        stringBuffer.append("    Author     : " + string5 + "\n");
        stringBuffer.append("    Description:\n");
        stringBuffer.append("        Purpose of the document follows.\n");
        stringBuffer.append("-->\n");
        stringBuffer.append("\n");
    }

    private void formatXML(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            BaseDocument baseDocument = (BaseDocument)editorCookie.getDocument();
            XMLFormatUtil.reformat((BaseDocument)baseDocument, (int)0, (int)baseDocument.getLength());
            EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie instanceof TextEditorSupport && editCookie != null) {
                ((TextEditorSupport)editCookie).saveDocument();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void modifyRootElementAttrs(StringBuffer stringBuffer) {
        Map map = this.model.getXMLContentAttributes().getNamespaceToPrefixMap();
        if (map == null || map.size() == 0) {
            return;
        }
        int n = stringBuffer.indexOf("xmlns");
        int n2 = stringBuffer.indexOf("xmlns", n + 1);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (String string : map.keySet()) {
            String string2 = "xmlns:" + (String)map.get(string) + "='" + string + "'";
            if (stringBuffer.indexOf(string2) != -1) continue;
            stringBuffer.insert(n2, string2 + "\n   ");
        }
        stringBuffer.insert(n2, stringBuffer2.toString());
    }

    private void writeXMLFile(StringBuffer stringBuffer) throws IOException {
        String string = this.model.getRoot();
        if (string == null) {
            string = "root";
        }
        String string2 = this.model.getPrefix();
        String string3 = this.model.getNamespace();
        if (string2 == null || "".equals(string2)) {
            stringBuffer.append("<" + string + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
        } else {
            stringBuffer.append("<" + string2 + ":" + string + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
        }
        if (string2 == null || "".equals(string2)) {
            stringBuffer.append("   xmlns='" + string3 + "'\n");
        } else {
            stringBuffer.append("   xmlns:" + string2 + "='" + string3 + "'\n");
        }
        stringBuffer.append("   xsi:schemaLocation='" + string3 + " " + this.schemaFileObject.getNameExt() + "'>\n");
        this.generateXMLBody(this.model, string, stringBuffer);
        this.modifyRootElementAttrs(stringBuffer);
        if (string2 == null || "".equals(string2)) {
            stringBuffer.append("\n");
            stringBuffer.append("</" + string + ">\n");
        } else {
            stringBuffer.append("\n");
            stringBuffer.append("</" + string2 + ":" + string + ">\n");
        }
    }
}

