/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.html.editor.gsf.embedding.HtmlModel;
import org.netbeans.modules.html.editor.gsf.embedding.HtmlTranslatedSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEmbeddingModel
implements IncrementalEmbeddingModel {
    static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    static final String JSP_MIME_TYPE = "text/x-jsp";
    static final String JSP_TAG_MIME_TYPE = "text/x-tag";
    static final String PHP_TAG_MIME_TYPE = "text/x-php5";
    final Set<String> sourceMimeTypes = new HashSet<String>();

    public HtmlEmbeddingModel() {
        this.sourceMimeTypes.add(JSP_MIME_TYPE);
        this.sourceMimeTypes.add(RHTML_MIME_TYPE);
        this.sourceMimeTypes.add(JSP_TAG_MIME_TYPE);
        this.sourceMimeTypes.add(PHP_TAG_MIME_TYPE);
    }

    public String getTargetMimeType() {
        return "text/html";
    }

    public Set<String> getSourceMimeTypes() {
        return this.sourceMimeTypes;
    }

    public Collection<? extends TranslatedSource> translate(Document document) {
        HtmlModel htmlModel = HtmlModel.get(document);
        return Collections.singletonList(new HtmlTranslatedSource(this, htmlModel));
    }

    public String toString() {
        return "HtmlEmbeddingModel(target=" + this.getTargetMimeType() + ",sources=" + this.getSourceMimeTypes() + ")";
    }

    public IncrementalEmbeddingModel.UpdateState update(EditHistory editHistory, Collection<? extends TranslatedSource> collection) {
        return ((HtmlTranslatedSource)collection.iterator().next()).incrementalUpdate(editHistory);
    }
}

