/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;

public class HtmlModel {
    private static final Logger LOGGER = Logger.getLogger(HtmlModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String HTML_MIME_TYPE = "text/html";
    private final Document doc;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    private String htmlCode;
    private boolean documentDirty = true;
    private int prevAstOffset;
    private int prevLexOffset;

    public static HtmlModel get(Document document) {
        HtmlModel htmlModel = (HtmlModel)document.getProperty(HtmlModel.class);
        if (htmlModel == null) {
            htmlModel = new HtmlModel(document);
            document.putProperty(HtmlModel.class, htmlModel);
        }
        return htmlModel;
    }

    HtmlModel(Document document) {
        this.doc = document;
        if (document != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            tokenHierarchy.addTokenHierarchyListener(new TokenHierarchyListener(){

                public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                    HtmlModel.this.documentDirty = true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtmlCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                this.extractHtml((Document)baseDocument, stringBuilder, false);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.htmlCode = stringBuilder.toString();
        }
        if (LOG) {
            LOGGER.log(Level.FINE, "===== VIRTUAL HTML SOURCE =====");
            LOGGER.log(Level.FINE, this.htmlCode);
            LOGGER.log(Level.FINE, "===============================");
        }
        return this.htmlCode;
    }

    private LanguagePath findLanguagePath(TokenHierarchy tokenHierarchy, String string) {
        LanguagePath languagePath = null;
        Set set = tokenHierarchy.languagePaths();
        for (LanguagePath languagePath2 : set) {
            if (!languagePath2.language(languagePath2.size() - 1).mimeType().equals(string)) continue;
            languagePath = languagePath2;
            break;
        }
        return languagePath;
    }

    void extractHtml(Document document, StringBuilder stringBuilder, boolean bl) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        LanguagePath languagePath = this.findLanguagePath(tokenHierarchy, HTML_MIME_TYPE);
        if (!tokenHierarchy.isActive() || languagePath == null) {
            return;
        }
        List list = tokenHierarchy.tokenSequenceList(languagePath, 0, document.getLength());
        Token token = null;
        for (TokenSequence tokenSequence : list) {
            int n;
            tokenSequence.moveStart();
            if (!tokenSequence.moveNext()) continue;
            if (token == null || (n = token.offset(tokenHierarchy) + token.length()) < tokenSequence.offset()) {
                // empty if block
            }
            n = tokenSequence.offset();
            int n2 = stringBuilder.length();
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                stringBuilder.append(token.text());
            }
            int n3 = token.offset(tokenHierarchy) + token.length();
            int n4 = stringBuilder.length();
            CodeBlockData codeBlockData = new CodeBlockData(n, n3, n2, n4);
            this.codeBlocks.add(codeBlockData);
        }
    }

    public int sourceToGeneratedPos(int n) {
        if (this.prevLexOffset == n) {
            return this.prevAstOffset;
        }
        this.prevLexOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.sourceStart;
        int n3 = codeBlockData.generatedStart + n2;
        this.prevAstOffset = n3 <= codeBlockData.generatedEnd ? n3 : codeBlockData.generatedEnd;
        return this.prevAstOffset;
    }

    public int generatedToSourcePos(int n) {
        if (this.prevAstOffset == n) {
            return this.prevLexOffset;
        }
        this.prevAstOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        this.prevLexOffset = n3 <= codeBlockData.sourceEnd ? n3 : codeBlockData.sourceEnd;
        return this.prevLexOffset;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        for (int i = 0; i < this.codeBlocks.size(); ++i) {
            CodeBlockData codeBlockData = this.codeBlocks.get(i);
            if (codeBlockData.sourceStart <= n && codeBlockData.sourceEnd > n) {
                return codeBlockData;
            }
            if (codeBlockData.sourceEnd != n) continue;
            if (i < this.codeBlocks.size() - 1) {
                CodeBlockData codeBlockData2 = this.codeBlocks.get(i + 1);
                if (codeBlockData2.sourceStart == n) {
                    return codeBlockData2;
                }
                return codeBlockData;
            }
            return codeBlockData;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (int i = 0; i < this.codeBlocks.size(); ++i) {
            CodeBlockData codeBlockData = this.codeBlocks.get(i);
            if (codeBlockData.generatedStart <= n && codeBlockData.generatedEnd > n) {
                return codeBlockData;
            }
            if (codeBlockData.generatedEnd != n) continue;
            if (i < this.codeBlocks.size() - 1) {
                CodeBlockData codeBlockData2 = this.codeBlocks.get(i + 1);
                if (codeBlockData2.generatedStart == n) {
                    return codeBlockData2;
                }
                return codeBlockData;
            }
            return codeBlockData;
        }
        return null;
    }

    IncrementalEmbeddingModel.UpdateState incrementalUpdate(EditHistory editHistory) {
        this.prevLexOffset = editHistory.convertOriginalToEdited(this.prevLexOffset);
        int n = editHistory.getStart();
        int n2 = editHistory.getOriginalEnd();
        int n3 = editHistory.getSizeDelta();
        boolean bl = false;
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceEnd <= n) continue;
            if (codeBlockData.sourceStart >= n2) {
                codeBlockData.sourceStart += n3;
                codeBlockData.sourceEnd += n3;
                continue;
            }
            if (codeBlockData.sourceStart <= n && codeBlockData.sourceEnd >= n2) {
                codeBlockData.sourceEnd += n3;
                bl = true;
                continue;
            }
            return IncrementalEmbeddingModel.UpdateState.FAILED;
        }
        return bl ? IncrementalEmbeddingModel.UpdateState.UPDATED : IncrementalEmbeddingModel.UpdateState.COMPLETED;
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;

        public CodeBlockData(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  SOURCE(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append(",\n  HTML(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

