/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.util.MissingResourceException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.html.HTMLIndentEngine;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HTMLOptions
extends BaseOptions {
    public static final String HTML = "html";
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    public static final String COMPLETION_LOWER_CASE_PROP = "completionLowerCase";
    private static final String HELP_ID = "editing.editor.html";
    public static final String JAVADOC_AUTO_POPUP_PROP = "javaDocAutoPopup";
    public static final String JAVADOC_BGCOLOR = "javaDocBGColor";
    public static final String JAVADOC_PREFERRED_SIZE_PROP = "javaDocPreferredSize";
    static final String[] HTML_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{"completionAutoPopup", "completionAutoPopupDelay", "completionInstantSubstitution", "completionLowerCase", "javaDocAutoPopup", "javaDocPreferredSize", "javaDocBGColor"});
    static final long serialVersionUID = 75289734362748537L;

    public HTMLOptions(Class clazz, String string) {
        super(clazz, string);
    }

    public HTMLOptions() {
        this(HTMLKit.class, HTML);
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean bl) {
        this.setSettingBoolean("completion-auto-popup", bl, COMPLETION_AUTO_POPUP_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", n, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean bl) {
        this.setSettingBoolean("completion-instant-substitution", bl, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    public boolean getCompletionLowerCase() {
        return this.getSettingBoolean("completion-lower-case");
    }

    public void setCompletionLowerCase(boolean bl) {
        this.setSettingBoolean("completion-lower-case", bl, COMPLETION_LOWER_CASE_PROP);
    }

    protected Class getDefaultIndentEngineClass() {
        return HTMLIndentEngine.class;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public boolean getJavaDocAutoPopup() {
        return this.getSettingBoolean("javadoc-auto-popup");
    }

    public void setJavaDocAutoPopup(boolean bl) {
        this.setSettingBoolean("javadoc-auto-popup", bl, JAVADOC_AUTO_POPUP_PROP);
    }

    public Color getJavaDocBGColor() {
        return (Color)this.getSettingValue("javadoc-bg-color");
    }

    public void setJavaDocBGColor(Color color) {
        this.setSettingValue("javadoc-bg-color", color, JAVADOC_BGCOLOR);
    }

    public Dimension getJavaDocPreferredSize() {
        return (Dimension)this.getSettingValue("javadoc-preferred-size");
    }

    public void setJavaDocPreferredSize(Dimension dimension) {
        this.setSettingValue("javadoc-preferred-size", dimension, JAVADOC_PREFERRED_SIZE_PROP);
    }

    protected String getString(String string) {
        try {
            return NbBundle.getMessage(HTMLOptions.class, (String)string);
        }
        catch (MissingResourceException missingResourceException) {
            return super.getString(string);
        }
    }

    protected String getContentType() {
        return "text/html";
    }
}

