/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class J2SEAntLogger
extends AntLogger {
    public boolean interestedInSession(AntSession antSession) {
        return antSession.getVerbosity() <= 2;
    }

    private static boolean isJ2SEProject(File file) {
        return J2SEAntLogger.getJ2SEProject(file) != null;
    }

    private static J2SEProject getJ2SEProject(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        try {
            Project project = ProjectManager.getDefault().findProject(fileObject);
            if (project != null) {
                return (J2SEProject)project.getLookup().lookup(J2SEProject.class);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        File file2;
        File file3;
        if (file.getName().equals("build-impl.xml") && (file3 = file.getParentFile()) != null && file3.getName().equals("nbproject") && (file2 = file3.getParentFile()) != null && file2.canRead()) {
            return J2SEAntLogger.isJ2SEProject(file2);
        }
        return false;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return new int[]{1};
    }

    public void taskFinished(AntEvent antEvent) {
        if ("javac".equals(antEvent.getTaskName())) {
            Throwable throwable = antEvent.getException();
            AntSession antSession = antEvent.getSession();
            if (throwable != null && !antSession.isExceptionConsumed(throwable)) {
                antSession.consumeException(throwable);
            }
        }
    }

    public void messageLogged(AntEvent antEvent) {
        if (!antEvent.isConsumed() && antEvent.getLogLevel() == 1 && antEvent.getMessage().startsWith("Trying to override old definition of task http://www.netbeans.org/ns/j2se-project/")) {
            antEvent.consume();
        }
    }
}

