/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.cast;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.mapper.cast.DetachedPseudoComp;
import org.netbeans.modules.bpel.mapper.cast.TypeChooserTreeModel;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.BpelMapperUtils;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.tree.DataObjectHolder;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.impl.SoaTreeCellRenderer;
import org.netbeans.modules.soa.ui.tree.impl.SoaTreeModelImpl;
import org.netbeans.modules.soa.ui.tree.impl.SoaTreeNodeImpl;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoCompEditor
extends EditorLifeCycleAdapter
implements Validator.Provider,
ValidStateManager.Provider {
    private BpelMapperModel mMapperModel;
    private boolean mInLeftTree;
    private AnyElement mAnyElement;
    private AnyAttribute mAnyAttr;
    private boolean mIsAttribute;
    private TreeItem mTreeItem;
    private BpelModel mBpelModel;
    private SoaTreeModelImpl mSoaTreeModel;
    private DefaultValidator mValidator;
    private ValidStateManager mFastVSM;
    private ValidStateManager mFullVSM;
    private JTextField fldName;
    private JTextField fldNamespace;
    private JTree gElementsTree;
    private JLabel lblName;
    private JLabel lblNamespace;
    private JScrollPane treeScrollPane;

    public PseudoCompEditor(TreeItem treeItem, AnyAttribute anyAttribute, BpelModel bpelModel, BpelMapperModel bpelMapperModel, boolean bl) {
        this.mTreeItem = treeItem;
        this.mAnyAttr = anyAttribute;
        this.mBpelModel = bpelModel;
        this.mIsAttribute = true;
        this.mMapperModel = bpelMapperModel;
        this.mInLeftTree = bl;
        this.createContent();
        this.initControls();
    }

    public PseudoCompEditor(TreeItem treeItem, AnyElement anyElement, BpelModel bpelModel, BpelMapperModel bpelMapperModel, boolean bl) {
        this.mTreeItem = treeItem;
        this.mAnyElement = anyElement;
        this.mBpelModel = bpelModel;
        this.mIsAttribute = false;
        this.mMapperModel = bpelMapperModel;
        this.mInLeftTree = bl;
        this.createContent();
        this.initControls();
    }

    public void createContent() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.mSoaTreeModel = new SoaTreeModelImpl((SoaTreeModel)new TypeChooserTreeModel(this.mBpelModel, this.mIsAttribute));
        this.gElementsTree.setModel((TreeModel)this.mSoaTreeModel);
        this.gElementsTree.setRootVisible(false);
        this.gElementsTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this.gElementsTree);
        this.gElementsTree.setCellRenderer((TreeCellRenderer)new SoaTreeCellRenderer(this.mSoaTreeModel){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                assert (object instanceof SoaTreeNodeImpl);
                SoaTreeNodeImpl soaTreeNodeImpl = (SoaTreeNodeImpl)object;
                Object object2 = soaTreeNodeImpl.getDataObject();
                if (object2 instanceof GlobalType) {
                    String string = this.mModelImpl.getDisplayName((Object)soaTreeNodeImpl);
                    string = EditorUtil.getAccentedString((String)string);
                    this.setText(string);
                }
                return this;
            }
        });
        this.gElementsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                GlobalType globalType = PseudoCompEditor.this.getSelectedType();
                if (globalType != null) {
                    PseudoCompEditor.this.fldName.setText(globalType.getName());
                    String string = globalType.getModel().getEffectiveNamespace((SchemaComponent)globalType);
                    PseudoCompEditor.this.fldNamespace.setText(string);
                }
                PseudoCompEditor.this.getValidStateManager(true).clearReasons();
                PseudoCompEditor.this.getValidator().revalidate(true);
            }
        });
        SoaUtil.activateInlineMnemonics((Container)((Object)this));
    }

    public boolean initControls() {
        this.getValidator().revalidate(true);
        return true;
    }

    public void setSelectedValue(DetachedPseudoComp detachedPseudoComp) {
    }

    public DetachedPseudoComp getSelectedValue() {
        GlobalType globalType = this.getSelectedType();
        String string = this.fldName.getText();
        String string2 = this.fldNamespace.getText();
        DetachedPseudoComp detachedPseudoComp = new DetachedPseudoComp(globalType, string, string2, this.mIsAttribute);
        return detachedPseudoComp;
    }

    private GlobalType getSelectedType() {
        Object object;
        Object object2;
        TreePath treePath = this.gElementsTree.getSelectionPath();
        if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof DataObjectHolder && (object = ((DataObjectHolder)object2).getDataObject()) != null && object instanceof GlobalType) {
            GlobalType globalType = (GlobalType)object;
            return globalType;
        }
        return null;
    }

    public static boolean showDlg(PseudoCompEditor pseudoCompEditor, Callable<Boolean> callable) {
        String string = null;
        string = pseudoCompEditor.mIsAttribute ? NbBundle.getMessage(PseudoCompEditor.class, (String)"PSEUDO_ATTRIBUTE_DLG_TITLE") : NbBundle.getMessage(PseudoCompEditor.class, (String)"PSEUDO_ELEMENT_DLG_TITLE");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)pseudoCompEditor, string);
        defaultDialogDescriptor.setOkButtonProcessor(callable);
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        SoaUtil.setInitialFocusComponentFor((Container)((Object)pseudoCompEditor));
        dialog.setVisible(true);
        return defaultDialogDescriptor.isOkHasPressed();
    }

    public Validator getValidator() {
        if (this.mValidator == null) {
            this.mValidator = new DefaultValidator(this, PseudoCompEditor.class){

                public void doFastValidation() {
                    String string;
                    String string2;
                    GlobalType globalType = PseudoCompEditor.this.getSelectedType();
                    if (globalType == null) {
                        this.addReasonKey(Validator.Severity.ERROR, "EMPTY_SELECTION");
                    }
                    if ((string2 = PseudoCompEditor.this.fldName.getText()) == null || string2.length() == 0) {
                        if (PseudoCompEditor.this.mIsAttribute) {
                            this.addReasonKey(Validator.Severity.ERROR, "EMPTY_ATTRIBUTE_NAME");
                        } else {
                            this.addReasonKey(Validator.Severity.ERROR, "EMPTY_ELEMENT_NAME");
                        }
                    }
                    if ((string = PseudoCompEditor.this.fldNamespace.getText()) == null || string.length() == 0) {
                        if (PseudoCompEditor.this.mIsAttribute) {
                            this.addReasonKey(Validator.Severity.WARNING, "EMPTY_ATTRIBUTE_NAMESPACE");
                        } else {
                            this.addReasonKey(Validator.Severity.WARNING, "EMPTY_ELEMENT_NAMESPACE");
                        }
                    }
                }

                public void doDetailedValidation() {
                    boolean bl;
                    this.doFastValidation();
                    String string = PseudoCompEditor.this.fldNamespace.getText();
                    String string2 = PseudoCompEditor.this.fldName.getText();
                    if ((string2 != null || string2.length() != 0) && (bl = BpelMapperUtils.hasSibling(PseudoCompEditor.this.mMapperModel, PseudoCompEditor.this.mInLeftTree, PseudoCompEditor.this.mTreeItem, string2, string, PseudoCompEditor.this.mIsAttribute))) {
                        if (PseudoCompEditor.this.mIsAttribute) {
                            this.addReasonKey(Validator.Severity.ERROR, "NOT_UNIQUE_ATTRIBUTE");
                        } else {
                            this.addReasonKey(Validator.Severity.ERROR, "NOT_UNIQUE_ELEMENT");
                        }
                    }
                }
            };
        }
        return this.mValidator;
    }

    public ValidStateManager getValidStateManager(boolean bl) {
        if (bl) {
            if (this.mFastVSM == null) {
                this.mFastVSM = new DefaultValidStateManager();
            }
            return this.mFastVSM;
        }
        if (this.mFullVSM == null) {
            this.mFullVSM = new DefaultValidStateManager();
        }
        return this.mFullVSM;
    }

    private void initComponents() {
        this.treeScrollPane = new JScrollPane();
        this.gElementsTree = new MyTree();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.lblNamespace = new JLabel();
        this.fldNamespace = new JTextField();
        this.treeScrollPane.setViewportView(this.gElementsTree);
        this.lblName.setText(NbBundle.getMessage(PseudoCompEditor.class, (String)"LBL_Name"));
        this.lblNamespace.setText(NbBundle.getMessage(PseudoCompEditor.class, (String)"LBL_Namespace"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.treeScrollPane, -1, 355, Short.MAX_VALUE).add(1, (Component)this.fldNamespace, -1, 355, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblName).addPreferredGap(0).add((Component)this.fldName, -1, 307, Short.MAX_VALUE)).add(1, (Component)this.lblNamespace)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.fldName, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblNamespace).addPreferredGap(0).add((Component)this.fldNamespace, -2, -1, -2).addPreferredGap(1).add((Component)this.treeScrollPane, -1, 264, Short.MAX_VALUE)));
        this.lblName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSN_Name"));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSD_Name"));
        this.fldName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSN_Name"));
        this.fldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSD_Name"));
        this.fldNamespace.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSN_Namespace"));
        this.fldNamespace.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PseudoCompEditor.class, (String)"ACSD_Namespace"));
        this.getAccessibleContext().setAccessibleName("null");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PseudoCompEditor.class).getString("ACSD_DLG_TypeCastChooser"));
    }

    private class MyTree
    extends JTree {
        private MyTree() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (PseudoCompEditor.this.mSoaTreeModel == null) {
                return null;
            }
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return null;
            }
            Object object = treePath.getLastPathComponent();
            if (object == null) {
                return null;
            }
            String string = PseudoCompEditor.this.mSoaTreeModel.getToolTipText(object);
            return string;
        }
    }
}

