/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.model.AbstractBpelModelUpdater;
import org.netbeans.modules.bpel.mapper.model.CopyToProcessor;
import org.netbeans.modules.bpel.mapper.model.FromProcessor;
import org.netbeans.modules.bpel.mapper.model.GraphInfoCollector;
import org.netbeans.modules.bpel.mapper.model.MapperTcContext;
import org.netbeans.modules.bpel.mapper.model.PathConverter;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.DateValueTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.ForEachConditionsTreeModel;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.AssignChild;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.ConditionHolder;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromChild;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.schema.SchemaModelsStack;
import org.netbeans.modules.xml.xpath.ext.spi.XPathPseudoComp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelModelUpdater
extends AbstractBpelModelUpdater {
    public BpelModelUpdater(MapperTcContext mapperTcContext) {
        super(mapperTcContext);
    }

    public Object updateOnChanges(TreePath treePath) throws Exception {
        BpelEntity bpelEntity = this.getDesignContext().getContextEntity();
        Class clazz = bpelEntity.getElementType();
        if (clazz == Assign.class) {
            this.updateAssign(treePath, (Assign)bpelEntity);
        } else if (clazz == Wait.class || clazz == OnAlarmPick.class || clazz == OnAlarmEvent.class) {
            this.updateTimeEventHolder(treePath, (TimeEventHolder)bpelEntity);
        } else if (clazz == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class) {
            this.updateConditionHolder(treePath, (ConditionHolder)bpelEntity);
        } else if (clazz == ForEach.class) {
            this.updateForEach(treePath, (ForEach)bpelEntity);
        }
        return null;
    }

    protected void updateFrom(Graph graph, Set<AbstractTypeCast> set, Set<XPathPseudoComp> set2, From from) throws Exception {
        assert (from != null);
        FromProcessor.FromForm fromForm = FromProcessor.calculateFromForm(from);
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        if (graphInfoCollector.onlyOneTransitLink()) {
            Link link = graphInfoCollector.getTransitLinks().get(0);
            TreeSourcePin treeSourcePin = (TreeSourcePin)link.getSource();
            TreePath treePath = treeSourcePin.getTreePath();
            AbstractBpelModelUpdater.TreePathInfo treePathInfo = this.collectTreeInfo(treePath, set, set2);
            XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)from);
            this.populateFrom(from, xPathModel, treePathInfo, set, set2);
        } else {
            boolean bl = false;
            if (fromForm != null) {
                switch (fromForm) {
                    case LITERAL: {
                        Vertex vertex;
                        Object object;
                        if (graphInfoCollector.getPrimaryRoots().size() != 1 || graphInfoCollector.getSecondryRoots().size() != 0 || (object = (vertex = graphInfoCollector.getPrimaryRoots().get(0)).getDataObject()) != XPathStringLiteral.class) break;
                        VertexItem vertexItem = vertex.getItem(0);
                        String string = vertexItem.getText();
                        FromChild fromChild = from.getFromChild();
                        if (fromChild == null || !(fromChild instanceof Literal)) break;
                        ((Literal)fromChild).setContent(string);
                        from.removeEndpointReference();
                        from.removePart();
                        from.removePartnerLink();
                        from.removeProperty();
                        from.removeVariable();
                        bl = true;
                    }
                }
            }
            if (!bl) {
                this.populateContentHolder((ContentElement)from, graphInfoCollector, set, set2);
                from.removeEndpointReference();
                from.removeFromChild();
                from.removePart();
                from.removePartnerLink();
                from.removeProperty();
                from.removeVariable();
            }
        }
    }

    private void updateCopy(TreePath treePath, Copy copy) throws Exception {
        Object object;
        BpelModel bpelModel;
        Graph graph = this.getMapperModel().graphRequired(treePath);
        if (graph.isEmpty()) {
            BpelContainer bpelContainer = copy.getParent();
            if (bpelContainer != null) {
                bpelContainer.remove((BpelEntity)copy);
            }
            this.getMapperModel().deleteGraph(treePath);
            return;
        }
        HashSet<AbstractTypeCast> hashSet = new HashSet<AbstractTypeCast>();
        HashSet<Object> hashSet2 = new HashSet<XPathPseudoComp>();
        From from = copy.getFrom();
        if (from == null) {
            bpelModel = copy.getBpelModel();
            from = bpelModel.getBuilder().createFrom();
            copy.setFrom(from);
        }
        this.updateFrom(graph, hashSet, hashSet2, from);
        this.registerTypeCasts((ExtensibleElements)copy, hashSet, true);
        this.registerPseudoComps((ExtensibleElements)copy, hashSet2, true);
        bpelModel = copy.getTo();
        if (bpelModel == null) {
            object = copy.getBpelModel();
            bpelModel = object.getBuilder().createTo();
            copy.setTo((To)bpelModel);
        }
        hashSet = new HashSet();
        hashSet2 = new HashSet();
        object = this.collectTreeInfo(treePath, hashSet, hashSet2);
        XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)bpelModel);
        this.populateTo((To)bpelModel, xPathModel, (AbstractBpelModelUpdater.TreePathInfo)object, hashSet, hashSet2);
        this.registerTypeCasts((ExtensibleElements)copy, hashSet, false);
        this.registerPseudoComps((ExtensibleElements)copy, hashSet2, false);
    }

    private void updateAssign(TreePath treePath, Assign assign) throws Exception {
        Graph graph = this.getMapperModel().graphRequired(treePath);
        Object object = graph.getDataObject();
        if (object instanceof Copy) {
            this.updateCopy(treePath, (Copy)object);
        } else if (object == null) {
            BpelModel bpelModel = assign.getBpelModel();
            Copy copy = bpelModel.getBuilder().createCopy();
            assign.addAssignChild((AssignChild)copy);
            this.updateCopy(treePath, copy);
            graph.setDataObject((Object)copy);
        }
    }

    private void updateConditionHolder(TreePath treePath, ConditionHolder conditionHolder) {
        Object object;
        Graph graph = this.getMapperModel().graphRequired(treePath);
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        BooleanExpr booleanExpr = conditionHolder.getCondition();
        if (booleanExpr == null) {
            object = ((BpelEntity)conditionHolder).getBpelModel();
            booleanExpr = object.getBuilder().createCondition();
            conditionHolder.setCondition(booleanExpr);
            booleanExpr = conditionHolder.getCondition();
        }
        object = new HashSet();
        HashSet<XPathPseudoComp> hashSet = new HashSet<XPathPseudoComp>();
        this.populateContentHolder((ContentElement)booleanExpr, graphInfoCollector, (Set<AbstractTypeCast>)object, hashSet);
        ExtensibleElements extensibleElements = (ExtensibleElements)conditionHolder;
        this.registerTypeCasts(extensibleElements, (Collection<AbstractTypeCast>)object, true);
        this.registerPseudoComps(extensibleElements, hashSet, true);
    }

    private void updateTimeEventHolder(TreePath treePath, TimeEventHolder timeEventHolder) {
        HashSet<XPathPseudoComp> hashSet;
        Object object;
        Graph graph = this.getMapperModel().graphRequired(treePath);
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        TimeEvent timeEvent = timeEventHolder.getTimeEvent();
        if (timeEvent == null) {
            object = timeEventHolder.getBpelModel();
            hashSet = MapperSwingTreeModel.getDataObject(treePath);
            if (DateValueTreeModel.DEADLINE_CONDITION.equals(hashSet)) {
                timeEvent = object.getBuilder().createUntil();
            } else if (DateValueTreeModel.DURATION_CONDITION.equals(hashSet)) {
                timeEvent = object.getBuilder().createFor();
            } else {
                return;
            }
            timeEventHolder.setTimeEvent(timeEvent);
            timeEvent = timeEventHolder.getTimeEvent();
        }
        object = new HashSet();
        hashSet = new HashSet<XPathPseudoComp>();
        this.populateContentHolder((ContentElement)timeEvent, graphInfoCollector, (Set<AbstractTypeCast>)object, hashSet);
        this.registerTypeCasts((ExtensibleElements)timeEventHolder, (Collection<AbstractTypeCast>)object, true);
        this.registerPseudoComps((ExtensibleElements)timeEventHolder, hashSet, true);
    }

    private void updateForEach(TreePath treePath, ForEach forEach) {
        Branches branches;
        Object object;
        Graph graph = this.getMapperModel().graphRequired(treePath);
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        BpelModel bpelModel = forEach.getBpelModel();
        Object object2 = MapperSwingTreeModel.getDataObject(treePath);
        StartCounterValue startCounterValue = null;
        if (ForEachConditionsTreeModel.START_VALUE.equals(object2)) {
            object = forEach.getStartCounterValue();
            if (object == null) {
                object = bpelModel.getBuilder().createStartCounterValue();
                forEach.setStartCounterValue(object);
                object = forEach.getStartCounterValue();
            }
            startCounterValue = object;
        } else if (ForEachConditionsTreeModel.FINAL_VALUE.equals(object2)) {
            object = forEach.getFinalCounterValue();
            if (object == null) {
                object = bpelModel.getBuilder().createFinalCounterValue();
                forEach.setFinalCounterValue((FinalCounterValue)object);
                object = forEach.getFinalCounterValue();
            }
            startCounterValue = object;
        } else if (ForEachConditionsTreeModel.COMPLETION_CONDITION.equals(object2)) {
            object = forEach.getCompletionCondition();
            if (object == null) {
                object = bpelModel.getBuilder().createCompletionCondition();
                forEach.setCompletionCondition((CompletionCondition)object);
                object = forEach.getCompletionCondition();
            }
            if ((branches = object.getBranches()) == null) {
                branches = bpelModel.getBuilder().createBranches();
                object.setBranches(branches);
                branches = object.getBranches();
            }
            startCounterValue = branches;
        } else {
            return;
        }
        object = new HashSet();
        branches = new HashSet();
        this.populateContentHolder((ContentElement)startCounterValue, graphInfoCollector, (Set<AbstractTypeCast>)object, (Set<XPathPseudoComp>)branches);
        this.registerTypeCasts((ExtensibleElements)forEach, (Collection<AbstractTypeCast>)object, true);
        this.registerPseudoComps((ExtensibleElements)forEach, (Collection<XPathPseudoComp>)branches, true);
    }

    private From populateFrom(From from, XPathModel xPathModel, AbstractBpelModelUpdater.TreePathInfo treePathInfo, Set<AbstractTypeCast> set, Set<XPathPseudoComp> set2) {
        FromProcessor.FromForm fromForm = this.calculateCopyFromForm(treePathInfo);
        switch (fromForm) {
            case VAR: {
                BpelReference bpelReference = from.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                from.setVariable(bpelReference);
                from.removePart();
                from.removeFromChild();
                from.removePartnerLink();
                from.removeEndpointReference();
                from.removeProperty();
                try {
                    from.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_PART: {
                BpelReference bpelReference = from.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                from.setVariable(bpelReference);
                WSDLReference wSDLReference = from.createWSDLReference((ReferenceableWSDLComponent)treePathInfo.part, Part.class);
                from.setPart(wSDLReference);
                from.removeFromChild();
                from.removePartnerLink();
                from.removeEndpointReference();
                from.removeProperty();
                try {
                    from.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_QUERY: {
                BpelReference bpelReference = from.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                from.setVariable(bpelReference);
                SchemaComponent schemaComponent = EditorUtil.getVariableSchemaType((AbstractVariableDeclaration)treePathInfo.varDecl);
                assert (schemaComponent != null);
                SchemaModelsStack schemaModelsStack = new SchemaModelsStack();
                schemaModelsStack.appendSchemaComponent(schemaComponent);
                this.populateFromQuery(from, xPathModel, treePathInfo, set, set2, schemaModelsStack);
                from.removePart();
                from.removePartnerLink();
                from.removeEndpointReference();
                from.removeProperty();
                try {
                    from.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_PART_QUERY: {
                BpelReference bpelReference = from.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                from.setVariable(bpelReference);
                WSDLReference wSDLReference = from.createWSDLReference((ReferenceableWSDLComponent)treePathInfo.part, Part.class);
                from.setPart(wSDLReference);
                SchemaComponent schemaComponent = EditorUtil.getPartType((Part)treePathInfo.part);
                assert (schemaComponent != null);
                SchemaModelsStack schemaModelsStack = new SchemaModelsStack();
                schemaModelsStack.appendSchemaComponent(schemaComponent);
                this.populateFromQuery(from, xPathModel, treePathInfo, set, set2, schemaModelsStack);
                from.removePartnerLink();
                from.removeEndpointReference();
                from.removeProperty();
                try {
                    from.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case PARTNER_LINK: {
                BpelReference bpelReference = from.createReference((BpelReferenceable)treePathInfo.pLink, PartnerLink.class);
                from.setPartnerLink(bpelReference);
                if (treePathInfo.roles != null) {
                    from.setEndpointReference(treePathInfo.roles);
                }
                from.removeVariable();
                from.removePart();
                from.removeFromChild();
                from.removeProperty();
                try {
                    from.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case EXPRESSION: {
                XPathExpression xPathExpression = this.createVariableXPath(xPathModel, treePathInfo, set, set2);
                if (xPathExpression != null) {
                    try {
                        from.setContent(xPathExpression.getExpressionString());
                    }
                    catch (VetoException vetoException) {
                        // empty catch block
                    }
                }
                from.removeVariable();
                from.removePart();
                from.removeFromChild();
                from.removePartnerLink();
                from.removeEndpointReference();
                from.removeProperty();
                break;
            }
        }
        return from;
    }

    private void populateFromQuery(From from, XPathModel xPathModel, AbstractBpelModelUpdater.TreePathInfo treePathInfo, Set<AbstractTypeCast> set, Set<XPathPseudoComp> set2, SchemaModelsStack schemaModelsStack) {
        XPathLocationPath xPathLocationPath;
        List<LocationStep> list = PathConverter.constructLSteps(xPathModel, treePathInfo.schemaCompList, set, set2, schemaModelsStack);
        if (list != null && !list.isEmpty() && (xPathLocationPath = xPathModel.getFactory().newXPathLocationPath(list.toArray(new LocationStep[list.size()]))) != null) {
            xPathModel.fillInStubs((XPathExpression)xPathLocationPath);
            BpelModel bpelModel = this.getDesignContext().getBpelModel();
            FromChild fromChild = from.getFromChild();
            try {
                if (fromChild != null && fromChild instanceof Query) {
                    Query query = (Query)fromChild;
                    query.setContent(xPathLocationPath.getExpressionString());
                } else {
                    Query query = bpelModel.getBuilder().createQuery();
                    query.setContent(xPathLocationPath.getExpressionString());
                    from.setFromChild((FromChild)query);
                }
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    private To populateTo(To to, XPathModel xPathModel, AbstractBpelModelUpdater.TreePathInfo treePathInfo, Set<AbstractTypeCast> set, Set<XPathPseudoComp> set2) {
        CopyToProcessor.CopyToForm copyToForm = this.calculateCopyToForm(treePathInfo);
        switch (copyToForm) {
            case VAR: {
                BpelReference bpelReference = to.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                to.setVariable(bpelReference);
                to.removePart();
                to.removeQuery();
                to.removePartnerLink();
                to.removeProperty();
                try {
                    to.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_PART: {
                BpelReference bpelReference = to.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                to.setVariable(bpelReference);
                WSDLReference wSDLReference = to.createWSDLReference((ReferenceableWSDLComponent)treePathInfo.part, Part.class);
                to.setPart(wSDLReference);
                to.removeQuery();
                to.removePartnerLink();
                to.removeProperty();
                try {
                    to.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_QUERY: {
                BpelReference bpelReference = to.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                to.setVariable(bpelReference);
                SchemaComponent schemaComponent = EditorUtil.getVariableSchemaType((AbstractVariableDeclaration)treePathInfo.varDecl);
                assert (schemaComponent != null);
                SchemaModelsStack schemaModelsStack = new SchemaModelsStack();
                schemaModelsStack.appendSchemaComponent(schemaComponent);
                this.populateToQuery(to, xPathModel, treePathInfo, set, set2, schemaModelsStack);
                to.removePart();
                to.removePartnerLink();
                to.removeProperty();
                try {
                    to.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case VAR_PART_QUERY: {
                BpelReference bpelReference = to.createReference((BpelReferenceable)treePathInfo.varDecl, VariableDeclaration.class);
                to.setVariable(bpelReference);
                WSDLReference wSDLReference = to.createWSDLReference((ReferenceableWSDLComponent)treePathInfo.part, Part.class);
                to.setPart(wSDLReference);
                SchemaComponent schemaComponent = EditorUtil.getPartType((Part)treePathInfo.part);
                assert (schemaComponent != null);
                SchemaModelsStack schemaModelsStack = new SchemaModelsStack();
                schemaModelsStack.appendSchemaComponent(schemaComponent);
                this.populateToQuery(to, xPathModel, treePathInfo, set, set2, schemaModelsStack);
                to.removePartnerLink();
                to.removeProperty();
                try {
                    to.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case PARTNER_LINK: {
                BpelReference bpelReference = to.createReference((BpelReferenceable)treePathInfo.pLink, PartnerLink.class);
                to.setPartnerLink(bpelReference);
                to.removeVariable();
                to.removePart();
                to.removeQuery();
                to.removeProperty();
                try {
                    to.setContent(null);
                }
                catch (VetoException vetoException) {}
                break;
            }
            case EXPRESSION: {
                XPathExpression xPathExpression = this.createVariableXPath(xPathModel, treePathInfo, set, set2);
                try {
                    to.setContent(xPathExpression.getExpressionString());
                }
                catch (VetoException vetoException) {
                    // empty catch block
                }
                to.removeVariable();
                to.removePart();
                to.removeQuery();
                to.removePartnerLink();
                to.removeProperty();
                break;
            }
        }
        return to;
    }

    private void populateToQuery(To to, XPathModel xPathModel, AbstractBpelModelUpdater.TreePathInfo treePathInfo, Set<AbstractTypeCast> set, Set<XPathPseudoComp> set2, SchemaModelsStack schemaModelsStack) {
        XPathLocationPath xPathLocationPath;
        List<LocationStep> list = PathConverter.constructLSteps(xPathModel, treePathInfo.schemaCompList, set, set2, schemaModelsStack);
        if (list != null && !list.isEmpty() && (xPathLocationPath = xPathModel.getFactory().newXPathLocationPath(list.toArray(new LocationStep[list.size()]))) != null) {
            xPathModel.fillInStubs((XPathExpression)xPathLocationPath);
            BpelModel bpelModel = this.getDesignContext().getBpelModel();
            Query query = to.getQuery();
            try {
                if (query != null) {
                    query.setContent(xPathLocationPath.getExpressionString());
                } else {
                    query = bpelModel.getBuilder().createQuery();
                    query.setContent(xPathLocationPath.getExpressionString());
                    to.setQuery(query);
                }
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    private FromProcessor.FromForm calculateCopyFromForm(AbstractBpelModelUpdater.TreePathInfo treePathInfo) {
        if (treePathInfo.varDecl != null) {
            if (treePathInfo.part == null && treePathInfo.schemaCompList.isEmpty()) {
                return FromProcessor.FromForm.VAR;
            }
            if (treePathInfo.part != null && treePathInfo.schemaCompList.isEmpty()) {
                return FromProcessor.FromForm.VAR_PART;
            }
            if (treePathInfo.part == null && !treePathInfo.schemaCompList.isEmpty()) {
                return FromProcessor.FromForm.EXPRESSION;
            }
            if (treePathInfo.part != null && !treePathInfo.schemaCompList.isEmpty()) {
                return FromProcessor.FromForm.EXPRESSION;
            }
        } else if (treePathInfo.pLink != null) {
            return FromProcessor.FromForm.PARTNER_LINK;
        }
        return FromProcessor.FromForm.UNKNOWN;
    }

    private CopyToProcessor.CopyToForm calculateCopyToForm(AbstractBpelModelUpdater.TreePathInfo treePathInfo) {
        if (treePathInfo.varDecl != null) {
            if (treePathInfo.part == null && treePathInfo.schemaCompList.isEmpty()) {
                return CopyToProcessor.CopyToForm.VAR;
            }
            if (treePathInfo.part != null && treePathInfo.schemaCompList.isEmpty()) {
                return CopyToProcessor.CopyToForm.VAR_PART;
            }
            if (treePathInfo.part == null && !treePathInfo.schemaCompList.isEmpty()) {
                return CopyToProcessor.CopyToForm.EXPRESSION;
            }
            if (treePathInfo.part != null && !treePathInfo.schemaCompList.isEmpty()) {
                return CopyToProcessor.CopyToForm.EXPRESSION;
            }
        } else if (treePathInfo.pLink != null) {
            return CopyToProcessor.CopyToForm.PARTNER_LINK;
        }
        return CopyToProcessor.CopyToForm.UNKNOWN;
    }
}

