/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import org.netbeans.modules.bpel.editors.api.nodes.FactoryAccess;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContextImpl;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextFactory;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class BpelDesignContextFactory
implements DesignContextFactory {
    private static final BpelDesignContextFactory INSTANCE = new BpelDesignContextFactory();
    private final DesignContextFactory.ContextCreator[] contextCreators = new DesignContextFactory.ContextCreator[]{new AssignContextCreator(), new BooleanConditionContextCreator(), new TimeConditionContextCreator(), new ForEachContextCreator(), new DesignContextFactory.EmptyContextCreator()};

    private BpelDesignContextFactory() {
    }

    public static BpelDesignContextFactory getInstance() {
        return INSTANCE;
    }

    public boolean isMappableEntity(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return false;
        }
        boolean bl = false;
        assert (this.contextCreators != null);
        for (DesignContextFactory.ContextCreator contextCreator : this.contextCreators) {
            if (!contextCreator.accepted(bpelEntity) || contextCreator instanceof DesignContextFactory.EmptyContextCreator) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public BpelDesignContext createBpelDesignContext(BpelEntity bpelEntity, Node node, Lookup lookup) {
        if (bpelEntity == null || node == null || lookup == null) {
            return null;
        }
        BpelDesignContext bpelDesignContext = null;
        assert (this.contextCreators != null);
        for (DesignContextFactory.ContextCreator contextCreator : this.contextCreators) {
            if (!contextCreator.accepted(bpelEntity)) continue;
            bpelDesignContext = contextCreator.create(bpelEntity, node, lookup);
            break;
        }
        return bpelDesignContext;
    }

    public BpelDesignContext getActivatedContext(BpelModel bpelModel) {
        Object object;
        if (bpelModel == null) {
            return null;
        }
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        BpelEntity bpelEntity = null;
        if (nodeArray[0] instanceof InstanceRef) {
            object = ((InstanceRef)nodeArray[0]).getReference();
            if (object instanceof BpelEntity && bpelModel.equals(((BpelEntity)object).getBpelModel())) {
                bpelEntity = (BpelEntity)object;
            }
        } else {
            return null;
        }
        object = nodeArray[0].getLookup();
        BpelDesignContext bpelDesignContext = this.createBpelDesignContext(bpelEntity, nodeArray[0], (Lookup)object);
        return bpelDesignContext;
    }

    public BpelDesignContext getProcessContext(BpelModel bpelModel, Lookup lookup) {
        if (bpelModel == null) {
            return null;
        }
        Process process = bpelModel.getProcess();
        Node node = null;
        if (process != null) {
            node = FactoryAccess.getPropertyNodeFactory().createNode((Object)NodeType.PROCESS, (Object)process, lookup);
        }
        BpelDesignContext bpelDesignContext = this.createBpelDesignContext((BpelEntity)process, node, lookup);
        return bpelDesignContext;
    }

    private class ForEachContextCreator
    implements DesignContextFactory.ContextCreator {
        private ForEachContextCreator() {
        }

        public boolean accepted(BpelEntity bpelEntity) {
            BpelContainer bpelContainer;
            BpelContainer bpelContainer2;
            if (bpelEntity == null) {
                return false;
            }
            boolean bl = false;
            Class clazz = bpelEntity.getElementType();
            if (clazz == ForEach.class) {
                bl = true;
            } else if (clazz == StartCounterValue.class || clazz == FinalCounterValue.class || clazz == CompletionCondition.class) {
                BpelContainer bpelContainer3 = bpelEntity.getParent();
                if (bpelContainer3 != null && bpelContainer3.getElementType() == ForEach.class) {
                    bl = true;
                }
            } else if (clazz == Branches.class && (bpelContainer2 = bpelEntity.getParent()) != null && bpelContainer2.getElementType() == CompletionCondition.class && (bpelContainer = bpelContainer2.getParent()) != null && bpelContainer.getElementType() == ForEach.class) {
                bl = true;
            }
            return bl;
        }

        public BpelDesignContext create(BpelEntity bpelEntity, Node node, Lookup lookup) {
            BpelContainer bpelContainer;
            BpelContainer bpelContainer2;
            if (!this.accepted(bpelEntity)) {
                return null;
            }
            BpelDesignContextImpl bpelDesignContextImpl = null;
            Class clazz = bpelEntity.getElementType();
            if (clazz == ForEach.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, node, lookup);
            } else if (clazz == StartCounterValue.class || clazz == FinalCounterValue.class || clazz == CompletionCondition.class) {
                BpelContainer bpelContainer3 = bpelEntity.getParent();
                if (bpelContainer3 != null && bpelContainer3.getElementType() == ForEach.class) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer3, bpelEntity, bpelEntity, node, lookup);
                }
            } else if (clazz == Branches.class && (bpelContainer2 = bpelEntity.getParent()) != null && bpelContainer2.getElementType() == CompletionCondition.class && (bpelContainer = bpelContainer2.getParent()) != null && bpelContainer.getElementType() == ForEach.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, (BpelEntity)bpelContainer2, bpelEntity, node, lookup);
            }
            return bpelDesignContextImpl;
        }
    }

    private class BooleanConditionContextCreator
    implements DesignContextFactory.ContextCreator {
        private BooleanConditionContextCreator() {
        }

        public boolean accepted(BpelEntity bpelEntity) {
            BpelContainer bpelContainer;
            if (bpelEntity == null) {
                return false;
            }
            boolean bl = false;
            Class clazz = bpelEntity.getElementType();
            if (clazz == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class) {
                bl = true;
            } else if (clazz == BooleanExpr.class && ((clazz = (bpelContainer = bpelEntity.getParent()).getElementType()) == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class)) {
                bl = true;
            }
            return bl;
        }

        public BpelDesignContext create(BpelEntity bpelEntity, Node node, Lookup lookup) {
            BpelContainer bpelContainer;
            if (!this.accepted(bpelEntity)) {
                return null;
            }
            BpelDesignContextImpl bpelDesignContextImpl = null;
            Class clazz = bpelEntity.getElementType();
            if (clazz == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, node, lookup);
            } else if (clazz == BooleanExpr.class && ((clazz = (bpelContainer = bpelEntity.getParent()).getElementType()) == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class)) {
                bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, (BpelEntity)bpelContainer, bpelEntity, node, lookup);
            }
            return bpelDesignContextImpl;
        }
    }

    private class TimeConditionContextCreator
    implements DesignContextFactory.ContextCreator {
        private TimeConditionContextCreator() {
        }

        public boolean accepted(BpelEntity bpelEntity) {
            BpelContainer bpelContainer;
            if (bpelEntity == null) {
                return false;
            }
            boolean bl = false;
            Class clazz = bpelEntity.getElementType();
            if (clazz == Wait.class || clazz == OnAlarmPick.class || clazz == OnAlarmEvent.class) {
                bl = true;
            } else if (!(clazz != For.class && clazz != RepeatEvery.class && clazz != DeadlineExpression.class || (clazz = (bpelContainer = bpelEntity.getParent()).getElementType()) != Wait.class && clazz != OnAlarmPick.class && clazz != OnAlarmEvent.class)) {
                bl = true;
            }
            return bl;
        }

        public BpelDesignContext create(BpelEntity bpelEntity, Node node, Lookup lookup) {
            BpelContainer bpelContainer;
            if (!this.accepted(bpelEntity)) {
                return null;
            }
            BpelDesignContextImpl bpelDesignContextImpl = null;
            Class clazz = bpelEntity.getElementType();
            if (clazz == Wait.class || clazz == OnAlarmPick.class || clazz == OnAlarmEvent.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, node, lookup);
            } else if (!(clazz != For.class && clazz != RepeatEvery.class && clazz != DeadlineExpression.class || (clazz = (bpelContainer = bpelEntity.getParent()).getElementType()) != Wait.class && clazz != OnAlarmPick.class && clazz != OnAlarmEvent.class)) {
                bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, (BpelEntity)bpelContainer, bpelEntity, node, lookup);
            }
            return bpelDesignContextImpl;
        }
    }

    private class AssignContextCreator
    implements DesignContextFactory.ContextCreator {
        private AssignContextCreator() {
        }

        public boolean accepted(BpelEntity bpelEntity) {
            BpelContainer bpelContainer;
            BpelContainer bpelContainer2;
            if (bpelEntity == null) {
                return false;
            }
            boolean bl = false;
            Class clazz = bpelEntity.getElementType();
            if (clazz == Assign.class) {
                bl = true;
            } else if (clazz == Copy.class) {
                BpelContainer bpelContainer3 = bpelEntity.getParent();
                if (bpelContainer3 != null && bpelContainer3.getElementType() == Assign.class) {
                    bl = true;
                }
            } else if (clazz == From.class || clazz == To.class) {
                BpelContainer bpelContainer4;
                BpelContainer bpelContainer5 = bpelEntity.getParent();
                if (bpelContainer5 != null && bpelContainer5.getElementType() == Copy.class && (bpelContainer4 = bpelContainer5.getParent()) != null && bpelContainer4.getElementType() == Assign.class) {
                    bl = true;
                }
            } else if (clazz == Query.class) {
                BpelContainer bpelContainer6;
                BpelContainer bpelContainer7 = bpelEntity.getParent();
                if (bpelContainer7 != null && ((clazz = bpelContainer7.getElementType()) == From.class || clazz == To.class) && (bpelContainer7 = bpelContainer7.getParent()) != null && bpelContainer7.getElementType() == Copy.class && (bpelContainer6 = bpelContainer7.getParent()) != null && bpelContainer6.getElementType() == Assign.class) {
                    bl = true;
                }
            } else if (clazz == Literal.class && (bpelContainer2 = bpelEntity.getParent()) != null && bpelContainer2.getElementType() == From.class && (bpelContainer2 = bpelContainer2.getParent()) != null && bpelContainer2.getElementType() == Copy.class && (bpelContainer = bpelContainer2.getParent()) != null && bpelContainer.getElementType() == Assign.class) {
                bl = true;
            }
            return bl;
        }

        public BpelDesignContext create(BpelEntity bpelEntity, Node node, Lookup lookup) {
            BpelContainer bpelContainer;
            BpelContainer bpelContainer2;
            if (!this.accepted(bpelEntity)) {
                return null;
            }
            BpelDesignContextImpl bpelDesignContextImpl = null;
            Class clazz = bpelEntity.getElementType();
            if (clazz == Assign.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, bpelEntity, bpelEntity, node, lookup);
            } else if (clazz == Copy.class) {
                BpelContainer bpelContainer3 = bpelEntity.getParent();
                if (bpelContainer3 != null && bpelContainer3.getElementType() == Assign.class) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer3, bpelEntity, bpelEntity, node, lookup);
                }
            } else if (clazz == From.class || clazz == To.class) {
                BpelContainer bpelContainer4;
                BpelContainer bpelContainer5 = bpelEntity.getParent();
                if (bpelContainer5 != null && bpelContainer5.getElementType() == Copy.class && (bpelContainer4 = bpelContainer5.getParent()) != null && bpelContainer4.getElementType() == Assign.class) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer4, (BpelEntity)bpelContainer5, bpelEntity, node, lookup);
                }
            } else if (clazz == Query.class) {
                BpelContainer bpelContainer6;
                BpelContainer bpelContainer7 = bpelEntity.getParent();
                if (bpelContainer7 != null && ((clazz = bpelContainer7.getElementType()) == From.class || clazz == To.class) && (bpelContainer7 = bpelContainer7.getParent()) != null && bpelContainer7.getElementType() == Copy.class && (bpelContainer6 = bpelContainer7.getParent()) != null && bpelContainer6.getElementType() == Assign.class) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer6, (BpelEntity)bpelContainer7, bpelEntity, node, lookup);
                }
            } else if (clazz == Literal.class && (bpelContainer2 = bpelEntity.getParent()) != null && bpelContainer2.getElementType() == From.class && (bpelContainer2 = bpelContainer2.getParent()) != null && bpelContainer2.getElementType() == Copy.class && (bpelContainer = bpelContainer2.getParent()) != null && bpelContainer.getElementType() == Assign.class) {
                bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, (BpelEntity)bpelContainer2, bpelEntity, node, lookup);
            }
            return bpelDesignContextImpl;
        }
    }
}

