/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModelFactory;
import org.netbeans.modules.bpel.mapper.model.GraphExpandProcessor;
import org.netbeans.modules.bpel.mapper.model.MapperTcContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContextFactory;
import org.netbeans.modules.bpel.mapper.multiview.BpelModelSynchListener;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextUtil;
import org.netbeans.modules.bpel.mapper.multiview.MapperMultiviewElement;
import org.netbeans.modules.bpel.mapper.multiview.MapperStateManager;
import org.netbeans.modules.bpel.mapper.multiview.ShowMapperCookie;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DesignContextControllerImpl2
implements DesignContextController,
PropertyChangeListener {
    private BpelDesignContext mContext;
    private MapperTcContext mMapperTcContext;
    private BpelModelSynchListener mBpelModelSynchListener;
    private BpelModel myBpelModel;
    private transient boolean isMapperShown;
    private BpelDesignContext mNewContext;
    private MapperStateManager myMapperStateManager;
    private static final int ACTION_NODE_CHANGE_TASK_DELAY = 150;
    private transient RequestProcessor.Task myPreviousTask;
    private int myDelay = 150;
    private WeakReference<Object> mBpelModelUpdateSourceRef;

    public DesignContextControllerImpl2(TopComponent topComponent) {
        assert (topComponent != null);
        assert (topComponent instanceof MapperTcContext);
        this.mMapperTcContext = (MapperTcContext)topComponent;
        this.myBpelModel = (BpelModel)topComponent.getLookup().lookup(BpelModel.class);
        assert (this.myBpelModel != null);
        this.mBpelModelSynchListener = new BpelModelSynchListener(this);
        this.mBpelModelSynchListener.register(this.myBpelModel);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.initContext();
    }

    public void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.mBpelModelSynchListener.unregisterAll();
        this.myBpelModel = null;
        this.mMapperTcContext = null;
    }

    public synchronized void setBpelModelUpdateSource(Object object) {
        this.mBpelModelUpdateSourceRef = new WeakReference<Object>(object);
    }

    public synchronized BpelDesignContext getContext() {
        return this.mContext;
    }

    public synchronized void setContext(BpelDesignContext bpelDesignContext) {
        assert (EventQueue.isDispatchThread());
        this.mNewContext = bpelDesignContext;
        boolean bl = DesignContextUtil.isValidContext(this.mContext);
        if (bpelDesignContext == null && bl) {
            return;
        }
        if (bpelDesignContext == null && !bl) {
            if (this.isMapperShown) {
                this.showNotValidContext(this.mContext);
            }
            return;
        }
        BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
        if (bpelEntity != null && !this.myBpelModel.equals(bpelEntity.getBpelModel()) || bpelEntity == null) {
            return;
        }
        if (bpelDesignContext.equals(this.mContext)) {
            return;
        }
        this.setActivatedNodes(bpelDesignContext == null ? null : bpelDesignContext.getActivatedNode());
        if (this.isMapperShown) {
            this.setContextImpl();
        }
    }

    public void reloadMapper(EventObject eventObject) {
        if (eventObject.getSource() == this.getBpelModelUpdateSource()) {
            return;
        }
        if (this.myPreviousTask != null) {
            this.myPreviousTask.cancel();
        }
        if (this.myPreviousTask != null && !this.myPreviousTask.isFinished() && RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.myPreviousTask.waitFinished();
            this.myPreviousTask = null;
        }
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DesignContextControllerImpl2.this.performReloadMapperInAwt();
                }
            });
        } else {
            this.performReloadMapperInAwt();
        }
    }

    synchronized void performReloadMapperInAwt() {
        assert (EventQueue.isDispatchThread());
        if (!DesignContextUtil.isValidContext(this.mContext)) {
            this.setDelay(0);
            this.updateContext(-1);
            return;
        }
        if (this.isMapperShown) {
            this.reloadMapperImpl();
        }
    }

    private void setDelay(int n) {
        this.myDelay = n;
    }

    private int getDelay() {
        return this.myDelay;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("activatedNodes")) {
            return;
        }
        this.updateContext();
    }

    public void showMapper() {
        Mapper mapper;
        assert (EventQueue.isDispatchThread());
        this.isMapperShown = true;
        Mapper mapper2 = mapper = this.mMapperTcContext != null ? this.mMapperTcContext.getMapper() : null;
        if (mapper != null) {
            mapper.setVisible(true);
        }
        this.setContextImpl(true);
    }

    public void hideMapper() {
        Mapper mapper;
        assert (EventQueue.isDispatchThread());
        this.isMapperShown = false;
        Mapper mapper2 = mapper = this.mMapperTcContext != null ? this.mMapperTcContext.getMapper() : null;
        if (mapper != null) {
            mapper.setVisible(false);
        }
    }

    public MapperTcContext getMapperTcContext() {
        return this.mMapperTcContext;
    }

    private synchronized void initContext() {
        BpelDesignContext bpelDesignContext = BpelDesignContextFactory.getInstance().getActivatedContext(this.myBpelModel);
        if (bpelDesignContext == null && this.myBpelModel != null) {
            bpelDesignContext = BpelDesignContextFactory.getInstance().getProcessContext(this.myBpelModel, this.mMapperTcContext.getTopComponent().getLookup());
        }
        this.setContext(bpelDesignContext);
        this.myMapperStateManager = new MapperStateManager(this.mMapperTcContext);
    }

    private void updateContext(int n) {
        assert (EventQueue.isDispatchThread());
        if (n <= 0) {
            this.setDelay(150);
        }
        if (this.myPreviousTask != null) {
            this.myPreviousTask.cancel();
        }
        if (this.myPreviousTask != null && !this.myPreviousTask.isFinished() && RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.myPreviousTask.waitFinished();
            this.myPreviousTask = null;
        }
        if (n <= 0) {
            this.setContext(BpelDesignContextFactory.getInstance().getActivatedContext(this.myBpelModel));
        } else {
            this.myPreviousTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DesignContextControllerImpl2.this.setContext(BpelDesignContextFactory.getInstance().getActivatedContext(DesignContextControllerImpl2.this.myBpelModel));
                        }
                    });
                }
            }, n);
        }
    }

    private void updateContext() {
        this.updateContext(this.getDelay());
    }

    private void setContextImpl() {
        this.setContextImpl(false);
    }

    private void setContextImpl(final boolean bl) {
        if (this.mNewContext == null && bl) {
            this.reloadMapper(new EventObject(new Object()));
            return;
        }
        BpelDesignContext bpelDesignContext = this.mNewContext;
        if (bpelDesignContext == null) {
            return;
        }
        if (this.isModelInvalid()) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showModelIsInvalid();
            return;
        }
        BpelEntity bpelEntity = this.mContext != null ? this.mContext.getContextEntity() : null;
        BpelEntity bpelEntity2 = bpelDesignContext.getContextEntity();
        if (bpelEntity2 == null) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showUnsupportedEntity(bpelDesignContext);
            return;
        }
        if (bl || !bpelDesignContext.equals(this.mContext)) {
            if (bl || !bpelEntity2.equals(bpelEntity)) {
                bpelDesignContext.getValidationErrMsgBuffer().setLength(0);
                this.myMapperStateManager.storeOldEntityContext(this.mContext);
                MapperModel mapperModel = new BpelMapperModelFactory(this.mMapperTcContext, bpelDesignContext).constructModel();
                this.mContext = bpelDesignContext;
                this.setMapperModel(mapperModel);
                this.myMapperStateManager.restoreOldEntityContext(this.mContext);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GraphExpandProcessor.expandGraph(DesignContextControllerImpl2.this.mMapperTcContext, DesignContextControllerImpl2.this.mContext);
                    if (bl) {
                        DesignContextControllerImpl2.this.displayInvalidXPathExpressions(DesignContextControllerImpl2.this.mContext, true);
                    }
                }
            });
        }
    }

    private void reloadMapperImpl() {
        if (this.mContext == null) {
            MapperModel mapperModel;
            Mapper mapper;
            Mapper mapper2 = mapper = this.mMapperTcContext != null ? this.mMapperTcContext.getMapper() : null;
            if (mapper != null && (mapperModel = mapper.getModel()) == null) {
                this.showMapperIsEmpty();
            }
            return;
        }
        if (this.isModelInvalid()) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showModelIsInvalid();
            return;
        }
        MapperModel mapperModel = new BpelMapperModelFactory(this.mMapperTcContext, this.mContext).constructModel();
        this.myMapperStateManager.storeOldEntityContext(this.mContext);
        this.setMapperModel(mapperModel);
        this.myMapperStateManager.restoreOldEntityContext(this.mContext);
    }

    private synchronized Object getBpelModelUpdateSource() {
        if (this.mBpelModelUpdateSourceRef == null) {
            return this.mMapperTcContext.getMapper();
        }
        return this.mBpelModelUpdateSourceRef.get();
    }

    private void setActivatedNodes(Node node) {
        TopComponent topComponent;
        assert (EventQueue.isDispatchThread());
        if (this.mMapperTcContext != null && (topComponent = this.mMapperTcContext.getTopComponent()) != null) {
            if (node != null) {
                topComponent.setActivatedNodes(new Node[]{node});
            } else {
                topComponent.setActivatedNodes(new Node[0]);
            }
        }
    }

    private void setMapperModel(MapperModel mapperModel) {
        assert (mapperModel != null);
        this.mMapperTcContext.setMapperModel(mapperModel);
    }

    private void showModelIsInvalid() {
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_Invalid_BpelModel"));
    }

    private void showMapperIsEmpty() {
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_EmptyMapperContext"));
    }

    private void showUnsupportedEntity(BpelDesignContext bpelDesignContext) {
        assert (bpelDesignContext != null);
        String string = null;
        Node node = bpelDesignContext.getActivatedNode();
        String string2 = string = node != null ? node.getDisplayName() : null;
        if (string == null) {
            BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
            string = bpelEntity instanceof Nameable ? ((Nameable)bpelEntity).getName() : EditorUtil.getTagName((DocumentComponent)bpelEntity);
        }
        string = string == null ? "" : string;
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_EmptyMapper", (Object)string));
    }

    private void showNotValidContext(BpelDesignContext bpelDesignContext) {
        assert (bpelDesignContext != null);
        String string = null;
        Node node = bpelDesignContext.getActivatedNode();
        String string2 = string = node != null ? node.getDisplayName() : null;
        if (string == null) {
            BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
            string = bpelEntity instanceof Nameable ? ((Nameable)bpelEntity).getName() : EditorUtil.getTagName((DocumentComponent)bpelEntity);
        }
        string = string == null ? "" : string;
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_InValidMapperContext", (Object)string));
    }

    private void disableMapper(String string) {
        TopComponent topComponent = this.mMapperTcContext.getTopComponent();
        if (topComponent == null) {
            return;
        }
        ShowMapperCookie showMapperCookie = (ShowMapperCookie)topComponent.getLookup().lookup(ShowMapperCookie.class);
        if (showMapperCookie != null) {
            showMapperCookie.show(string);
        }
        this.mContext = null;
    }

    private boolean isModelInvalid() {
        BpelModel bpelModel = this.myBpelModel;
        if (bpelModel != null) {
            return bpelModel.getState().equals((Object)Model.State.NOT_WELL_FORMED);
        }
        return false;
    }

    public void processDataObject(Object object) {
        this.mBpelModelSynchListener.processDataObject(object);
    }

    private String displayInvalidXPathExpressions(BpelDesignContext bpelDesignContext, boolean bl) {
        if (bpelDesignContext == null) {
            return null;
        }
        BpelEntity bpelEntity = bpelDesignContext.getContextEntity();
        if (bpelEntity == null) {
            return null;
        }
        StringBuffer stringBuffer = bpelDesignContext.getValidationErrMsgBuffer();
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return null;
        }
        String string = stringBuffer.toString().trim();
        string = string.substring(0, string.lastIndexOf(",")) + ".";
        if (bl && string != null) {
            UserNotification.showMessage((String)(MessageFormat.format(NbBundle.getMessage(this.getClass(), (String)"LBL_Bpel_Mapper_Err_Msg_Wrong_XPathExpr_Title"), bpelEntity.getElementType().getSimpleName()) + " \n" + string));
        }
        return string;
    }

    public static void addErrMessage(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer == null || string == null || string2 == null) {
            return;
        }
        String string3 = NbBundle.getMessage(DesignContextControllerImpl2.class, (String)"LBL_Bpel_Mapper_Err_Msg_Wrong_XPathExpr_Data");
        String string4 = MessageFormat.format(string3, string2, string);
        stringBuffer.append(stringBuffer.length() > 0 ? " " + string4 : string4);
        stringBuffer.append(",\n");
    }
}

