/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.mapper.cast.TypeCast;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.predicates.SpecialStepManager;
import org.netbeans.modules.bpel.mapper.predicates.XPathPredicate;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.AbstractLocationPath;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.CastSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.VariableSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCast;
import org.netbeans.modules.xml.xpath.ext.spi.XPathVariable;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

public class PredicateFinderVisitor
extends XPathVisitorAdapter {
    private PredicateManager mPredManager;
    private SpecialStepManager mSStepManager;
    private XPathVariableReference mXPathVarReference;
    private XPathBpelVariable mXPathVariable;

    public PredicateFinderVisitor(PredicateManager predicateManager, SpecialStepManager specialStepManager) {
        this.mPredManager = predicateManager;
        this.mSStepManager = specialStepManager;
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        LocationPathProcessor locationPathProcessor = new LocationPathProcessor();
        locationPathProcessor.processLocationPath((AbstractLocationPath)xPathLocationPath);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        xPathExpression.accept((XPathVisitor)this);
        LocationPathProcessor locationPathProcessor = new LocationPathProcessor();
        locationPathProcessor.processLocationPath((AbstractLocationPath)xPathExpressionPath);
        this.mXPathVariable = null;
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        this.mXPathVarReference = xPathVariableReference;
    }

    public XPathBpelVariable getVariable() {
        if (this.mXPathVariable == null) {
            if (this.mXPathVarReference == null) {
                return null;
            }
            XPathVariable xPathVariable = this.mXPathVarReference.getVariable();
            if (xPathVariable != null && xPathVariable instanceof XPathBpelVariable) {
                this.mXPathVariable = (XPathBpelVariable)xPathVariable;
            }
        }
        return this.mXPathVariable;
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreOperation);
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreFunction);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathExtensionFunction);
    }

    private class LocationPathProcessor {
        private transient LinkedList objLocationPath = new LinkedList();
        private boolean processingAborted = false;

        private LocationPathProcessor() {
        }

        public List getObjLocationPath() {
            if (this.processingAborted) {
                return null;
            }
            return this.objLocationPath;
        }

        public void processLocationPath(AbstractLocationPath abstractLocationPath) {
            this.processingAborted = false;
            if (!this.needProcessing(abstractLocationPath)) {
                return;
            }
            if (PredicateFinderVisitor.this.mXPathVarReference != null) {
                XPathSchemaContext xPathSchemaContext;
                AbstractVariableDeclaration abstractVariableDeclaration;
                XPathBpelVariable xPathBpelVariable;
                XPathSchemaContext xPathSchemaContext2 = PredicateFinderVisitor.this.mXPathVarReference.getSchemaContext();
                if (xPathSchemaContext2 instanceof VariableSchemaContext) {
                    xPathBpelVariable = PredicateFinderVisitor.this.getVariable();
                    abstractVariableDeclaration = xPathBpelVariable.getVarDecl();
                    this.objLocationPath.addFirst(abstractVariableDeclaration);
                    xPathSchemaContext = xPathBpelVariable.getPart();
                    if (xPathSchemaContext != null) {
                        this.objLocationPath.addFirst(xPathSchemaContext);
                    }
                } else if (xPathSchemaContext2 instanceof CastSchemaContext) {
                    xPathBpelVariable = (CastSchemaContext)xPathSchemaContext2;
                    abstractVariableDeclaration = PredicateFinderVisitor.this.getVariable();
                    xPathSchemaContext = abstractVariableDeclaration.getVarDecl();
                    Part part = abstractVariableDeclaration.getPart();
                    XPathCast xPathCast = xPathBpelVariable.getTypeCast();
                    TypeCast typeCast = new TypeCast(xPathCast);
                    if (part == null) {
                        assert (typeCast.getCastedObject() == xPathSchemaContext);
                        this.objLocationPath.addFirst(typeCast);
                    } else {
                        this.objLocationPath.addFirst(xPathSchemaContext);
                        if (part != null) {
                            assert (typeCast.getCastedObject() == part);
                            this.objLocationPath.addFirst(typeCast);
                        }
                    }
                } else {
                    assert (false) : "Incorrect schema contex!";
                    return;
                }
            }
            for (XPathSchemaContext xPathSchemaContext : abstractLocationPath.getSteps()) {
                if (this.processingAborted) continue;
                this.processStep((LocationStep)xPathSchemaContext);
            }
        }

        private boolean needProcessing(AbstractLocationPath abstractLocationPath) {
            for (LocationStep locationStep : abstractLocationPath.getSteps()) {
                XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
                if (xPathPredicateExpressionArray != null && xPathPredicateExpressionArray.length > 0) {
                    return true;
                }
                StepNodeTest stepNodeTest = locationStep.getNodeTest();
                if (!(stepNodeTest instanceof StepNodeTypeTest)) continue;
                return true;
            }
            return false;
        }

        private void processStep(LocationStep locationStep) {
            XPathSchemaContext xPathSchemaContext;
            StepNodeTest stepNodeTest = locationStep.getNodeTest();
            if (PredicateFinderVisitor.this.mSStepManager != null && stepNodeTest instanceof StepNodeTypeTest) {
                PredicateFinderVisitor.this.mSStepManager.addStep(this.objLocationPath, locationStep);
            }
            if ((xPathSchemaContext = locationStep.getSchemaContext()) == null) {
                this.processingAborted = true;
                return;
            }
            if (xPathSchemaContext instanceof CastSchemaContext) {
                CastSchemaContext castSchemaContext = (CastSchemaContext)xPathSchemaContext;
                TypeCast typeCast = new TypeCast(castSchemaContext.getTypeCast());
                this.objLocationPath.addFirst(typeCast);
                return;
            }
            SchemaCompHolder schemaCompHolder = XPathSchemaContext.Utilities.getSchemaCompHolder((XPathSchemaContext)xPathSchemaContext);
            if (schemaCompHolder == null) {
                this.processingAborted = true;
                return;
            }
            XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
            if (xPathPredicateExpressionArray == null || xPathPredicateExpressionArray.length == 0) {
                this.objLocationPath.addFirst(schemaCompHolder.getHeldComponent());
            } else {
                XPathPredicate xPathPredicate = new XPathPredicate(locationStep);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.addAll(this.objLocationPath);
                PredicateFinderVisitor.this.mPredManager.addPredicate(arrayList, (AbstractPredicate)xPathPredicate);
                this.objLocationPath.addFirst(xPathPredicate);
            }
        }
    }
}

