/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.MapperTreeNode;
import org.netbeans.modules.bpel.mapper.tree.TreeExpandedState;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.MapperModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightTreeExpandedState
implements TreeExpandedState {
    private Mapper myMapper;
    private ArrayList<ArrayList<TreeExpandedState.Step>> expanedNodes = new ArrayList();

    public RightTreeExpandedState(Mapper mapper) {
        this.myMapper = mapper;
    }

    @Override
    public void setMapper(Mapper mapper) {
        this.myMapper = mapper;
    }

    private RightTree getRightTree() {
        return this.myMapper != null ? this.myMapper.getRightTree() : null;
    }

    private MapperSwingTreeModel getTreeModel() {
        if (this.myMapper == null) {
            return null;
        }
        MapperModel mapperModel = this.myMapper.getModel();
        assert (mapperModel instanceof BpelMapperModel);
        return mapperModel != null ? ((BpelMapperModel)mapperModel).getRightTreeModel() : null;
    }

    @Override
    public void save() {
        if (this.myMapper == null) {
            return;
        }
        List list = this.myMapper.getExpandedPathes();
        if (list != null) {
            for (TreePath treePath : list) {
                ArrayList<TreeExpandedState.Step> arrayList = this.getStepsByTreePath(treePath);
                this.expanedNodes.add(arrayList);
            }
        }
    }

    @Override
    public void restore() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (ArrayList<TreeExpandedState.Step> arrayList2 : this.expanedNodes) {
            TreePath treePath = this.getTreePathbySteps(arrayList2);
            if (treePath == null) continue;
            arrayList.add(treePath);
        }
        if (arrayList.size() < 1) {
            return;
        }
        if (this.myMapper == null) {
            return;
        }
        this.myMapper.applyExpandedPathes(arrayList);
    }

    private ArrayList<TreeExpandedState.Step> getStepsByTreePath(TreePath treePath) {
        ArrayList<TreeExpandedState.Step> arrayList = new ArrayList<TreeExpandedState.Step>();
        MapperSwingTreeModel mapperSwingTreeModel = this.getTreeModel();
        if (mapperSwingTreeModel == null) {
            return arrayList;
        }
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            MapperTreeNode mapperTreeNode = (MapperTreeNode)treePath.getPathComponent(i);
            String string = mapperSwingTreeModel.getDisplayName(mapperTreeNode);
            Object object = null;
            if (i > 0) {
                object = treePath.getPathComponent(i - 1);
            }
            int n = 0;
            if (object != null && object instanceof MapperTreeNode) {
                List<MapperTreeNode> list = ((MapperTreeNode)object).getChildren();
                for (MapperTreeNode mapperTreeNode2 : list) {
                    String string2 = mapperSwingTreeModel.getDisplayName(mapperTreeNode2);
                    if (!string2.equals(string)) continue;
                    if (mapperTreeNode == mapperTreeNode2) break;
                    ++n;
                }
            }
            arrayList.add(new TreeExpandedState.Step(string, n));
        }
        return arrayList;
    }

    private TreePath getTreePathbySteps(ArrayList<TreeExpandedState.Step> arrayList) {
        MapperSwingTreeModel mapperSwingTreeModel = this.getTreeModel();
        if (mapperSwingTreeModel == null) {
            return null;
        }
        MapperTreeNode mapperTreeNode = (MapperTreeNode)mapperSwingTreeModel.getRoot();
        if (mapperTreeNode == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String string = mapperSwingTreeModel.getDisplayName(mapperTreeNode);
        if (!arrayList.get(0).getName().equals(string)) {
            return null;
        }
        TreePath treePath = new TreePath(mapperTreeNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            TreeExpandedState.Step step = arrayList.get(i);
            List<MapperTreeNode> list = mapperTreeNode.getChildren();
            if ((mapperTreeNode = this.getTreeNodeByStep(mapperSwingTreeModel, list, step)) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(mapperTreeNode);
        }
        return treePath;
    }

    private MapperTreeNode getTreeNodeByStep(MapperSwingTreeModel mapperSwingTreeModel, List<MapperTreeNode> list, TreeExpandedState.Step step) {
        if (mapperSwingTreeModel == null || list == null) {
            return null;
        }
        int n = 0;
        for (MapperTreeNode mapperTreeNode : list) {
            String string = mapperSwingTreeModel.getDisplayName(mapperTreeNode);
            if (!step.getName().equals(string)) continue;
            if (n == step.index) {
                return mapperTreeNode;
            }
            ++n;
        }
        return null;
    }
}

