/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class GdbMemoryWindow
extends TopComponent
implements ActionListener {
    private transient JComponent tree = null;
    private String name;
    private String view_name;
    private GdbDebugger debugger = null;
    private JMenuItem menuItemFollowSelectedPointer;
    private JMenuItem menuItemHideText;
    private JPopupMenu popup;
    private JRadioButtonMenuItem rbMenuItem;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel hp;
    private JPanel cp;
    private List previous_addrs;
    private List current_addrs;
    private PopupListener popupListener;
    private String memory_start;
    private String memory_length;
    private JTextField memory_length_jtf;
    private String[] memory_formats = new String[]{GdbMemoryWindow.getString("L_Hexadecimal"), GdbMemoryWindow.getString("l_Hexadecimal"), GdbMemoryWindow.getString("w_Hexadecimal"), GdbMemoryWindow.getString("l_Decimal"), GdbMemoryWindow.getString("l_Octal"), GdbMemoryWindow.getString("L_Float"), GdbMemoryWindow.getString("l_Float"), GdbMemoryWindow.getString("L_Instructions"), GdbMemoryWindow.getString("L_Characters"), GdbMemoryWindow.getString("L_WideCharacters")};
    private String[] short_memory_formats = new String[]{"lX", "X", "x", "D", "O", "F", "f", "i", "c", "w"};
    private JComboBox format_jcb;
    private int memory_format = 1;
    private boolean needInitData = true;
    private boolean dontShowText = true;
    private JComboBox cp_addressList;
    private String selected_text = null;
    private static ResourceBundle bundle;

    public GdbMemoryWindow() {
        this.name = GdbMemoryWindow.getString("TITLE_GdbMemoryWindow");
        this.view_name = GdbMemoryWindow.getString("TITLE_GdbMemoryView");
        super.setName(this.name);
    }

    public static TopComponent getDefault() {
        for (Mode mode : WindowManager.getDefault().getModes()) {
            TopComponent[] topComponentArray = mode.getTopComponents();
            int n = topComponentArray.length;
            for (int i = 0; i < n; ++i) {
                if (!topComponentArray[i].getClass().equals(GdbMemoryWindow.class)) continue;
                return topComponentArray[i];
            }
        }
        return new GdbMemoryWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.cp_addressList != null) {
            this.cp_addressList.requestFocus();
        }
    }

    protected void componentShowing() {
        super.componentShowing();
        this.needInitData = true;
        this.updateWindow();
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            // empty if block
        }
        super.componentClosed();
    }

    protected void connectToDebugger(GdbDebugger gdbDebugger) {
        this.debugger = gdbDebugger;
        if (gdbDebugger == null) {
            return;
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("comboBoxEdited")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.memory_start = (String)jComboBox.getSelectedItem();
        }
        this.showMemory();
    }

    private void showMemory() {
        String string = this.memory_start;
        boolean bl = false;
        for (int i = 0; i < this.cp_addressList.getItemCount(); ++i) {
            if (string.compareTo((String)this.cp_addressList.getItemAt(i)) != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.cp_addressList.addItem(string);
        }
        this.updateData(this.readData());
    }

    private String readData() {
        if (this.debugger == null) {
            return null;
        }
        this.memory_length = this.memory_length_jtf.getText();
        this.memory_format = this.format_jcb.getSelectedIndex();
        String string = null;
        return string;
    }

    private void initData() {
        this.updateData(this.readData());
    }

    public void updateData(String string) {
        int n;
        if (string == null) {
            return;
        }
        this.current_addrs.removeAll();
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length() && (n = string.indexOf(10, n3)) >= n3) {
            String string2 = string.substring(n3, n + 1);
            n3 = n;
            String string3 = null;
            String string4 = null;
            int n4 = 0;
            n = 0;
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == ' ') continue;
                if (n == 0) {
                    n = string2.indexOf(32, i);
                    if (n < i) break;
                    n4 = n - i;
                    string3 = string2.substring(i, n);
                    i = n;
                    continue;
                }
                n = string2.indexOf(10, i);
                if (n < i) break;
                string4 = string2.substring(i, n);
                string4 = this.align_memvalue(string4);
                break;
            }
            this.current_addrs.add("   " + string3 + "  " + string4 + "\n");
            ++n3;
            ++n2;
        }
        this.updateWindow();
    }

    private String align_memvalue(String string) {
        if (this.memory_format == 3 || this.memory_format == 4) {
            int n = string.length();
            int n2 = string.indexOf(58, 0);
            String string2 = "";
            if (n2 >= 0) {
                string2 = string.substring(0, ++n2);
            } else {
                n2 = 0;
            }
            for (int i = 0; i < 4; ++i) {
                char c;
                while (n2 < n && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                    string2 = string2 + ' ';
                    ++n2;
                }
                if (n <= n2) break;
                String string3 = "";
                int n3 = 0;
                int n4 = 12;
                if (this.memory_format == 3) {
                    if (string.charAt(n2) == '-') {
                        string3 = "-";
                        ++n2;
                    } else {
                        string3 = "+";
                    }
                    n3 = 1;
                    n4 = 11;
                }
                while (n2 < n && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    string3 = string3 + c;
                    ++n3;
                    ++n2;
                }
                if (n3 > n4) {
                    return string;
                }
                while (n3 < n4) {
                    string3 = " " + string3;
                    ++n3;
                }
                string2 = string2 + string3;
            }
            return string2;
        }
        return string;
    }

    private void updateWindow() {
        int n;
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.previous_addrs = new List();
            this.current_addrs = new List();
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font font = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
            this.hp = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("        " + GdbMemoryWindow.getString("LBL_HP_Name") + "                       ");
            JLabel jLabel2 = new JLabel("                                " + GdbMemoryWindow.getString("LBL_HP_Value"));
            jLabel.setToolTipText(GdbMemoryWindow.getString("TTT_HP_Name"));
            jLabel2.setToolTipText(GdbMemoryWindow.getString("TTT_HP_Value"));
            this.hp.add((Component)jLabel, "West");
            this.hp.add((Component)jLabel2, "Center");
            this.memory_start = "main";
            this.memory_length = "80";
            this.memory_format = 1;
            this.cp = new JPanel(new FlowLayout());
            this.cp.setToolTipText(GdbMemoryWindow.getString("TTT_Control_Panel"));
            this.cp_addressList = new JComboBox();
            this.cp_addressList.addItem(this.memory_start);
            this.cp_addressList.setEditable(true);
            this.cp_addressList.addActionListener(this);
            JLabel jLabel3 = new JLabel(GdbMemoryWindow.getString("LBL_CP_Text1"));
            jLabel3.setToolTipText(GdbMemoryWindow.getString("TTT_CP_Text1"));
            JLabel jLabel4 = new JLabel(GdbMemoryWindow.getString("LBL_CP_Text2"));
            jLabel4.setToolTipText(GdbMemoryWindow.getString("TTT_CP_Text2"));
            this.memory_length_jtf = new JTextField(6);
            this.memory_length_jtf.setText(this.memory_length);
            this.memory_length_jtf.addActionListener(this);
            JLabel jLabel5 = new JLabel(GdbMemoryWindow.getString("LBL_CP_Text3"));
            jLabel5.setToolTipText(GdbMemoryWindow.getString("TTT_CP_Text3"));
            this.format_jcb = new JComboBox<String>(this.memory_formats);
            this.format_jcb.setSelectedIndex(this.memory_format);
            this.format_jcb.addActionListener(this);
            this.cp.add(jLabel3);
            this.cp.add(this.cp_addressList);
            this.cp.add(jLabel4);
            this.cp.add(this.memory_length_jtf);
            this.cp.add(jLabel5);
            this.cp.add(this.format_jcb);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.cp, "South");
            JLabel jLabel6 = new JLabel(GdbMemoryWindow.getString("LBL_GdbMemoryView"));
            jLabel6.setDisplayedMnemonic(GdbMemoryWindow.getString("MN_L_GdbMemoryView").charAt(0));
            jLabel6.setLabelFor(this.tree);
            jLabel6.setVisible(false);
            this.add(jLabel6);
            this.tree.setEnabled(true);
            this.tree.setFocusCycleRoot(true);
            this.tree.setFocusable(true);
            AccessibleContext accessibleContext = this.tree.getAccessibleContext();
            accessibleContext.setAccessibleDescription(GdbMemoryWindow.getString("AD_GdbMemoryView"));
            accessibleContext.setAccessibleName(GdbMemoryWindow.getString("TITLE_GdbMemoryView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemFollowSelectedPointer = new JMenuItem(new FollowSelectedPointerAction());
            this.popup.add(this.menuItemFollowSelectedPointer);
            this.popup.addSeparator();
            ButtonGroup buttonGroup = new ButtonGroup();
            for (n = 0; n < this.memory_formats.length; ++n) {
                this.rbMenuItem = new JRadioButtonMenuItem(this.memory_formats[n]);
                if (n == this.memory_format) {
                    this.rbMenuItem.setSelected(true);
                }
                this.rbMenuItem.addActionListener(this.popupListener);
                buttonGroup.add(this.rbMenuItem);
                this.popup.add(this.rbMenuItem);
            }
            this.popup.addSeparator();
            this.menuItemHideText = new JMenuItem(new HideTextAction());
            this.popup.add(this.menuItemHideText);
            this.popup.addSeparator();
            this.popup.add(new RefreshMemoryAction());
            this.popup.addSeparator();
            this.popup.add(new ShowDynamicHelpPageAction());
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
        }
        if (this.needInitData) {
            this.needInitData = false;
            this.initData();
        }
        int n2 = this.ta.getCaretPosition();
        this.ta.setText(null);
        this.ta.setCaretPosition(0);
        int n3 = this.current_addrs.getItemCount();
        for (n = 0; n < n3; ++n) {
            this.ta.append(this.current_addrs.getItem(n));
        }
        try {
            this.ta.setCaretPosition(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
    }

    protected void FollowSelectedPointer(String string) {
        int n;
        for (n = 0; n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t'); ++n) {
        }
        if (n > 0 && n < string.length()) {
            string = string.substring(n);
        }
        for (n = 0; n < string.length() && string.charAt(n) != ':' && string.charAt(n) != ';' && string.charAt(n) != ' ' && string.charAt(n) != '\t'; ++n) {
        }
        if (n > 0 && n < string.length()) {
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            this.memory_start = string;
        }
        this.showMemory();
    }

    protected void ShowDynamicHelpPage() {
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(GdbMemoryWindow.class);
        }
        if (bundle == null) {
            return string;
        }
        return bundle.getString(string);
    }

    class ShowDynamicHelpPageAction
    extends AbstractAction {
        public ShowDynamicHelpPageAction() {
            super("More Info", new ImageIcon("help.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdbMemoryWindow.this.ShowDynamicHelpPage();
        }
    }

    class HideTextAction
    extends AbstractAction {
        public HideTextAction() {
            super("Hide Text", new ImageIcon("cut.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class RefreshMemoryAction
    extends AbstractAction {
        public RefreshMemoryAction() {
            super("Refresh", new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)GdbMemoryWindow.this.cp_addressList.getEditor().getItem();
            if (string.length() > 0) {
                GdbMemoryWindow.this.memory_start = string;
            }
            GdbMemoryWindow.this.showMemory();
        }
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super("Follow Selected Pointer", new ImageIcon("paste.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdbMemoryWindow.this.FollowSelectedPointer(GdbMemoryWindow.this.selected_text);
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        JPopupMenu popup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (GdbMemoryWindow.this.dontShowText) {
                    GdbMemoryWindow.this.menuItemHideText.setEnabled(false);
                } else {
                    GdbMemoryWindow.this.menuItemHideText.setEnabled(true);
                }
                GdbMemoryWindow.this.selected_text = GdbMemoryWindow.this.ta.getSelectedText();
                if (GdbMemoryWindow.this.selected_text == null) {
                    GdbMemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(false);
                } else {
                    GdbMemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(true);
                }
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            for (int i = 0; i < GdbMemoryWindow.this.memory_formats.length; ++i) {
                if (GdbMemoryWindow.this.memory_formats[i].compareTo(string) != 0) continue;
                GdbMemoryWindow.this.memory_format = i;
                GdbMemoryWindow.this.format_jcb.setSelectedIndex(i);
                GdbMemoryWindow.this.showMemory();
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

