/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public ToggleBreakpointActionProvider(ContextProvider contextProvider) {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if (string.trim().equals("")) {
            return;
        }
        GdbBreakpoint gdbBreakpoint = ToggleBreakpointActionProvider.findBreakpoint(string, n);
        if (gdbBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)gdbBreakpoint);
            return;
        }
        if (Disassembly.isDisasm(string)) {
            Disassembly disassembly = Disassembly.getCurrent();
            if (disassembly == null) {
                return;
            }
            gdbBreakpoint = AddressBreakpoint.create(disassembly.getLineAddress(n));
            gdbBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
            debuggerManager.addBreakpoint((Breakpoint)gdbBreakpoint);
            return;
        }
        gdbBreakpoint = LineBreakpoint.create(string, n);
        gdbBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        debuggerManager.addBreakpoint((Breakpoint)gdbBreakpoint);
    }

    static GdbBreakpoint findBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        Disassembly disassembly = Disassembly.getCurrent();
        boolean bl = Disassembly.isDisasm(string);
        for (Breakpoint breakpoint : breakpointArray) {
            GdbBreakpoint gdbBreakpoint;
            if (!(breakpoint instanceof LineBreakpoint ? (gdbBreakpoint = (LineBreakpoint)breakpoint).getURL().equals(string) && gdbBreakpoint.getLineNumber() == n : bl && breakpoint instanceof AddressBreakpoint && disassembly != null && disassembly.getAddressLine(((AddressBreakpoint)(gdbBreakpoint = (AddressBreakpoint)breakpoint)).getAddress()) == n)) continue;
            return gdbBreakpoint;
        }
        return null;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean bl = (string.equals("text/x-c") || string.equals("text/x-c++") || string.equals("text/x-asm")) && n > 0;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

